/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders;

import com.rabbitmq.qpid.protonj2.codec.DecodeEOFException;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.EncodeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ProtonStreamUtils {
    private static final byte[] EMPTY_ARRAY = new byte[0];

    public static OutputStream writeByte(byte value, OutputStream stream) throws EncodeException {
        try {
            stream.write(value);
        }
        catch (IOException ex) {
            throw new DecodeException("Caught IO error writing to provided stream", ex);
        }
        return stream;
    }

    public static OutputStream writeShort(short value, OutputStream stream) throws EncodeException {
        ProtonStreamUtils.writeByte((byte)(value >>> 8), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 0), stream);
        return stream;
    }

    public static OutputStream writeInt(int value, OutputStream stream) throws EncodeException {
        ProtonStreamUtils.writeByte((byte)(value >>> 24), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 16), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 8), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 0), stream);
        return stream;
    }

    public static OutputStream writeLong(long value, OutputStream stream) throws EncodeException {
        ProtonStreamUtils.writeByte((byte)(value >>> 56), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 48), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 40), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 32), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 24), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 16), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 8), stream);
        ProtonStreamUtils.writeByte((byte)(value >>> 0), stream);
        return stream;
    }

    public static byte[] readBytes(InputStream stream, int length) throws DecodeException {
        try {
            if (length == 0) {
                return EMPTY_ARRAY;
            }
            byte[] payload = new byte[length];
            if (stream.read(payload) < length) {
                throw new DecodeException(String.format("Failed to read requested number of bytes %d: instead only %d bytes were read.", length, payload.length));
            }
            return payload;
        }
        catch (IOException ex) {
            throw new DecodeException("Caught IO error reading from provided stream", ex);
        }
    }

    public static byte readEncodingCode(InputStream stream) throws DecodeException {
        try {
            int result = stream.read();
            if (result >= 0) {
                return (byte)result;
            }
            throw new DecodeEOFException("Cannot read more type information from stream that has reached its end.");
        }
        catch (IOException ex) {
            throw new DecodeException("Caught IO error reading from provided stream", ex);
        }
    }

    public static byte readByte(InputStream stream) throws DecodeException {
        try {
            int result = stream.read();
            if (result >= 0) {
                return (byte)result;
            }
            throw new DecodeException("Unexpectedly reached the end of the provided stream");
        }
        catch (IOException ex) {
            throw new DecodeException("Caught IO error reading from provided stream", ex);
        }
    }

    public static short readShort(InputStream stream) {
        return (short)((ProtonStreamUtils.readByte(stream) & 0xFF) << 8 | (ProtonStreamUtils.readByte(stream) & 0xFF) << 0);
    }

    public static int readInt(InputStream stream) {
        return (ProtonStreamUtils.readByte(stream) & 0xFF) << 24 | (ProtonStreamUtils.readByte(stream) & 0xFF) << 16 | (ProtonStreamUtils.readByte(stream) & 0xFF) << 8 | (ProtonStreamUtils.readByte(stream) & 0xFF) << 0;
    }

    public static long readLong(InputStream stream) {
        return (long)(ProtonStreamUtils.readByte(stream) & 0xFF) << 56 | (long)(ProtonStreamUtils.readByte(stream) & 0xFF) << 48 | (long)(ProtonStreamUtils.readByte(stream) & 0xFF) << 40 | (long)(ProtonStreamUtils.readByte(stream) & 0xFF) << 32 | (long)(ProtonStreamUtils.readByte(stream) & 0xFF) << 24 | (long)(ProtonStreamUtils.readByte(stream) & 0xFF) << 16 | (long)(ProtonStreamUtils.readByte(stream) & 0xFF) << 8 | (long)(ProtonStreamUtils.readByte(stream) & 0xFF) << 0;
    }

    public static float readFloat(InputStream stream) {
        return Float.intBitsToFloat(ProtonStreamUtils.readInt(stream));
    }

    public static double readDouble(InputStream stream) {
        return Double.longBitsToDouble(ProtonStreamUtils.readLong(stream));
    }

    public static InputStream skipBytes(InputStream stream, long amount) {
        try {
            stream.skip(amount);
        }
        catch (IOException ex) {
            throw new DecodeException(String.format("Error while attempting to skip %d bytes in the given InputStream", amount), ex);
        }
        return stream;
    }

    public static InputStream reset(InputStream stream) throws DecodeException {
        try {
            stream.reset();
        }
        catch (IOException ex) {
            throw new DecodeException("Caught IO error when calling reset on provided stream", ex);
        }
        return stream;
    }
}

