/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import java.io.InputStream;
import java.util.UUID;

public final class UUIDTypeDecoder
extends AbstractPrimitiveTypeDecoder<UUID> {
    private static final int BYTES = 16;

    @Override
    public Class<UUID> getTypeClass() {
        return UUID.class;
    }

    @Override
    public int getTypeCode() {
        return 152;
    }

    @Override
    public UUID readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        long msb = buffer.readLong();
        long lsb = buffer.readLong();
        return new UUID(msb, lsb);
    }

    @Override
    public UUID readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        long msb = ProtonStreamUtils.readLong(stream);
        long lsb = ProtonStreamUtils.readLong(stream);
        return new UUID(msb, lsb);
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(16);
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        ProtonStreamUtils.skipBytes(stream, 16L);
    }

    @Override
    public int readSize(ProtonBuffer buffer, DecoderState state) {
        return 16;
    }

    @Override
    public int readSize(InputStream stream, StreamDecoderState state) {
        return 16;
    }
}

