/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DescribedTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.EncodeException;
import com.rabbitmq.qpid.protonj2.codec.Encoder;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.TypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.DeliveryTagEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.PrimitiveTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.ProtonEncoderState;
import com.rabbitmq.qpid.protonj2.codec.encoders.UnknownDescribedTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.ArrayTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.BinaryTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.BooleanTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.ByteTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.CharacterTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.Decimal128TypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.Decimal32TypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.Decimal64TypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.DoubleTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.FloatTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.IntegerTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.ListTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.LongTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.MapTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.NullTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.ShortTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.StringTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.SymbolTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.TimestampTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.UUIDTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.UnsignedByteTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.UnsignedIntegerTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.UnsignedLongTypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.primitives.UnsignedShortTypeEncoder;
import com.rabbitmq.qpid.protonj2.types.Binary;
import com.rabbitmq.qpid.protonj2.types.Decimal128;
import com.rabbitmq.qpid.protonj2.types.Decimal32;
import com.rabbitmq.qpid.protonj2.types.Decimal64;
import com.rabbitmq.qpid.protonj2.types.DeliveryTag;
import com.rabbitmq.qpid.protonj2.types.DescribedType;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedByte;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.UnsignedShort;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ProtonEncoder
implements Encoder {
    private static final ArrayTypeEncoder arrayEncoder = new ArrayTypeEncoder();
    private static final BinaryTypeEncoder binaryEncoder = new BinaryTypeEncoder();
    private static final BooleanTypeEncoder booleanEncoder = new BooleanTypeEncoder();
    private static final ByteTypeEncoder byteEncoder = new ByteTypeEncoder();
    private static final CharacterTypeEncoder charEncoder = new CharacterTypeEncoder();
    private static final Decimal32TypeEncoder decimal32Encoder = new Decimal32TypeEncoder();
    private static final Decimal64TypeEncoder decimal64Encoder = new Decimal64TypeEncoder();
    private static final Decimal128TypeEncoder decimal128Encoder = new Decimal128TypeEncoder();
    private static final DoubleTypeEncoder doubleEncoder = new DoubleTypeEncoder();
    private static final FloatTypeEncoder floatEncoder = new FloatTypeEncoder();
    private static final IntegerTypeEncoder integerEncoder = new IntegerTypeEncoder();
    private static final ListTypeEncoder listEncoder = new ListTypeEncoder();
    private static final LongTypeEncoder longEncoder = new LongTypeEncoder();
    private static final MapTypeEncoder mapEncoder = new MapTypeEncoder();
    private static final NullTypeEncoder nullEncoder = new NullTypeEncoder();
    private static final ShortTypeEncoder shortEncoder = new ShortTypeEncoder();
    private static final StringTypeEncoder stringEncoder = new StringTypeEncoder();
    private static final SymbolTypeEncoder symbolEncoder = new SymbolTypeEncoder();
    private static final TimestampTypeEncoder timestampEncoder = new TimestampTypeEncoder();
    private static final UnknownDescribedTypeEncoder unknownTypeEncoder = new UnknownDescribedTypeEncoder();
    private static final UUIDTypeEncoder uuidEncoder = new UUIDTypeEncoder();
    private static final UnsignedByteTypeEncoder ubyteEncoder = new UnsignedByteTypeEncoder();
    private static final UnsignedShortTypeEncoder ushortEncoder = new UnsignedShortTypeEncoder();
    private static final UnsignedIntegerTypeEncoder uintEncoder = new UnsignedIntegerTypeEncoder();
    private static final UnsignedLongTypeEncoder ulongEncoder = new UnsignedLongTypeEncoder();
    private static final DeliveryTagEncoder deliveryTagEncoder = new DeliveryTagEncoder();
    private ProtonEncoderState singleThreadedState;
    private final Map<Class<?>, TypeEncoder<?>> typeEncoders = new HashMap();

    public ProtonEncoder() {
        this.typeEncoders.put(arrayEncoder.getTypeClass(), arrayEncoder);
        this.typeEncoders.put(binaryEncoder.getTypeClass(), binaryEncoder);
        this.typeEncoders.put(booleanEncoder.getTypeClass(), booleanEncoder);
        this.typeEncoders.put(byteEncoder.getTypeClass(), byteEncoder);
        this.typeEncoders.put(charEncoder.getTypeClass(), charEncoder);
        this.typeEncoders.put(decimal32Encoder.getTypeClass(), decimal32Encoder);
        this.typeEncoders.put(decimal64Encoder.getTypeClass(), decimal64Encoder);
        this.typeEncoders.put(decimal128Encoder.getTypeClass(), decimal128Encoder);
        this.typeEncoders.put(doubleEncoder.getTypeClass(), doubleEncoder);
        this.typeEncoders.put(floatEncoder.getTypeClass(), floatEncoder);
        this.typeEncoders.put(integerEncoder.getTypeClass(), integerEncoder);
        this.typeEncoders.put(listEncoder.getTypeClass(), listEncoder);
        this.typeEncoders.put(longEncoder.getTypeClass(), longEncoder);
        this.typeEncoders.put(mapEncoder.getTypeClass(), mapEncoder);
        this.typeEncoders.put(nullEncoder.getTypeClass(), nullEncoder);
        this.typeEncoders.put(shortEncoder.getTypeClass(), shortEncoder);
        this.typeEncoders.put(stringEncoder.getTypeClass(), stringEncoder);
        this.typeEncoders.put(symbolEncoder.getTypeClass(), symbolEncoder);
        this.typeEncoders.put(timestampEncoder.getTypeClass(), timestampEncoder);
        this.typeEncoders.put(unknownTypeEncoder.getTypeClass(), unknownTypeEncoder);
        this.typeEncoders.put(uuidEncoder.getTypeClass(), uuidEncoder);
        this.typeEncoders.put(ubyteEncoder.getTypeClass(), ubyteEncoder);
        this.typeEncoders.put(ushortEncoder.getTypeClass(), ushortEncoder);
        this.typeEncoders.put(uintEncoder.getTypeClass(), uintEncoder);
        this.typeEncoders.put(ulongEncoder.getTypeClass(), ulongEncoder);
        this.typeEncoders.put(deliveryTagEncoder.getTypeClass(), deliveryTagEncoder);
    }

    @Override
    public ProtonEncoderState newEncoderState() {
        return new ProtonEncoderState(this);
    }

    @Override
    public ProtonEncoderState getCachedEncoderState() {
        ProtonEncoderState state = this.singleThreadedState;
        if (state == null) {
            this.singleThreadedState = state = this.newEncoderState();
        }
        return this.singleThreadedState.reset();
    }

    @Override
    public void writeNull(ProtonBuffer buffer, EncoderState state) throws EncodeException {
        nullEncoder.writeType(buffer, state, null);
    }

    @Override
    public void writeBoolean(ProtonBuffer buffer, EncoderState state, boolean value) throws EncodeException {
        booleanEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeBoolean(ProtonBuffer buffer, EncoderState state, Boolean value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            buffer.writeByte(value != false ? (byte)65 : 66);
        }
    }

    @Override
    public void writeUnsignedByte(ProtonBuffer buffer, EncoderState state, UnsignedByte value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            ubyteEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeUnsignedByte(ProtonBuffer buffer, EncoderState state, byte value) throws EncodeException {
        ubyteEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeUnsignedShort(ProtonBuffer buffer, EncoderState state, UnsignedShort value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            ushortEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeUnsignedShort(ProtonBuffer buffer, EncoderState state, short value) throws EncodeException {
        ushortEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeUnsignedShort(ProtonBuffer buffer, EncoderState state, int value) throws EncodeException {
        if (value < 0) {
            buffer.writeByte((byte)64);
        } else {
            ushortEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeUnsignedInteger(ProtonBuffer buffer, EncoderState state, UnsignedInteger value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            uintEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeUnsignedInteger(ProtonBuffer buffer, EncoderState state, byte value) throws EncodeException {
        uintEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeUnsignedInteger(ProtonBuffer buffer, EncoderState state, int value) throws EncodeException {
        uintEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeUnsignedInteger(ProtonBuffer buffer, EncoderState state, long value) throws EncodeException {
        if (value < 0L) {
            buffer.writeByte((byte)64);
        } else {
            uintEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeUnsignedLong(ProtonBuffer buffer, EncoderState state, byte value) throws EncodeException {
        ulongEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeUnsignedLong(ProtonBuffer buffer, EncoderState state, long value) throws EncodeException {
        ulongEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeUnsignedLong(ProtonBuffer buffer, EncoderState state, UnsignedLong value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            ulongEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeByte(ProtonBuffer buffer, EncoderState state, byte value) throws EncodeException {
        byteEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeByte(ProtonBuffer buffer, EncoderState state, Byte value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            byteEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeShort(ProtonBuffer buffer, EncoderState state, short value) throws EncodeException {
        shortEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeShort(ProtonBuffer buffer, EncoderState state, Short value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            shortEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeInteger(ProtonBuffer buffer, EncoderState state, int value) throws EncodeException {
        integerEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeInteger(ProtonBuffer buffer, EncoderState state, Integer value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            integerEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeLong(ProtonBuffer buffer, EncoderState state, long value) throws EncodeException {
        longEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeLong(ProtonBuffer buffer, EncoderState state, Long value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            longEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeFloat(ProtonBuffer buffer, EncoderState state, float value) throws EncodeException {
        floatEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeFloat(ProtonBuffer buffer, EncoderState state, Float value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            floatEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeDouble(ProtonBuffer buffer, EncoderState state, double value) throws EncodeException {
        doubleEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeDouble(ProtonBuffer buffer, EncoderState state, Double value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            doubleEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeDecimal32(ProtonBuffer buffer, EncoderState state, Decimal32 value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            decimal32Encoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeDecimal64(ProtonBuffer buffer, EncoderState state, Decimal64 value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            decimal64Encoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeDecimal128(ProtonBuffer buffer, EncoderState state, Decimal128 value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            decimal128Encoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeCharacter(ProtonBuffer buffer, EncoderState state, char value) throws EncodeException {
        charEncoder.writeType(buffer, state, Character.valueOf(value));
    }

    @Override
    public void writeCharacter(ProtonBuffer buffer, EncoderState state, Character value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            charEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeTimestamp(ProtonBuffer buffer, EncoderState state, long value) throws EncodeException {
        timestampEncoder.writeType(buffer, state, value);
    }

    @Override
    public void writeTimestamp(ProtonBuffer buffer, EncoderState state, Date value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            timestampEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeUUID(ProtonBuffer buffer, EncoderState state, UUID value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            uuidEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeBinary(ProtonBuffer buffer, EncoderState state, Binary value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            binaryEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeBinary(ProtonBuffer buffer, EncoderState state, ProtonBuffer value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            binaryEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeBinary(ProtonBuffer buffer, EncoderState state, byte[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            binaryEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeDeliveryTag(ProtonBuffer buffer, EncoderState state, DeliveryTag value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            deliveryTagEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeString(ProtonBuffer buffer, EncoderState state, String value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            stringEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeSymbol(ProtonBuffer buffer, EncoderState state, Symbol value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            symbolEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeSymbol(ProtonBuffer buffer, EncoderState state, String value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            symbolEncoder.writeType(buffer, state, Symbol.valueOf(value));
        }
    }

    @Override
    public <T> void writeList(ProtonBuffer buffer, EncoderState state, List<T> value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            listEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public <K, V> void writeMap(ProtonBuffer buffer, EncoderState state, Map<K, V> value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            mapEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeDescribedType(ProtonBuffer buffer, EncoderState state, DescribedType value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            unknownTypeEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, boolean[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, byte[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, short[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, int[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, long[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, float[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, double[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, char[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Decimal32[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Decimal64[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Decimal128[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Symbol[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, UnsignedByte[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, UnsignedShort[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, UnsignedInteger[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, UnsignedLong[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, UUID[] value) throws EncodeException {
        if (value == null) {
            buffer.writeByte((byte)64);
        } else {
            arrayEncoder.writeType(buffer, state, value);
        }
    }

    @Override
    public void writeObject(ProtonBuffer buffer, EncoderState state, Object value) throws EncodeException {
        if (value != null) {
            TypeEncoder<?> encoder = this.typeEncoders.get(value.getClass());
            if (encoder == null) {
                this.writeUnregisteredType(buffer, state, value);
            } else {
                encoder.writeType(buffer, state, value);
            }
        } else {
            buffer.writeByte((byte)64);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeUnregisteredType(ProtonBuffer buffer, EncoderState state, Object value) {
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                if (componentType == Boolean.TYPE) {
                    this.writeArray(buffer, state, (boolean[])value);
                    return;
                } else if (componentType == Byte.TYPE) {
                    this.writeArray(buffer, state, (byte[])value);
                    return;
                } else if (componentType == Short.TYPE) {
                    this.writeArray(buffer, state, (short[])value);
                    return;
                } else if (componentType == Integer.TYPE) {
                    this.writeArray(buffer, state, (int[])value);
                    return;
                } else if (componentType == Long.TYPE) {
                    this.writeArray(buffer, state, (long[])value);
                    return;
                } else if (componentType == Float.TYPE) {
                    this.writeArray(buffer, state, (float[])value);
                    return;
                } else if (componentType == Double.TYPE) {
                    this.writeArray(buffer, state, (double[])value);
                    return;
                } else {
                    if (componentType != Character.TYPE) throw new IllegalArgumentException("Cannot write arrays of type " + componentType.getName());
                    this.writeArray(buffer, state, (char[])value);
                }
                return;
            } else {
                this.writeArray(buffer, state, (Object[])value);
            }
            return;
        } else if (value instanceof List) {
            this.writeList(buffer, state, (List)value);
            return;
        } else if (value instanceof Map) {
            this.writeMap(buffer, state, (Map)value);
            return;
        } else {
            if (!(value instanceof DescribedType)) throw new IllegalArgumentException("Do not know how to write Objects of class " + value.getClass().getName());
            this.writeDescribedType(buffer, state, (DescribedType)value);
        }
    }

    @Override
    public <V> ProtonEncoder registerDescribedTypeEncoder(DescribedTypeEncoder<V> encoder) {
        this.typeEncoders.put(encoder.getTypeClass(), encoder.encoderRegistered(this));
        return this;
    }

    @Override
    public TypeEncoder<?> getTypeEncoder(Object value) {
        if (value == null) {
            return nullEncoder;
        }
        return this.getTypeEncoder(value.getClass(), value);
    }

    @Override
    public TypeEncoder<?> getTypeEncoder(Class<?> typeClass) {
        return this.getTypeEncoder(typeClass, null);
    }

    public TypeEncoder<?> getTypeEncoder(Class<?> typeClass, Object instance) {
        TypeEncoder<?> encoder = this.typeEncoders.get(typeClass);
        if (encoder == null) {
            encoder = this.deduceTypeEncoder(typeClass, instance);
        }
        return encoder;
    }

    private TypeEncoder<?> deduceTypeEncoder(Class<?> typeClass, Object instance) {
        PrimitiveTypeEncoder<Object> encoder = this.typeEncoders.get(typeClass);
        if (typeClass.isArray()) {
            encoder = arrayEncoder;
        } else if (List.class.isAssignableFrom(typeClass)) {
            encoder = listEncoder;
        } else if (Map.class.isAssignableFrom(typeClass)) {
            encoder = mapEncoder;
        } else if (DescribedType.class.isAssignableFrom(typeClass) && encoder == null && instance != null && encoder == null) {
            return unknownTypeEncoder;
        }
        this.typeEncoders.put(typeClass, encoder);
        return encoder;
    }
}

