/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.Encoder;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Accepted;
import com.rabbitmq.qpid.protonj2.types.messaging.Released;
import com.rabbitmq.qpid.protonj2.types.transport.Disposition;

public final class DispositionTypeEncoder
extends AbstractDescribedListTypeEncoder<Disposition> {
    private static final byte[] ACCEPTED_ENCODING = new byte[]{0, 83, Accepted.DESCRIPTOR_CODE.byteValue(), 69};

    @Override
    public UnsignedLong getDescriptorCode() {
        return Disposition.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Disposition.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Disposition> getTypeClass() {
        return Disposition.class;
    }

    private static void writeCheckedUnsignedInteger(long value, ProtonBuffer buffer) {
        if (value == 0L) {
            buffer.writeByte((byte)67);
        } else if (value <= 255L) {
            buffer.writeByte((byte)82);
            buffer.writeByte((byte)value);
        } else {
            buffer.writeByte((byte)112);
            buffer.writeInt((int)value);
        }
    }

    @Override
    public void writeElement(Disposition disposition, int index, ProtonBuffer buffer, Encoder encoder, EncoderState state) {
        block11: {
            block10: {
                if (!disposition.hasElement(index)) break block10;
                switch (index) {
                    case 0: {
                        buffer.writeByte(disposition.getRole().encodingCode());
                        break block11;
                    }
                    case 1: {
                        DispositionTypeEncoder.writeCheckedUnsignedInteger(disposition.getFirst(), buffer);
                        break block11;
                    }
                    case 2: {
                        DispositionTypeEncoder.writeCheckedUnsignedInteger(disposition.getLast(), buffer);
                        break block11;
                    }
                    case 3: {
                        buffer.writeByte(disposition.getSettled() ? (byte)65 : 66);
                        break block11;
                    }
                    case 4: {
                        if (disposition.getState() == Accepted.getInstance()) {
                            buffer.writeBytes(ACCEPTED_ENCODING);
                        } else {
                            encoder.writeObject(buffer, state, disposition.getState());
                        }
                        break block11;
                    }
                    case 5: {
                        buffer.writeByte(disposition.getBatchable() ? (byte)65 : 66);
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Disposition value index: " + index);
                    }
                }
            }
            buffer.writeByte((byte)64);
        }
    }

    @Override
    public byte getListEncoding(Disposition value) {
        if (value.getState() == null) {
            return -64;
        }
        if (value.getState() == Accepted.getInstance() || value.getState() == Released.getInstance()) {
            return -64;
        }
        return -48;
    }

    @Override
    public int getElementCount(Disposition disposition) {
        return disposition.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 2;
    }
}

