/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine;

import com.rabbitmq.qpid.protonj2.engine.AMQPPerformativeEnvelopePool;
import com.rabbitmq.qpid.protonj2.engine.PerformativeEnvelope;
import com.rabbitmq.qpid.protonj2.types.transport.Performative;
import java.util.function.Consumer;

public class OutgoingAMQPEnvelope
extends PerformativeEnvelope<Performative> {
    public static final byte AMQP_FRAME_TYPE = 0;
    private AMQPPerformativeEnvelopePool<OutgoingAMQPEnvelope> pool;
    private Consumer<Performative> payloadToLargeHandler = OutgoingAMQPEnvelope::defaultPayloadToLargeHandler;
    private Runnable frameWriteCompleteHandler;

    OutgoingAMQPEnvelope() {
        this(null);
    }

    OutgoingAMQPEnvelope(AMQPPerformativeEnvelopePool<OutgoingAMQPEnvelope> pool) {
        super((byte)0);
        this.pool = pool;
    }

    public OutgoingAMQPEnvelope setPayloadToLargeHandler(Consumer<Performative> payloadToLargeHandler) {
        this.payloadToLargeHandler = payloadToLargeHandler != null ? payloadToLargeHandler : OutgoingAMQPEnvelope::defaultPayloadToLargeHandler;
        return this;
    }

    public OutgoingAMQPEnvelope handlePayloadToLarge() {
        this.payloadToLargeHandler.accept((Performative)this.getBody());
        return this;
    }

    public OutgoingAMQPEnvelope setFrameWriteCompletionHandler(Runnable frameWriteCompleteHandler) {
        this.frameWriteCompleteHandler = frameWriteCompleteHandler;
        return this;
    }

    public OutgoingAMQPEnvelope handleOutgoingFrameWriteComplete() {
        if (this.frameWriteCompleteHandler != null) {
            this.frameWriteCompleteHandler.run();
        }
        this.release();
        return this;
    }

    public final void release() {
        this.initialize(null, -1, null);
        this.payloadToLargeHandler = OutgoingAMQPEnvelope::defaultPayloadToLargeHandler;
        this.frameWriteCompleteHandler = null;
        if (this.pool != null) {
            this.pool.release(this);
        }
    }

    public <E> void invoke(Performative.PerformativeHandler<E> handler, E context) {
        ((Performative)this.getBody()).invoke(handler, this.getPayload(), this.getChannel(), context);
    }

    private static void defaultPayloadToLargeHandler(Performative performative) {
        throw new IllegalArgumentException(String.format("Cannot transmit performative %s with payload larger than max frame size limit", performative));
    }
}

