/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.EngineHandler;
import com.rabbitmq.qpid.protonj2.engine.EngineHandlerContext;
import com.rabbitmq.qpid.protonj2.engine.HeaderEnvelope;
import com.rabbitmq.qpid.protonj2.engine.IncomingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineFailedException;
import com.rabbitmq.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonConnection;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngineConfiguration;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngineHandlerContext;
import com.rabbitmq.qpid.protonj2.types.transport.AMQPHeader;
import com.rabbitmq.qpid.protonj2.types.transport.Attach;
import com.rabbitmq.qpid.protonj2.types.transport.Begin;
import com.rabbitmq.qpid.protonj2.types.transport.Close;
import com.rabbitmq.qpid.protonj2.types.transport.Detach;
import com.rabbitmq.qpid.protonj2.types.transport.Disposition;
import com.rabbitmq.qpid.protonj2.types.transport.End;
import com.rabbitmq.qpid.protonj2.types.transport.Flow;
import com.rabbitmq.qpid.protonj2.types.transport.Open;
import com.rabbitmq.qpid.protonj2.types.transport.Performative;
import com.rabbitmq.qpid.protonj2.types.transport.Transfer;

public class ProtonPerformativeHandler
implements EngineHandler,
AMQPHeader.HeaderHandler<EngineHandlerContext>,
Performative.PerformativeHandler<EngineHandlerContext> {
    private ProtonEngine engine;
    private ProtonConnection connection;
    private ProtonEngineConfiguration configuration;

    @Override
    public void handlerAdded(EngineHandlerContext context) {
        this.engine = (ProtonEngine)context.engine();
        this.connection = this.engine.connection();
        this.configuration = this.engine.configuration();
        ((ProtonEngineHandlerContext)context).interestMask(2);
    }

    @Override
    public void handleRead(EngineHandlerContext context, HeaderEnvelope header) {
        header.invoke(this, context);
    }

    @Override
    public void handleRead(EngineHandlerContext context, IncomingAMQPEnvelope envelope) {
        try {
            envelope.invoke(this, context);
        }
        finally {
            envelope.release();
        }
    }

    @Override
    public void engineFailed(EngineHandlerContext context, EngineFailedException failure) {
        if (!this.engine.isFailed()) {
            this.engine.engineFailed(failure.getCause());
        }
    }

    @Override
    public void handleAMQPHeader(AMQPHeader header, EngineHandlerContext context) {
        this.configuration.recomputeEffectiveFrameSizeLimits();
        header.invoke(this.connection, this.engine);
    }

    @Override
    public void handleSASLHeader(AMQPHeader header, EngineHandlerContext context) {
        context.fireWrite(HeaderEnvelope.AMQP_HEADER_ENVELOPE);
        throw new ProtocolViolationException("Received SASL Header but no SASL support configured");
    }

    @Override
    public void handleOpen(Open open, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        if (channel != 0) {
            throw new ProtocolViolationException("Open not sent on channel zero");
        }
        this.connection.handleOpen(open, payload, channel, this.engine);
        this.configuration.recomputeEffectiveFrameSizeLimits();
    }

    @Override
    public void handleBegin(Begin begin, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        this.connection.handleBegin(begin, payload, channel, this.engine);
    }

    @Override
    public void handleAttach(Attach attach, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        this.connection.handleAttach(attach, payload, channel, this.engine);
    }

    @Override
    public void handleFlow(Flow flow, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        this.connection.handleFlow(flow, payload, channel, this.engine);
    }

    @Override
    public void handleTransfer(Transfer transfer, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        this.connection.handleTransfer(transfer, payload, channel, this.engine);
    }

    @Override
    public void handleDisposition(Disposition disposition, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        this.connection.handleDisposition(disposition, payload, channel, this.engine);
    }

    @Override
    public void handleDetach(Detach detach, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        this.connection.handleDetach(detach, payload, channel, this.engine);
    }

    @Override
    public void handleEnd(End end, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        this.connection.handleEnd(end, payload, channel, this.engine);
    }

    @Override
    public void handleClose(Close close, ProtonBuffer payload, int channel, EngineHandlerContext context) {
        this.connection.handleClose(close, payload, channel, this.engine);
    }
}

