/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl.sasl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.EngineHandlerContext;
import com.rabbitmq.qpid.protonj2.engine.EngineSaslDriver;
import com.rabbitmq.qpid.protonj2.engine.HeaderEnvelope;
import com.rabbitmq.qpid.protonj2.engine.SASLEnvelope;
import com.rabbitmq.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.engine.impl.sasl.ProtonSaslContext;
import com.rabbitmq.qpid.protonj2.engine.impl.sasl.ProtonSaslHandler;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslContext;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslServerContext;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslServerListener;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.security.SaslChallenge;
import com.rabbitmq.qpid.protonj2.types.security.SaslInit;
import com.rabbitmq.qpid.protonj2.types.security.SaslMechanisms;
import com.rabbitmq.qpid.protonj2.types.security.SaslOutcome;
import com.rabbitmq.qpid.protonj2.types.security.SaslPerformative;
import com.rabbitmq.qpid.protonj2.types.security.SaslResponse;
import com.rabbitmq.qpid.protonj2.types.transport.AMQPHeader;
import java.util.Arrays;
import java.util.Objects;
import javax.security.sasl.SaslException;

final class ProtonSaslServerContext
extends ProtonSaslContext
implements SaslServerContext {
    private SaslServerListener server = new ProtonDefaultSaslServerListener();
    private boolean headerWritten;
    private boolean headerReceived;
    private boolean mechanismsSent;
    private boolean mechanismChosen;
    private boolean responseRequired;
    private final HeaderReadContext headerReadContext = new HeaderReadContext();
    private final HeaderWriteContext headerWriteContext = new HeaderWriteContext();
    private final SaslReadContext saslReadContext = new SaslReadContext();
    private final SaslWriteContext saslWriteContext = new SaslWriteContext();

    ProtonSaslServerContext(ProtonSaslHandler handler) {
        super(handler);
    }

    @Override
    public SaslContext.Role getRole() {
        return SaslContext.Role.SERVER;
    }

    @Override
    public SaslServerContext setListener(SaslServerListener listener) {
        Objects.requireNonNull(listener, "Cannot configure a null SaslServerListener");
        this.server = listener;
        return this;
    }

    @Override
    public SaslServerListener getListener() {
        return this.server;
    }

    @Override
    public SaslServerContext sendMechanisms(Symbol[] mechanisms) {
        Objects.requireNonNull(mechanisms);
        this.saslHandler.engine().pipeline().fireWrite(new SASLEnvelope(new SaslMechanisms().setSaslServerMechanisms(mechanisms)));
        return this;
    }

    @Override
    public SaslServerContext sendChallenge(ProtonBuffer challenge) {
        Objects.requireNonNull(challenge);
        this.saslHandler.engine().pipeline().fireWrite(new SASLEnvelope(new SaslChallenge().setChallenge(challenge)));
        return this;
    }

    @Override
    public SaslServerContext sendOutcome(com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome outcome, ProtonBuffer additional) {
        Objects.requireNonNull(outcome);
        this.saslHandler.engine().pipeline().fireWrite(new SASLEnvelope(new SaslOutcome().setCode(outcome.saslCode()).setAdditionalData(additional)));
        return this;
    }

    @Override
    public SaslServerContext saslFailure(SaslException failure) {
        if (!this.isDone()) {
            this.done(com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome.SASL_PERM);
            this.saslHandler.engine().engineFailed(failure);
        }
        return this;
    }

    @Override
    ProtonSaslServerContext handleContextInitialization(ProtonEngine engine) {
        this.getListener().initialize(this);
        return this;
    }

    @Override
    AMQPHeader.HeaderHandler<EngineHandlerContext> headerReadContext() {
        return this.headerReadContext;
    }

    @Override
    AMQPHeader.HeaderHandler<EngineHandlerContext> headerWriteContext() {
        return this.headerWriteContext;
    }

    @Override
    SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> saslReadContext() {
        return this.saslReadContext;
    }

    @Override
    SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> saslWriteContext() {
        return this.saslWriteContext;
    }

    public static class ProtonDefaultSaslServerListener
    implements SaslServerListener {
        private static final Symbol[] PLAIN = new Symbol[]{Symbol.valueOf("PLAIN")};

        @Override
        public void handleSaslHeader(SaslServerContext context, AMQPHeader header) {
            context.sendMechanisms(PLAIN);
        }

        @Override
        public void handleSaslInit(SaslServerContext context, Symbol mechanism, ProtonBuffer initResponse) {
            context.sendOutcome(com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome.SASL_AUTH, null);
        }

        @Override
        public void handleSaslResponse(SaslServerContext context, ProtonBuffer response) {
            throw new ProtocolViolationException("SASL Response arrived when no challenge was issued or supported.");
        }
    }

    private final class SaslWriteContext
    implements SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> {
        private SaslWriteContext() {
        }

        @Override
        public void handleMechanisms(SaslMechanisms saslMechanisms, EngineHandlerContext context) {
            if (ProtonSaslServerContext.this.mechanismsSent) {
                throw new ProtocolViolationException("SASL Mechanisms already sent to client");
            }
            context.fireWrite(new SASLEnvelope(saslMechanisms));
            ProtonSaslServerContext.this.serverMechanisms = Arrays.copyOf(saslMechanisms.getSaslServerMechanisms(), saslMechanisms.getSaslServerMechanisms().length);
            ProtonSaslServerContext.this.mechanismsSent = true;
        }

        @Override
        public void handleInit(SaslInit saslInit, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Init Frame write attempted on SASL Server.");
        }

        @Override
        public void handleChallenge(SaslChallenge saslChallenge, EngineHandlerContext context) {
            if (!ProtonSaslServerContext.this.headerWritten || !ProtonSaslServerContext.this.mechanismsSent || ProtonSaslServerContext.this.responseRequired) {
                throw new ProtocolViolationException("SASL Challenge sent when state does not allow it");
            }
            context.fireWrite(new SASLEnvelope(saslChallenge));
            ProtonSaslServerContext.this.responseRequired = true;
        }

        @Override
        public void handleResponse(SaslResponse saslResponse, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Response Frame write attempted on SASL Server.");
        }

        @Override
        public void handleOutcome(SaslOutcome saslOutcome, EngineHandlerContext context) {
            if (!ProtonSaslServerContext.this.headerWritten || !ProtonSaslServerContext.this.mechanismsSent || ProtonSaslServerContext.this.responseRequired) {
                throw new ProtocolViolationException("SASL Outcome sent when state does not allow it");
            }
            ProtonSaslServerContext.this.done(com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome.valueOf(saslOutcome.getCode().getValue().byteValue()));
            context.fireWrite(new SASLEnvelope(saslOutcome));
            context.engine().pipeline().remove(ProtonSaslServerContext.this.saslHandler);
        }
    }

    private final class SaslReadContext
    implements SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> {
        private SaslReadContext() {
        }

        @Override
        public void handleMechanisms(SaslMechanisms saslMechanisms, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Mechanisms Frame received at SASL Server.");
        }

        @Override
        public void handleInit(SaslInit saslInit, EngineHandlerContext context) {
            if (ProtonSaslServerContext.this.mechanismChosen) {
                throw new ProtocolViolationException("SASL Handler received second SASL Init");
            }
            ProtonSaslServerContext.this.hostname = saslInit.getHostname();
            ProtonSaslServerContext.this.chosenMechanism = saslInit.getMechanism();
            ProtonSaslServerContext.this.mechanismChosen = true;
            ProtonSaslServerContext.this.server.handleSaslInit(ProtonSaslServerContext.this, ProtonSaslServerContext.this.chosenMechanism, saslInit.getInitialResponse());
        }

        @Override
        public void handleChallenge(SaslChallenge saslChallenge, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Challenge Frame received at SASL Server.");
        }

        @Override
        public void handleResponse(SaslResponse saslResponse, EngineHandlerContext context) {
            if (!ProtonSaslServerContext.this.responseRequired) {
                throw new ProtocolViolationException("SASL Response received when none was expected");
            }
            ProtonSaslServerContext.this.server.handleSaslResponse(ProtonSaslServerContext.this, saslResponse.getResponse());
        }

        @Override
        public void handleOutcome(SaslOutcome saslOutcome, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Outcome Frame received at SASL Server.");
        }
    }

    private final class HeaderWriteContext
    implements AMQPHeader.HeaderHandler<EngineHandlerContext> {
        private HeaderWriteContext() {
        }

        @Override
        public void handleAMQPHeader(AMQPHeader header, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected AMQP Header write before SASL Authentication completed.");
        }

        @Override
        public void handleSASLHeader(AMQPHeader header, EngineHandlerContext context) {
            if (ProtonSaslServerContext.this.headerWritten) {
                throw new ProtocolViolationException("Unexpected SASL write following a previous header send.");
            }
            ProtonSaslServerContext.this.headerWritten = true;
            context.fireWrite(HeaderEnvelope.SASL_HEADER_ENVELOPE);
        }
    }

    private final class HeaderReadContext
    implements AMQPHeader.HeaderHandler<EngineHandlerContext> {
        private HeaderReadContext() {
        }

        @Override
        public void handleAMQPHeader(AMQPHeader header, EngineHandlerContext context) {
            context.fireWrite(HeaderEnvelope.SASL_HEADER_ENVELOPE);
            throw new ProtocolViolationException("Unexpected AMQP Header before SASL Authentication completed.");
        }

        @Override
        public void handleSASLHeader(AMQPHeader header, EngineHandlerContext context) {
            if (ProtonSaslServerContext.this.headerReceived) {
                throw new ProtocolViolationException("Unexpected second SASL Header read before SASL Authentication completed.");
            }
            ProtonSaslServerContext.this.headerReceived = true;
            if (!ProtonSaslServerContext.this.headerWritten) {
                context.fireWrite(HeaderEnvelope.SASL_HEADER_ENVELOPE);
                ProtonSaslServerContext.this.headerWritten = true;
                ProtonSaslServerContext.this.state = EngineSaslDriver.SaslState.AUTHENTICATING;
            }
            ProtonSaslServerContext.this.server.handleSaslHeader(ProtonSaslServerContext.this, header);
        }
    }
}

