/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.sasl.client;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.EventHandler;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslClientContext;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslClientListener;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.Mechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.SaslCredentialsProvider;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.SaslMechanismSelector;
import com.rabbitmq.qpid.protonj2.engine.util.StringUtils;
import com.rabbitmq.qpid.protonj2.logging.ProtonLogger;
import com.rabbitmq.qpid.protonj2.logging.ProtonLoggerFactory;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import java.util.Objects;
import javax.security.sasl.SaslException;

public class SaslAuthenticator
implements SaslClientListener {
    private static final ProtonLogger LOG = ProtonLoggerFactory.getLogger(SaslAuthenticator.class);
    private final SaslMechanismSelector selector;
    private final SaslCredentialsProvider credentials;
    private EventHandler<SaslOutcome> saslCompleteHandler;
    private Mechanism chosenMechanism;

    public SaslAuthenticator(SaslCredentialsProvider credentials) {
        this(new SaslMechanismSelector(), credentials);
    }

    public SaslAuthenticator(SaslMechanismSelector selector, SaslCredentialsProvider credentials) {
        Objects.requireNonNull(selector, "A SASL Mechanism selector implementation is required");
        Objects.requireNonNull(credentials, "A SASL Credentials provider implementation is required");
        this.credentials = credentials;
        this.selector = selector;
    }

    public SaslAuthenticator saslComplete(EventHandler<SaslOutcome> saslCompleteEventHandler) {
        this.saslCompleteHandler = saslCompleteEventHandler;
        return this;
    }

    @Override
    public void handleSaslMechanisms(SaslClientContext context, Symbol[] mechanisms) {
        this.chosenMechanism = this.selector.select(mechanisms, this.credentials);
        if (this.chosenMechanism == null) {
            context.saslFailure(new SaslException("Could not find a suitable SASL Mechanism. No supported mechanism, or none usable with the available credentials. Server offered: " + String.valueOf(StringUtils.toStringSet(mechanisms))));
            return;
        }
        LOG.debug("SASL Negotiations proceeding using selected mechanisms: {}", (Object)this.chosenMechanism);
        ProtonBuffer initialResponse = null;
        try {
            initialResponse = this.chosenMechanism.getInitialResponse(this.credentials);
        }
        catch (SaslException se) {
            context.saslFailure(se);
        }
        catch (Throwable unknown) {
            context.saslFailure(new SaslException("Unknown error while fetching initial response", unknown));
        }
        context.sendChosenMechanism(this.chosenMechanism.getName(), this.credentials.vhost(), initialResponse);
    }

    @Override
    public void handleSaslChallenge(SaslClientContext context, ProtonBuffer challenge) {
        ProtonBuffer response = null;
        try {
            response = this.chosenMechanism.getChallengeResponse(this.credentials, challenge);
        }
        catch (SaslException se) {
            context.saslFailure(se);
        }
        catch (Exception unknown) {
            context.saslFailure(new SaslException("Unknown error while fetching challenge response", unknown));
        }
        context.sendResponse(response);
    }

    @Override
    public void handleSaslOutcome(SaslClientContext context, SaslOutcome outcome, ProtonBuffer additional) {
        try {
            this.chosenMechanism.verifyCompletion();
            if (this.saslCompleteHandler != null) {
                this.saslCompleteHandler.handle(outcome);
            }
        }
        catch (SaslException se) {
            context.saslFailure(se);
        }
        catch (Exception unknown) {
            context.saslFailure(new SaslException("Unknown error while verifying SASL negotiations completion", unknown));
        }
    }
}

