/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.sasl.client;

import com.rabbitmq.qpid.protonj2.engine.sasl.client.Mechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.SaslCredentialsProvider;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.SaslMechanisms;
import com.rabbitmq.qpid.protonj2.engine.util.StringUtils;
import com.rabbitmq.qpid.protonj2.logging.ProtonLogger;
import com.rabbitmq.qpid.protonj2.logging.ProtonLoggerFactory;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class SaslMechanismSelector {
    private static final ProtonLogger LOG = ProtonLoggerFactory.getLogger(SaslMechanismSelector.class);
    private final Set<Symbol> allowedMechanisms;

    public SaslMechanismSelector() {
        this((Set<Symbol>)null);
    }

    public SaslMechanismSelector(Collection<String> allowed) {
        this.allowedMechanisms = allowed != null ? StringUtils.toSymbolSet(allowed) : Collections.EMPTY_SET;
    }

    public SaslMechanismSelector(Set<Symbol> allowed) {
        this.allowedMechanisms = allowed != null ? allowed : Collections.EMPTY_SET;
    }

    public Set<Symbol> getAllowedMechanisms() {
        return Collections.unmodifiableSet(this.allowedMechanisms);
    }

    public Mechanism select(Symbol[] serverMechs, SaslCredentialsProvider credentials) {
        LinkedHashSet<Symbol> candidates = new LinkedHashSet<Symbol>(serverMechs.length);
        for (Symbol serverMech : serverMechs) {
            candidates.add(serverMech);
        }
        if (!this.allowedMechanisms.isEmpty()) {
            candidates.retainAll(this.allowedMechanisms);
        }
        for (Symbol match : candidates) {
            LOG.trace("Attempting to match offered mechanism {} with supported and configured mechanisms", (Object)match);
            try {
                Mechanism mechanism = this.createMechanism(match, credentials);
                if (mechanism == null) {
                    LOG.debug("Skipping {} mechanism as no implementation could be created to support it", (Object)match);
                    continue;
                }
                if (!this.isApplicable(mechanism, credentials)) {
                    LOG.trace("Skipping {} mechanism as it is not applicable", (Object)mechanism);
                    continue;
                }
                return mechanism;
            }
            catch (Exception error) {
                LOG.warn("Caught exception while trying to create SASL mechanism {}: {}", (Object)match, (Object)error.getMessage());
            }
        }
        return null;
    }

    protected Mechanism createMechanism(Symbol name, SaslCredentialsProvider credentials) {
        return SaslMechanisms.valueOf(name).createMechanism();
    }

    protected boolean isApplicable(Mechanism candidate, SaslCredentialsProvider credentials) {
        Objects.requireNonNull(candidate, "Candidate Mechanism to validate must not be null");
        if (!candidate.isApplicable(credentials)) {
            LOG.debug("Skipping {} mechanism because the available credentials are not sufficient", (Object)candidate.getName());
            return false;
        }
        if (this.allowedMechanisms.isEmpty()) {
            return candidate.isEnabledByDefault();
        }
        return this.allowedMechanisms.contains(candidate.getName());
    }
}

