/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.util;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;

public class RingQueue<E>
extends AbstractQueue<E> {
    private int read = 0;
    private int write = -1;
    private int size;
    private final Object[] backingArray;

    public RingQueue(int queueSize) {
        this.backingArray = new Object[queueSize];
    }

    public RingQueue(Collection<E> collection) {
        this.backingArray = new Object[collection.size()];
        collection.forEach(value -> this.offer(value));
    }

    @Override
    public boolean offer(E e) {
        if (this.isFull()) {
            return false;
        }
        this.write = RingQueue.advance(this.write, this.backingArray.length);
        ++this.size;
        this.backingArray[this.write] = e;
        return true;
    }

    @Override
    public E poll() {
        Object result;
        if (this.isEmpty()) {
            result = null;
        } else {
            result = this.backingArray[this.read];
            this.backingArray[this.read] = null;
            this.read = RingQueue.advance(this.read, this.backingArray.length);
            --this.size;
        }
        return (E)result;
    }

    public E poll(Supplier<E> createOnEmpty) {
        if (this.isEmpty()) {
            return createOnEmpty.get();
        }
        return this.poll();
    }

    @Override
    public E peek() {
        return (E)(this.isEmpty() ? null : this.backingArray[this.read]);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Objects.requireNonNull(c, "Given collection to add was null");
        if (c == this) {
            throw new IllegalArgumentException("Cannot add a Queue to itself");
        }
        if (c.size() > this.backingArray.length - this.size) {
            throw new IllegalStateException("Insufficient space to add all elements of the collection to the queue");
        }
        c.forEach(value -> this.offer(value));
        return !c.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove other than from the Queue head methods");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        throw new UnsupportedOperationException("Cannot remove other than from the Queue head methods");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        throw new UnsupportedOperationException("Cannot remove other than from the Queue head methods");
    }

    @Override
    public Iterator<E> iterator() {
        return new RingIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.read = 0;
        this.write = -1;
        this.size = 0;
        Arrays.fill(this.backingArray, null);
    }

    @Override
    public boolean contains(Object value) {
        int count;
        int position = this.read;
        if (value == null) {
            for (count = this.size; count > 0; --count) {
                if (this.backingArray[position] == null) {
                    return true;
                }
                position = RingQueue.advance(position, this.backingArray.length);
            }
        } else {
            while (count > 0) {
                if (value.equals(this.backingArray[position])) {
                    return true;
                }
                position = RingQueue.advance(position, this.backingArray.length);
                --count;
            }
        }
        return false;
    }

    private boolean isFull() {
        return this.size == this.backingArray.length;
    }

    private static int advance(int value, int limit) {
        return ++value % limit;
    }

    private class RingIterator
    implements Iterator<E> {
        private int expectedSize;
        private int expectedReadIndex;
        private E nextElement;
        private int position;
        private int remaining;
        private E lastReturned;

        public RingIterator() {
            this.expectedSize = RingQueue.this.size;
            this.expectedReadIndex = RingQueue.this.read;
            this.nextElement = RingQueue.this.peek();
            this.position = RingQueue.this.read;
            this.remaining = RingQueue.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            Object entry = this.nextElement;
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedSize != RingQueue.this.size || this.expectedReadIndex != RingQueue.this.read) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = entry;
            if (--this.remaining != 0) {
                this.position = RingQueue.advance(this.position, RingQueue.this.backingArray.length);
                this.nextElement = RingQueue.this.backingArray[this.position];
            } else {
                this.nextElement = null;
            }
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

