/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.util;

import com.rabbitmq.qpid.protonj2.engine.util.RingQueue;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class SplayMap<E>
implements NavigableMap<UnsignedInteger, E> {
    protected static final Comparator<UnsignedInteger> COMPARATOR = new UnsignedComparator();
    protected static final Comparator<UnsignedInteger> REVERSE_COMPARATOR = Collections.reverseOrder(COMPARATOR);
    protected final int DEFAULT_ENTRY_POOL_SIZE = 64;
    protected final RingQueue<SplayedEntry<E>> entryPool = new RingQueue(64);
    protected int entriesInExistence = 0;
    protected SplayedEntry<E> root;
    protected int size;
    protected int modCount;
    protected NavigableSet<UnsignedInteger> keySet;
    protected Collection<E> values;
    protected Set<Map.Entry<UnsignedInteger, E>> entrySet;
    protected NavigableMap<UnsignedInteger, E> descendingMapView;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public E get(int key) {
        if (this.root == null) {
            return null;
        }
        if (this.root.key == key) {
            return this.root.value;
        }
        this.root = SplayMap.splay(this.root, key);
        if (this.root.key == key) {
            return this.root.value;
        }
        return null;
    }

    public E getOrDefault(int key, E defaultValue) {
        E result = this.get(key);
        if (result == null && this.root != null && this.root.key == key) {
            return null;
        }
        return defaultValue;
    }

    @Override
    public E put(int key, E value) {
        E oldValue = null;
        if (this.root == null) {
            this.root = this.entryPool.poll(() -> this.createEntry()).initialize(key, value);
        } else {
            this.root = SplayMap.splay(this.root, key);
            if (this.root.key == key) {
                oldValue = this.root.value;
                this.root.value = value;
            } else {
                SplayedEntry<E> node = this.entryPool.poll(() -> this.createEntry()).initialize(key, value);
                if (SplayMap.compare(key, this.root.key) < 0) {
                    this.shiftRootRightOf(node);
                } else {
                    this.shiftRootLeftOf(node);
                }
            }
        }
        if (oldValue == null) {
            this.entryAdded(this.root);
            ++this.size;
        }
        ++this.modCount;
        return oldValue;
    }

    @Override
    public E putIfAbsent(int key, E value) {
        if (this.root == null) {
            this.root = this.entryPool.poll(() -> this.createEntry()).initialize(key, value);
        } else {
            this.root = SplayMap.splay(this.root, key);
            if (this.root.key == key) {
                return this.root.value;
            }
            SplayedEntry<E> node = this.entryPool.poll(() -> this.createEntry()).initialize(key, value);
            if (SplayMap.compare(key, this.root.key) < 0) {
                this.shiftRootRightOf(node);
            } else {
                this.shiftRootLeftOf(node);
            }
        }
        this.entryAdded(this.root);
        ++this.size;
        ++this.modCount;
        return null;
    }

    private void shiftRootRightOf(SplayedEntry<E> newRoot) {
        newRoot.right = this.root;
        newRoot.left = this.root.left;
        if (newRoot.left != null) {
            newRoot.left.parent = newRoot;
        }
        this.root.left = null;
        this.root.parent = newRoot;
        this.root = newRoot;
    }

    private void shiftRootLeftOf(SplayedEntry<E> newRoot) {
        newRoot.left = this.root;
        newRoot.right = this.root.right;
        if (newRoot.right != null) {
            newRoot.right.parent = newRoot;
        }
        this.root.right = null;
        this.root.parent = newRoot;
        this.root = newRoot;
    }

    public E remove(UnsignedInteger key) {
        return this.remove(key.intValue());
    }

    public E remove(int key) {
        if (this.root == null) {
            return null;
        }
        this.root = SplayMap.splay(this.root, key);
        if (this.root.key != key) {
            return null;
        }
        Object removed = this.root.value;
        this.delete(this.root);
        return removed;
    }

    public boolean containsKey(int key) {
        if (this.root == null) {
            return false;
        }
        this.root = SplayMap.splay(this.root, key);
        return this.root.key == key;
    }

    @Override
    public E put(UnsignedInteger key, E value) {
        return this.put(key.intValue(), value);
    }

    @Override
    public E putIfAbsent(UnsignedInteger key, E value) {
        return this.putIfAbsent(key.intValue(), value);
    }

    @Override
    public E get(Object key) {
        return this.get(((Number)Number.class.cast(key)).intValue());
    }

    @Override
    public E getOrDefault(Object key, E defaultValue) {
        return this.getOrDefault(((Number)Number.class.cast(key)).intValue(), defaultValue);
    }

    @Override
    public E remove(Object key) {
        return this.remove(((Number)Number.class.cast(key)).intValue());
    }

    @Override
    public boolean containsKey(Object key) {
        Number numericKey = (Number)key;
        return this.containsKey(numericKey.intValue());
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
    }

    @Override
    public void putAll(Map<? extends UnsignedInteger, ? extends E> source) {
        for (Map.Entry<UnsignedInteger, E> entry : source.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsValue(Object value) {
        SplayedEntry<E> entry = SplayMap.firstEntry(this.root);
        while (entry != null) {
            if (entry.valueEquals(value)) {
                return true;
            }
            entry = SplayMap.successor(entry);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        SplayedEntry<E> entry = SplayMap.firstEntry(this.root);
        while (entry != null) {
            hash += entry.hashCode();
            entry = SplayMap.successor(entry);
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            SplayedEntry<E> entry = SplayMap.firstEntry(this.root);
            while (entry != null) {
                UnsignedInteger key = entry.getKey();
                E value = entry.getValue();
                if (value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))) {
                    return false;
                }
                entry = SplayMap.successor(entry);
            }
        }
        catch (ClassCastException | NullPointerException ignored) {
            return false;
        }
        return true;
    }

    @Override
    public Set<UnsignedInteger> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public Collection<E> values() {
        if (this.values == null) {
            this.values = new SplayMapValues();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<UnsignedInteger, E>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new SplayMapEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public void forEach(BiConsumer<? super UnsignedInteger, ? super E> action) {
        Objects.requireNonNull(action);
        SplayedEntry<E> entry = SplayMap.firstEntry(this.root);
        while (entry != null) {
            action.accept(entry.getKey(), entry.getValue());
            entry = SplayMap.successor(entry);
        }
    }

    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        SplayedEntry<E> entry = SplayMap.firstEntry(this.root);
        while (entry != null) {
            action.accept(entry.getValue());
            entry = SplayMap.successor(entry);
        }
    }

    @Override
    public void replaceAll(BiFunction<? super UnsignedInteger, ? super E, ? extends E> function) {
        Objects.requireNonNull(function, "The replacement function parameter cannot be null");
        int initialModCount = this.modCount;
        SplayedEntry<E> entry = SplayMap.firstEntry(this.root);
        while (entry != null) {
            entry.value = function.apply(entry.getKey(), entry.value);
            entry = SplayMap.successor(entry);
        }
        if (this.modCount != initialModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        Number numericKey = (Number)key;
        return this.remove(numericKey.intValue(), value);
    }

    public boolean remove(int key, Object value) {
        this.root = SplayMap.splay(this.root, key);
        if (this.root == null || this.root.key != key || !Objects.equals(this.root.value, value)) {
            return false;
        }
        this.delete(this.root);
        return true;
    }

    @Override
    public boolean replace(UnsignedInteger key, E oldValue, E newValue) {
        return this.replace(key.intValue(), oldValue, newValue);
    }

    @Override
    public boolean replace(int key, E oldValue, E newValue) {
        this.root = SplayMap.splay(this.root, key);
        if (this.root == null || this.root.key != key || !Objects.equals(this.root.value, oldValue)) {
            return false;
        }
        this.root.setValue(newValue);
        return true;
    }

    @Override
    public E replace(UnsignedInteger key, E value) {
        return this.replace(key.intValue(), value);
    }

    @Override
    public E replace(int key, E value) {
        this.root = SplayMap.splay(this.root, key);
        if (this.root == null || this.root.key != key || this.root.value == null) {
            return null;
        }
        return this.root.setValue(value);
    }

    protected void entryAdded(SplayedEntry<E> newEntry) {
    }

    protected void entryDeleted(SplayedEntry<E> deletedEntry) {
    }

    private static <E> SplayedEntry<E> rightRotate(SplayedEntry<E> node) {
        SplayedEntry rotated = node.left;
        node.left = rotated.right;
        rotated.right = node;
        rotated.parent = node.parent;
        node.parent = rotated;
        if (node.left != null) {
            node.left.parent = node;
        }
        return rotated;
    }

    private static <E> SplayedEntry<E> leftRotate(SplayedEntry<E> node) {
        SplayedEntry rotated = node.right;
        node.right = rotated.left;
        rotated.left = node;
        rotated.parent = node.parent;
        node.parent = rotated;
        if (node.right != null) {
            node.right.parent = node;
        }
        return rotated;
    }

    private static <E> SplayedEntry<E> splay(SplayedEntry<E> root, int key) {
        if (root == null || root.key == key) {
            return root;
        }
        SplayedEntry lessThanKeyRoot = null;
        SplayedEntry<E> lessThanKeyNode = null;
        SplayedEntry<E> greaterThanKeyRoot = null;
        SplayedEntry<E> greaterThanKeyNode = null;
        while (true) {
            if (SplayMap.compare(key, root.key) < 0) {
                if (root.left != null && SplayMap.compare(key, root.left.key) < 0) {
                    root = SplayMap.rightRotate(root);
                }
                if (root.left == null) break;
                if (greaterThanKeyRoot == null) {
                    greaterThanKeyRoot = greaterThanKeyNode = root;
                } else {
                    greaterThanKeyNode.left = root;
                    greaterThanKeyNode.left.parent = greaterThanKeyNode;
                    greaterThanKeyNode = root;
                }
                root = root.left;
                root.parent = null;
                continue;
            }
            if (SplayMap.compare(key, root.key) <= 0) break;
            if (root.right != null && SplayMap.compare(key, root.right.key) > 0) {
                root = SplayMap.leftRotate(root);
            }
            if (root.right == null) break;
            if (lessThanKeyRoot == null) {
                lessThanKeyNode = root;
                lessThanKeyRoot = lessThanKeyNode;
            } else {
                lessThanKeyNode.right = root;
                lessThanKeyNode.right.parent = lessThanKeyNode;
                lessThanKeyNode = root;
            }
            root = root.right;
            root.parent = null;
        }
        if (lessThanKeyRoot == null) {
            lessThanKeyRoot = root.left;
        } else {
            lessThanKeyNode.right = root.left;
            if (lessThanKeyNode.right != null) {
                lessThanKeyNode.right.parent = lessThanKeyNode;
            }
        }
        if (greaterThanKeyRoot == null) {
            greaterThanKeyRoot = root.right;
        } else {
            greaterThanKeyNode.left = root.right;
            if (greaterThanKeyNode.left != null) {
                greaterThanKeyNode.left.parent = greaterThanKeyNode;
            }
        }
        root.left = lessThanKeyRoot;
        if (root.left != null) {
            root.left.parent = root;
        }
        root.right = greaterThanKeyRoot;
        if (root.right != null) {
            root.right.parent = root;
        }
        return root;
    }

    protected void delete(SplayedEntry<E> node) {
        SplayedEntry grandparent = node.parent;
        SplayedEntry replacement = node.right;
        if (node.left != null) {
            replacement = SplayMap.splay(node.left, node.key);
            replacement.right = node.right;
            if (replacement.right != null) {
                replacement.right.parent = replacement;
            }
        }
        if (replacement != null) {
            replacement.parent = grandparent;
        }
        if (grandparent != null) {
            if (grandparent.left == node) {
                grandparent.left = replacement;
            } else {
                grandparent.right = replacement;
            }
        } else {
            this.root = replacement;
        }
        node.parent = null;
        node.right = null;
        node.left = null;
        this.entryPool.offer(node);
        this.entryDeleted(node);
        --this.size;
        ++this.modCount;
    }

    private SplayedEntry<E> findEntry(int key) {
        if (this.root == null) {
            return null;
        }
        if (this.root.key == key) {
            return this.root;
        }
        this.root = SplayMap.splay(this.root, key);
        if (this.root.key == key) {
            return this.root;
        }
        return null;
    }

    private static <E> SplayedEntry<E> firstEntry(SplayedEntry<E> node) {
        SplayedEntry<E> firstEntry = node;
        if (firstEntry != null) {
            while (firstEntry.left != null) {
                firstEntry = firstEntry.left;
            }
        }
        return firstEntry;
    }

    private static <E> SplayedEntry<E> lastEntry(SplayedEntry<E> node) {
        SplayedEntry<E> lastEntry = node;
        if (lastEntry != null) {
            while (lastEntry.right != null) {
                lastEntry = lastEntry.right;
            }
        }
        return lastEntry;
    }

    private static <E> SplayedEntry<E> successor(SplayedEntry<E> node) {
        if (node == null) {
            return null;
        }
        if (node.right != null) {
            SplayedEntry result = node.right;
            while (result.left != null) {
                result = result.left;
            }
            return result;
        }
        SplayedEntry parent = node.parent;
        SplayedEntry<E> child = node;
        while (parent != null && child == parent.right) {
            child = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static <E> SplayedEntry<E> predecessor(SplayedEntry<E> node) {
        if (node == null) {
            return null;
        }
        if (node.left != null) {
            SplayedEntry result = node.left;
            while (result.right != null) {
                result = result.right;
            }
            return result;
        }
        SplayedEntry parent = node.parent;
        SplayedEntry<E> child = node;
        while (parent != null && child == parent.left) {
            child = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static int compare(int lhs, int rhs) {
        return Integer.compareUnsigned(lhs, rhs);
    }

    private SplayedEntry<E> createEntry() {
        return new SplayedEntry();
    }

    protected static <V> ImmutableSplayMapEntry<V> export(SplayedEntry<V> entry) {
        return entry == null ? null : new ImmutableSplayMapEntry<V>(entry);
    }

    protected static Comparator<? super UnsignedInteger> reverseComparator() {
        return REVERSE_COMPARATOR;
    }

    @Override
    public Comparator<? super UnsignedInteger> comparator() {
        return COMPARATOR;
    }

    @Override
    public UnsignedInteger firstKey() {
        return this.isEmpty() ? null : SplayMap.firstEntry(this.root).getKey();
    }

    @Override
    public UnsignedInteger lastKey() {
        return this.isEmpty() ? null : SplayMap.lastEntry(this.root).getKey();
    }

    public ImmutableSplayMapEntry<E> firstEntry() {
        return SplayMap.export(SplayMap.firstEntry(this.root));
    }

    public ImmutableSplayMapEntry<E> lastEntry() {
        return SplayMap.export(SplayMap.lastEntry(this.root));
    }

    public ImmutableSplayMapEntry<E> pollFirstEntry() {
        SplayedEntry<E> firstEntry = SplayMap.firstEntry(this.root);
        if (firstEntry != null) {
            this.delete(firstEntry);
        }
        return SplayMap.export(firstEntry);
    }

    public ImmutableSplayMapEntry<E> pollLastEntry() {
        SplayedEntry<E> lastEntry = SplayMap.lastEntry(this.root);
        if (lastEntry != null) {
            this.delete(lastEntry);
        }
        return SplayMap.export(lastEntry);
    }

    public ImmutableSplayMapEntry<E> lowerEntry(UnsignedInteger key) {
        return SplayMap.export(this.splayToLowerEntry(key.intValue()));
    }

    @Override
    public UnsignedInteger lowerKey(UnsignedInteger key) {
        SplayedEntry<E> result = this.splayToLowerEntry(key.intValue());
        return result == null ? null : result.getKey();
    }

    private SplayedEntry<E> splayToLowerEntry(int key) {
        this.root = SplayMap.splay(this.root, key);
        while (this.root != null && SplayMap.compare(this.root.getIntKey(), key) >= 0) {
            SplayedEntry<E> pred = SplayMap.predecessor(this.root);
            if (pred != null) {
                this.root = SplayMap.splay(this.root, pred.key);
                continue;
            }
            return null;
        }
        return this.root;
    }

    public ImmutableSplayMapEntry<E> higherEntry(UnsignedInteger key) {
        return SplayMap.export(this.splayToHigherEntry(key.intValue()));
    }

    @Override
    public UnsignedInteger higherKey(UnsignedInteger key) {
        SplayedEntry<E> result = this.splayToHigherEntry(key.intValue());
        return result == null ? null : result.getKey();
    }

    private SplayedEntry<E> splayToHigherEntry(int key) {
        this.root = SplayMap.splay(this.root, key);
        while (this.root != null && SplayMap.compare(this.root.getIntKey(), key) <= 0) {
            SplayedEntry<E> succ = SplayMap.successor(this.root);
            if (succ != null) {
                this.root = SplayMap.splay(this.root, succ.key);
                continue;
            }
            return null;
        }
        return this.root;
    }

    public ImmutableSplayMapEntry<E> floorEntry(UnsignedInteger key) {
        return SplayMap.export(this.splayToFloorEntry(key.intValue()));
    }

    @Override
    public UnsignedInteger floorKey(UnsignedInteger key) {
        SplayedEntry<E> result = this.splayToFloorEntry(key.intValue());
        return result == null ? null : result.getKey();
    }

    private SplayedEntry<E> splayToFloorEntry(int key) {
        this.root = SplayMap.splay(this.root, key);
        while (this.root != null && SplayMap.compare(this.root.getIntKey(), key) > 0) {
            SplayedEntry<E> pred = SplayMap.predecessor(this.root);
            if (pred != null) {
                this.root = SplayMap.splay(this.root, pred.key);
                continue;
            }
            return null;
        }
        return this.root;
    }

    public ImmutableSplayMapEntry<E> ceilingEntry(UnsignedInteger key) {
        return SplayMap.export(this.splayToCeilingEntry(key.intValue()));
    }

    @Override
    public UnsignedInteger ceilingKey(UnsignedInteger key) {
        SplayedEntry<E> result = this.splayToCeilingEntry(key.intValue());
        return result == null ? null : result.getKey();
    }

    private SplayedEntry<E> splayToCeilingEntry(int key) {
        this.root = SplayMap.splay(this.root, key);
        while (this.root != null && SplayMap.compare(this.root.getIntKey(), key) < 0) {
            SplayedEntry<E> succ = SplayMap.successor(this.root);
            if (succ != null) {
                this.root = SplayMap.splay(this.root, succ.key);
                continue;
            }
            return null;
        }
        return this.root;
    }

    @Override
    public NavigableMap<UnsignedInteger, E> descendingMap() {
        return this.descendingMapView != null ? this.descendingMapView : (this.descendingMapView = new DescendingSubMap<E>(this, true, 0, true, true, UnsignedInteger.MAX_VALUE.intValue(), true));
    }

    @Override
    public NavigableSet<UnsignedInteger> navigableKeySet() {
        if (this.keySet == null) {
            this.keySet = new SplayMapKeySet();
        }
        return this.keySet;
    }

    @Override
    public NavigableSet<UnsignedInteger> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<UnsignedInteger, E> subMap(UnsignedInteger fromKey, boolean fromInclusive, UnsignedInteger toKey, boolean toInclusive) {
        return new AscendingSubMap(this, false, fromKey.intValue(), fromInclusive, false, toKey.intValue(), toInclusive);
    }

    @Override
    public NavigableMap<UnsignedInteger, E> headMap(UnsignedInteger toKey, boolean inclusive) {
        return new AscendingSubMap(this, true, 0, true, false, toKey.intValue(), inclusive);
    }

    @Override
    public NavigableMap<UnsignedInteger, E> tailMap(UnsignedInteger fromKey, boolean inclusive) {
        return new AscendingSubMap(this, false, fromKey.intValue(), inclusive, true, UnsignedInteger.MAX_VALUE.intValue(), true);
    }

    @Override
    public SortedMap<UnsignedInteger, E> subMap(UnsignedInteger fromKey, UnsignedInteger toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<UnsignedInteger, E> headMap(UnsignedInteger toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public SortedMap<UnsignedInteger, E> tailMap(UnsignedInteger fromKey) {
        return this.tailMap(fromKey, true);
    }

    private SplayedEntry<E> getCeilingEntry(int key) {
        SplayedEntry<E> result = this.root;
        while (result != null) {
            int comparison = SplayMap.compare(key, result.key);
            if (comparison < 0) {
                if (result.left != null) {
                    result = result.left;
                    continue;
                }
                return result;
            }
            if (comparison > 0) {
                if (result.right != null) {
                    result = result.right;
                    continue;
                }
                SplayedEntry parent = result.parent;
                SplayedEntry<E> current = result;
                while (parent != null && current == parent.right) {
                    current = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            return result;
        }
        return null;
    }

    private SplayedEntry<E> getFloorEntry(int key) {
        SplayedEntry<E> result = this.root;
        while (result != null) {
            int comparison = SplayMap.compare(key, result.key);
            if (comparison > 0) {
                if (result.right != null) {
                    result = result.right;
                    continue;
                }
                return result;
            }
            if (comparison < 0) {
                if (result.left != null) {
                    result = result.left;
                    continue;
                }
                SplayedEntry parent = result.parent;
                SplayedEntry<E> current = result;
                while (parent != null && current == parent.left) {
                    current = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            return result;
        }
        return null;
    }

    private SplayedEntry<E> getHigherEntry(int key) {
        SplayedEntry<E> result = this.root;
        while (result != null) {
            int comparison = SplayMap.compare(key, result.key);
            if (comparison < 0) {
                if (result.left != null) {
                    result = result.left;
                    continue;
                }
                return result;
            }
            if (result.right != null) {
                result = result.right;
                continue;
            }
            SplayedEntry parent = result.parent;
            SplayedEntry<E> current = result;
            while (parent != null && current == parent.right) {
                current = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    private SplayedEntry<E> getLowerEntry(int key) {
        SplayedEntry<E> result = this.root;
        while (result != null) {
            int comparison = SplayMap.compare(key, result.key);
            if (comparison > 0) {
                if (result.right != null) {
                    result = result.right;
                    continue;
                }
                return result;
            }
            if (result.left != null) {
                result = result.left;
                continue;
            }
            SplayedEntry parent = result.parent;
            SplayedEntry<E> current = result;
            while (parent != null && current == parent.left) {
                current = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    protected static final class DescendingSubMap<V>
    extends NavigableSubMap<V> {
        private transient NavigableMap<UnsignedInteger, V> ascendingMapView;
        private transient NavigableSubMap.NavigableSubMapEntrySet navigableEntrySet;

        DescendingSubMap(SplayMap<V> m, boolean fromStart, int fromKey, boolean startInclusive, boolean toEnd, int endKey, boolean endInclusive) {
            super(m, fromStart, fromKey, startInclusive, toEnd, endKey, endInclusive);
        }

        @Override
        public Comparator<? super UnsignedInteger> comparator() {
            return REVERSE_COMPARATOR;
        }

        @Override
        public NavigableMap<UnsignedInteger, V> descendingMap() {
            return this.ascendingMapView != null ? this.ascendingMapView : (this.ascendingMapView = new AscendingSubMap(this.backingMap, this.fromStart, this.startKey, this.startInclusive, this.toEnd, this.endKey, this.endInclusive));
        }

        @Override
        public NavigableMap<UnsignedInteger, V> subMap(UnsignedInteger fromKey, boolean fromInclusive, UnsignedInteger toKey, boolean toInclusive) {
            this.checkInRange(fromKey.intValue(), fromInclusive, toKey.intValue(), toInclusive);
            return new DescendingSubMap<V>(this.backingMap, false, toKey.intValue(), toInclusive, false, fromKey.intValue(), fromInclusive);
        }

        @Override
        public NavigableMap<UnsignedInteger, V> headMap(UnsignedInteger toKey, boolean inclusive) {
            this.isInRange(toKey.intValue(), inclusive);
            return new DescendingSubMap<V>(this.backingMap, false, toKey.intValue(), inclusive, this.toEnd, this.endKey, this.endInclusive);
        }

        @Override
        public NavigableMap<UnsignedInteger, V> tailMap(UnsignedInteger fromKey, boolean inclusive) {
            this.isInRange(fromKey.intValue(), inclusive);
            return new DescendingSubMap<V>(this.backingMap, this.fromStart, this.startKey, this.startInclusive, false, fromKey.intValue(), inclusive);
        }

        @Override
        public Set<Map.Entry<UnsignedInteger, V>> entrySet() {
            return this.navigableEntrySet != null ? this.navigableEntrySet : (this.navigableEntrySet = new DescendingNavigableSubMapEntrySet());
        }

        @Override
        Iterator<UnsignedInteger> keyIterator() {
            return new NavigableSubMap.DescendingNavigableSubMapKeyIterator(this.getHighestEntry(), this.getLowestEntry());
        }

        @Override
        Iterator<UnsignedInteger> descendingKeyIterator() {
            return new NavigableSubMap.NavigableSubMapKeyIterator(this.getHighestEntry(), this.getLowestEntry());
        }

        @Override
        SplayedEntry<V> getLowestEntry() {
            return super.highestPossibleEntry();
        }

        @Override
        SplayedEntry<V> getHighestEntry() {
            return super.lowestPossibleEntry();
        }

        @Override
        SplayedEntry<V> getCeilingEntry(int key) {
            return super.entryPredecessor(key);
        }

        @Override
        SplayedEntry<V> getHigherEntry(int key) {
            return super.entryPredecessor(key);
        }

        @Override
        SplayedEntry<V> getFloorEntry(int key) {
            return super.entryOrSuccessor(key);
        }

        @Override
        SplayedEntry<V> getLowerEntry(int key) {
            return super.entryOrSuccessor(key);
        }

        @Override
        public void forEach(BiConsumer<? super UnsignedInteger, ? super V> action) {
            Objects.requireNonNull(action);
            for (Map.Entry<UnsignedInteger, V> entry : this.entrySet()) {
                V v;
                UnsignedInteger k;
                try {
                    k = entry.getKey();
                    v = entry.getValue();
                }
                catch (IllegalStateException ise) {
                    throw new ConcurrentModificationException(ise);
                }
                action.accept(k, v);
            }
        }

        private final class DescendingNavigableSubMapEntrySet
        extends NavigableSubMap.NavigableSubMapEntrySet {
            private DescendingNavigableSubMapEntrySet() {
            }

            @Override
            public Iterator<Map.Entry<UnsignedInteger, V>> iterator() {
                return new NavigableSubMap.DescendingNavigableSubMapEntryIterator(DescendingSubMap.this.highestPossibleEntry(), DescendingSubMap.this.lowestPossibleEntry());
            }
        }
    }

    protected static final class AscendingSubMap<V>
    extends NavigableSubMap<V> {
        private transient NavigableMap<UnsignedInteger, V> descendingMapView;
        private transient NavigableSubMap.NavigableSubMapEntrySet navigableEntrySet;

        AscendingSubMap(SplayMap<V> m, boolean fromStart, int fromKey, boolean startInclusive, boolean toEnd, int endKey, boolean endInclusive) {
            super(m, fromStart, fromKey, startInclusive, toEnd, endKey, endInclusive);
        }

        @Override
        public Comparator<? super UnsignedInteger> comparator() {
            return COMPARATOR;
        }

        @Override
        public NavigableMap<UnsignedInteger, V> descendingMap() {
            return this.descendingMapView != null ? this.descendingMapView : (this.descendingMapView = new DescendingSubMap(this.backingMap, this.fromStart, this.startKey, this.startInclusive, this.toEnd, this.endKey, this.endInclusive));
        }

        @Override
        public NavigableMap<UnsignedInteger, V> subMap(UnsignedInteger fromKey, boolean fromInclusive, UnsignedInteger toKey, boolean toInclusive) {
            this.checkInRange(fromKey.intValue(), fromInclusive, toKey.compareTo(0), toInclusive);
            return new AscendingSubMap<V>(this.backingMap, false, fromKey.intValue(), fromInclusive, false, toKey.intValue(), toInclusive);
        }

        @Override
        public NavigableMap<UnsignedInteger, V> headMap(UnsignedInteger toKey, boolean inclusive) {
            this.isInRange(toKey.intValue(), inclusive);
            return new AscendingSubMap<V>(this.backingMap, this.fromStart, this.startKey, this.startInclusive, false, toKey.intValue(), inclusive);
        }

        @Override
        public NavigableMap<UnsignedInteger, V> tailMap(UnsignedInteger fromKey, boolean inclusive) {
            this.isInRange(fromKey.intValue(), inclusive);
            return new AscendingSubMap<V>(this.backingMap, false, fromKey.intValue(), inclusive, this.toEnd, this.endKey, this.endInclusive);
        }

        @Override
        public Set<Map.Entry<UnsignedInteger, V>> entrySet() {
            return this.navigableEntrySet != null ? this.navigableEntrySet : (this.navigableEntrySet = new AscendingNavigableSubMapEntrySet());
        }

        @Override
        Iterator<UnsignedInteger> keyIterator() {
            return new NavigableSubMap.NavigableSubMapKeyIterator(this.getLowestEntry(), this.getHighestEntry());
        }

        @Override
        Iterator<UnsignedInteger> descendingKeyIterator() {
            return new NavigableSubMap.DescendingNavigableSubMapKeyIterator(this.getLowestEntry(), this.getHighestEntry());
        }

        @Override
        SplayedEntry<V> getLowestEntry() {
            return super.lowestPossibleEntry();
        }

        @Override
        SplayedEntry<V> getHighestEntry() {
            return super.highestPossibleEntry();
        }

        @Override
        SplayedEntry<V> getCeilingEntry(int key) {
            return super.entryOrSuccessor(key);
        }

        @Override
        SplayedEntry<V> getHigherEntry(int key) {
            return super.entrySuccessor(key);
        }

        @Override
        SplayedEntry<V> getFloorEntry(int key) {
            return super.entryOrPredecessor(key);
        }

        @Override
        SplayedEntry<V> getLowerEntry(int key) {
            return super.entryPredecessor(key);
        }

        private final class AscendingNavigableSubMapEntrySet
        extends NavigableSubMap.NavigableSubMapEntrySet {
            private AscendingNavigableSubMapEntrySet() {
            }

            @Override
            public Iterator<Map.Entry<UnsignedInteger, V>> iterator() {
                return new NavigableSubMap.NavigableSubMapEntryIterator(AscendingSubMap.this.lowestPossibleEntry(), AscendingSubMap.this.highestPossibleEntry());
            }
        }
    }

    private static abstract class NavigableSubMap<E>
    extends AbstractMap<UnsignedInteger, E>
    implements NavigableMap<UnsignedInteger, E> {
        protected final SplayMap<E> backingMap;
        final int startKey;
        final int endKey;
        final boolean fromStart;
        final boolean toEnd;
        final boolean startInclusive;
        final boolean endInclusive;
        private transient NavigableSubMapKeySet navigableSubMapKeySet;

        NavigableSubMap(SplayMap<E> map, boolean fromStart, int start, boolean startInclusive, boolean toEnd, int end, boolean endInclusive) {
            if (SplayMap.compare(start, end) > 0) {
                throw new IllegalArgumentException("The start key cannot be greater than the end key");
            }
            this.backingMap = map;
            this.fromStart = fromStart;
            this.toEnd = toEnd;
            this.startKey = fromStart ? 0 : start;
            this.endKey = toEnd ? UnsignedInteger.MAX_VALUE.intValue() : end;
            this.startInclusive = fromStart ? true : startInclusive;
            this.endInclusive = toEnd ? true : endInclusive;
        }

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.backingMap.size == 0 : this.entrySet().isEmpty();
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.backingMap.size : this.entrySet().size();
        }

        @Override
        public boolean containsKey(Object key) {
            Number numericKey = (Number)key;
            return this.containsKey(numericKey.intValue());
        }

        public boolean containsKey(int key) {
            return this.isInRange(key) && this.backingMap.containsKey(key);
        }

        @Override
        public final E put(UnsignedInteger key, E value) {
            return this.put(key.intValue(), value);
        }

        @Override
        public final E put(int key, E value) {
            if (!this.isInRange(key)) {
                throw new IllegalArgumentException("The given key is out of range for this ranged sub-map");
            }
            return this.backingMap.put(key, value);
        }

        @Override
        public final E get(Object key) {
            Number numericKey = (Number)key;
            return this.get(numericKey.intValue());
        }

        public final E get(int key) {
            return !this.isInRange(key) ? null : (E)this.backingMap.get(key);
        }

        @Override
        public final E remove(Object key) {
            Number numericKey = (Number)key;
            return this.remove(numericKey.intValue());
        }

        public final E remove(int key) {
            return !this.isInRange(key) ? null : (E)this.backingMap.remove(key);
        }

        @Override
        public final Map.Entry<UnsignedInteger, E> ceilingEntry(UnsignedInteger key) {
            return SplayMap.export(this.getCeilingEntry(key.intValue()));
        }

        @Override
        public final UnsignedInteger ceilingKey(UnsignedInteger key) {
            SplayedEntry<E> result = this.getCeilingEntry(key.intValue());
            return result == null ? null : result.getKey();
        }

        @Override
        public final Map.Entry<UnsignedInteger, E> higherEntry(UnsignedInteger key) {
            return SplayMap.export(this.getHigherEntry(key.intValue()));
        }

        @Override
        public final UnsignedInteger higherKey(UnsignedInteger key) {
            SplayedEntry<E> result = this.getHigherEntry(key.intValue());
            return result == null ? null : result.getKey();
        }

        @Override
        public final Map.Entry<UnsignedInteger, E> floorEntry(UnsignedInteger key) {
            return SplayMap.export(this.getFloorEntry(key.intValue()));
        }

        @Override
        public final UnsignedInteger floorKey(UnsignedInteger key) {
            SplayedEntry<E> result = this.getFloorEntry(key.intValue());
            return result == null ? null : result.getKey();
        }

        @Override
        public final Map.Entry<UnsignedInteger, E> lowerEntry(UnsignedInteger key) {
            return SplayMap.export(this.getLowerEntry(key.intValue()));
        }

        @Override
        public final UnsignedInteger lowerKey(UnsignedInteger key) {
            SplayedEntry<E> result = this.getLowerEntry(key.intValue());
            return result == null ? null : result.getKey();
        }

        @Override
        public final UnsignedInteger firstKey() {
            SplayedEntry<E> result = this.getLowestEntry();
            if (result != null) {
                return result.getKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public final UnsignedInteger lastKey() {
            SplayedEntry<E> result = this.getHighestEntry();
            if (result != null) {
                return result.getKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public final Map.Entry<UnsignedInteger, E> firstEntry() {
            return SplayMap.export(this.getLowestEntry());
        }

        @Override
        public final Map.Entry<UnsignedInteger, E> lastEntry() {
            return SplayMap.export(this.getHighestEntry());
        }

        @Override
        public final Map.Entry<UnsignedInteger, E> pollFirstEntry() {
            SplayedEntry<E> result = this.getLowestEntry();
            ImmutableSplayMapEntry<E> exported = SplayMap.export(result);
            if (exported != null) {
                this.backingMap.delete(result);
            }
            return exported;
        }

        @Override
        public final Map.Entry<UnsignedInteger, E> pollLastEntry() {
            SplayedEntry<E> result = this.getHighestEntry();
            ImmutableSplayMapEntry<E> exported = SplayMap.export(result);
            if (exported != null) {
                this.backingMap.delete(result);
            }
            return exported;
        }

        @Override
        public SortedMap<UnsignedInteger, E> subMap(UnsignedInteger fromKey, UnsignedInteger toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public SortedMap<UnsignedInteger, E> headMap(UnsignedInteger toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public SortedMap<UnsignedInteger, E> tailMap(UnsignedInteger fromKey) {
            return this.tailMap(fromKey, true);
        }

        @Override
        public final Set<UnsignedInteger> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<UnsignedInteger> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final NavigableSet<UnsignedInteger> navigableKeySet() {
            return this.navigableSubMapKeySet != null ? this.navigableSubMapKeySet : (this.navigableSubMapKeySet = new NavigableSubMapKeySet(this));
        }

        abstract Iterator<UnsignedInteger> keyIterator();

        abstract Iterator<UnsignedInteger> descendingKeyIterator();

        abstract SplayedEntry<E> getLowestEntry();

        abstract SplayedEntry<E> getHighestEntry();

        abstract SplayedEntry<E> getCeilingEntry(int var1);

        abstract SplayedEntry<E> getHigherEntry(int var1);

        abstract SplayedEntry<E> getFloorEntry(int var1);

        abstract SplayedEntry<E> getLowerEntry(int var1);

        protected final SplayedEntry<E> lowestPossibleEntry() {
            SplayedEntry<E> e = this.startInclusive ? this.backingMap.getCeilingEntry(this.startKey) : this.backingMap.getHigherEntry(this.startKey);
            return e == null || this.isToHigh(e.key) ? null : e;
        }

        protected final SplayedEntry<E> highestPossibleEntry() {
            SplayedEntry<E> e = this.endInclusive ? this.backingMap.getFloorEntry(this.endKey) : this.backingMap.getLowerEntry(this.endKey);
            return e == null || this.isToLow(e.key) ? null : e;
        }

        protected final SplayedEntry<E> entryOrSuccessor(int key) {
            if (this.isToLow(key)) {
                return this.lowestPossibleEntry();
            }
            SplayedEntry<E> e = this.backingMap.getCeilingEntry(key);
            return e == null || this.isToHigh(e.key) ? null : e;
        }

        protected final SplayedEntry<E> entrySuccessor(int key) {
            if (this.isToLow(key)) {
                return this.lowestPossibleEntry();
            }
            SplayedEntry<E> e = this.backingMap.getHigherEntry(key);
            return e == null || this.isToHigh(e.key) ? null : e;
        }

        protected final SplayedEntry<E> entryOrPredecessor(int key) {
            if (this.isToHigh(key)) {
                return this.highestPossibleEntry();
            }
            SplayedEntry<E> e = this.backingMap.getFloorEntry(key);
            return e == null || this.isToLow(e.key) ? null : e;
        }

        protected final SplayedEntry<E> entryPredecessor(int key) {
            if (this.isToHigh(key)) {
                return this.highestPossibleEntry();
            }
            SplayedEntry<E> e = this.backingMap.getLowerEntry(key);
            return e == null || this.isToLow(e.key) ? null : e;
        }

        protected final void checkInRange(int fromKey, boolean fromInclusive, int toKey, boolean toInclusive) {
            if (!this.isInRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("Given from key is out of range of this sub map view: " + fromKey);
            }
            if (!this.isInRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("Given to key is out of range of this sub map view: " + toKey);
            }
        }

        protected final boolean isInRange(int key) {
            return !this.isToLow(key) && !this.isToHigh(key);
        }

        final boolean isInCapturedRange(int key) {
            return SplayMap.compare(key, this.startKey) >= 0 && SplayMap.compare(this.endKey, key) >= 0;
        }

        final boolean isInRange(int key, boolean inclusive) {
            return inclusive ? this.isInRange(key) : this.isInCapturedRange(key);
        }

        protected final boolean isToLow(int key) {
            int result = SplayMap.compare(key, this.startKey);
            return result < 0 || result == 0 && !this.startInclusive;
        }

        protected final boolean isToHigh(int key) {
            int result = SplayMap.compare(key, this.endKey);
            return result > 0 || result == 0 && !this.endInclusive;
        }

        protected abstract class NavigableSubMapEntrySet
        extends AbstractSet<Map.Entry<UnsignedInteger, E>> {
            private transient int size = -1;
            private transient int sizeModCount;

            protected NavigableSubMapEntrySet() {
            }

            @Override
            public int size() {
                if (!(NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd || this.size != -1 && this.sizeModCount == NavigableSubMap.this.backingMap.modCount)) {
                    this.sizeModCount = NavigableSubMap.this.backingMap.modCount;
                    this.size = 0;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                    return this.size;
                }
                return NavigableSubMap.this.backingMap.size;
            }

            @Override
            public boolean isEmpty() {
                SplayedEntry n = NavigableSubMap.this.getLowestEntry();
                return n == null || NavigableSubMap.this.isToHigh(n.key);
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Number key = (Number)Number.class.cast(entry.getKey());
                    if (!NavigableSubMap.this.isInRange(key.intValue())) {
                        return false;
                    }
                    SplayedEntry node = NavigableSubMap.this.backingMap.findEntry(key.intValue());
                    if (node != null) {
                        return Objects.equals(node.getValue(), entry.getValue());
                    }
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Number key = (Number)Number.class.cast(entry.getKey());
                    if (!NavigableSubMap.this.isInRange(key.intValue())) {
                        return false;
                    }
                    SplayedEntry node = NavigableSubMap.this.backingMap.findEntry(key.intValue());
                    if (node != null) {
                        NavigableSubMap.this.backingMap.delete(node);
                        return Objects.equals(node.getValue(), entry.getValue());
                    }
                }
                return false;
            }
        }

        final class DescendingNavigableSubMapKeyIterator
        extends NavigableSubMapIterator<UnsignedInteger> {
            DescendingNavigableSubMapKeyIterator(SplayedEntry<E> first, SplayedEntry<E> fence) {
                super(first, fence);
            }

            @Override
            public boolean hasNext() {
                return this.hasPrevEntry();
            }

            @Override
            public UnsignedInteger next() {
                return this.previousEntry().getKey();
            }
        }

        final class NavigableSubMapKeyIterator
        extends NavigableSubMapIterator<UnsignedInteger> {
            NavigableSubMapKeyIterator(SplayedEntry<E> first, SplayedEntry<E> fence) {
                super(first, fence);
            }

            @Override
            public boolean hasNext() {
                return this.hasNextEntry();
            }

            @Override
            public UnsignedInteger next() {
                return this.nextEntry().getKey();
            }
        }

        final class DescendingNavigableSubMapEntryIterator
        extends NavigableSubMapIterator<Map.Entry<UnsignedInteger, E>> {
            DescendingNavigableSubMapEntryIterator(SplayedEntry<E> first, SplayedEntry<E> fence) {
                super(first, fence);
            }

            @Override
            public boolean hasNext() {
                return this.hasPrevEntry();
            }

            @Override
            public Map.Entry<UnsignedInteger, E> next() {
                return this.previousEntry();
            }
        }

        final class NavigableSubMapEntryIterator
        extends NavigableSubMapIterator<Map.Entry<UnsignedInteger, E>> {
            NavigableSubMapEntryIterator(SplayedEntry<E> first, SplayedEntry<E> fence) {
                super(first, fence);
            }

            @Override
            public boolean hasNext() {
                return this.hasNextEntry();
            }

            @Override
            public Map.Entry<UnsignedInteger, E> next() {
                return this.nextEntry();
            }
        }

        protected abstract class NavigableSubMapIterator<T>
        implements Iterator<T> {
            SplayedEntry<E> lastReturned;
            SplayedEntry<E> next;
            final int limitKey;
            int expectedModCount;

            NavigableSubMapIterator(SplayedEntry<E> start, SplayedEntry<E> limit) {
                this.expectedModCount = NavigableSubMap.this.backingMap.modCount;
                this.lastReturned = null;
                this.next = start;
                this.limitKey = limit != null ? limit.key : UnsignedInteger.MAX_VALUE.intValue();
            }

            @Override
            public abstract boolean hasNext();

            @Override
            public abstract T next();

            @Override
            public final void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.backingMap.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableSubMap.this.backingMap.delete(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.backingMap.modCount;
            }

            final boolean hasNextEntry() {
                return this.next != null && SplayMap.compare(this.next.key, this.limitKey) <= 0;
            }

            final SplayedEntry<E> nextEntry() {
                SplayedEntry e = this.next;
                if (e == null || SplayMap.compare(this.next.key, this.limitKey) > 0) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.backingMap.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = SplayMap.successor(e);
                this.lastReturned = e;
                return e;
            }

            final boolean hasPrevEntry() {
                return this.next != null && SplayMap.compare(this.next.key, this.limitKey) >= 0;
            }

            final SplayedEntry<E> previousEntry() {
                SplayedEntry e = this.next;
                if (e == null || SplayMap.compare(this.next.key, this.limitKey) < 0) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.backingMap.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = SplayMap.predecessor(e);
                this.lastReturned = e;
                return e;
            }
        }
    }

    protected static class NavigableSubMapKeySet
    extends AbstractSet<UnsignedInteger>
    implements NavigableSet<UnsignedInteger> {
        private final NavigableSubMap<?> backingMap;

        public NavigableSubMapKeySet(NavigableSubMap<?> backingMap) {
            this.backingMap = backingMap;
        }

        @Override
        public Iterator<UnsignedInteger> iterator() {
            return this.backingMap.keyIterator();
        }

        @Override
        public Iterator<UnsignedInteger> descendingIterator() {
            return ((NavigableSubMap)this.backingMap.descendingMap()).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.backingMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backingMap.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.backingMap.containsKey(o);
        }

        @Override
        public boolean remove(Object target) {
            int oldSize = this.backingMap.size();
            this.backingMap.remove(target);
            return oldSize != this.backingMap.size();
        }

        @Override
        public void clear() {
            this.backingMap.clear();
        }

        @Override
        public Comparator<? super UnsignedInteger> comparator() {
            return this.backingMap.comparator();
        }

        @Override
        public UnsignedInteger first() {
            return this.backingMap.firstKey();
        }

        @Override
        public UnsignedInteger last() {
            return this.backingMap.lastKey();
        }

        @Override
        public UnsignedInteger lower(UnsignedInteger key) {
            return this.backingMap.lowerKey(key);
        }

        @Override
        public UnsignedInteger floor(UnsignedInteger key) {
            return this.backingMap.floorKey(key);
        }

        @Override
        public UnsignedInteger ceiling(UnsignedInteger key) {
            return this.backingMap.ceilingKey(key);
        }

        @Override
        public UnsignedInteger higher(UnsignedInteger key) {
            return this.backingMap.higherKey(key);
        }

        @Override
        public UnsignedInteger pollFirst() {
            Map.Entry<UnsignedInteger, ?> first = this.backingMap.pollFirstEntry();
            return first == null ? null : first.getKey();
        }

        @Override
        public UnsignedInteger pollLast() {
            Map.Entry<UnsignedInteger, ?> first = this.backingMap.pollLastEntry();
            return first == null ? null : first.getKey();
        }

        @Override
        public NavigableSet<UnsignedInteger> descendingSet() {
            return this.backingMap.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableSet<UnsignedInteger> subSet(UnsignedInteger fromElement, boolean fromInclusive, UnsignedInteger toElement, boolean toInclusive) {
            return this.backingMap.subMap(fromElement, fromInclusive, toElement, toInclusive).navigableKeySet();
        }

        @Override
        public NavigableSet<UnsignedInteger> headSet(UnsignedInteger toElement, boolean inclusive) {
            return this.backingMap.headMap(toElement, inclusive).navigableKeySet();
        }

        @Override
        public NavigableSet<UnsignedInteger> tailSet(UnsignedInteger fromElement, boolean inclusive) {
            return this.backingMap.tailMap(fromElement, inclusive).navigableKeySet();
        }

        @Override
        public SortedSet<UnsignedInteger> subSet(UnsignedInteger fromElement, UnsignedInteger toElement) {
            return this.subSet(fromElement, true, toElement, true);
        }

        @Override
        public SortedSet<UnsignedInteger> headSet(UnsignedInteger toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<UnsignedInteger> tailSet(UnsignedInteger fromElement) {
            return this.tailSet(fromElement, false);
        }
    }

    private static final class UnsignedComparator
    implements Comparator<UnsignedInteger> {
        private UnsignedComparator() {
        }

        @Override
        public int compare(UnsignedInteger uint1, UnsignedInteger uint2) {
            return uint1.compareTo(uint2);
        }
    }

    public static class ImmutableSplayMapEntry<E>
    implements Map.Entry<UnsignedInteger, E> {
        private final SplayedEntry<E> entry;

        public ImmutableSplayMapEntry(SplayedEntry<E> entry) {
            this.entry = entry;
        }

        @Override
        public UnsignedInteger getKey() {
            return this.entry.getKey();
        }

        public int getPrimitiveKey() {
            return this.entry.getIntKey();
        }

        @Override
        public E getValue() {
            return this.entry.getValue();
        }

        @Override
        public E setValue(E value) {
            throw new UnsupportedOperationException();
        }
    }

    protected static final class SplayedEntry<E>
    implements Map.Entry<UnsignedInteger, E> {
        SplayedEntry<E> left;
        SplayedEntry<E> right;
        SplayedEntry<E> parent;
        int key;
        E value;
        SplayedEntry<E> linkNext;
        SplayedEntry<E> linkPrev;

        public SplayedEntry() {
            this.initialize(0, null);
        }

        public SplayedEntry<E> initialize(int key, E value) {
            this.key = key;
            this.value = value;
            this.linkNext = this;
            this.linkPrev = this;
            return this;
        }

        public int getIntKey() {
            return this.key;
        }

        @Override
        public UnsignedInteger getKey() {
            return UnsignedInteger.valueOf(this.key);
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public E setValue(E value) {
            E oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.keyEquals(e.getKey()) && this.valueEquals(e.getValue());
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return "Node:{" + this.key + "," + String.valueOf(this.value) + "}";
        }

        boolean keyEquals(Object other) {
            if (!(other instanceof Number)) {
                return false;
            }
            return this.key == ((Number)other).intValue();
        }

        boolean valueEquals(Object other) {
            return this.value != null ? this.value.equals(other) : other == null;
        }
    }

    private final class SplayMapEntrySet
    extends AbstractSet<Map.Entry<UnsignedInteger, E>> {
        private SplayMapEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<UnsignedInteger, E>> iterator() {
            return new SplayMapEntryIterator(SplayMap.firstEntry(SplayMap.this.root));
        }

        @Override
        public int size() {
            return SplayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry && SplayMap.this.root != null) {
                SplayedEntry e = SplayMap.firstEntry(SplayMap.this.root);
                while (e != null) {
                    if (e.equals(o)) {
                        return true;
                    }
                    e = SplayMap.successor(e);
                }
            }
            return false;
        }

        @Override
        public boolean remove(Object target) {
            if (!(target instanceof Map.Entry)) {
                throw new IllegalArgumentException("value provided is not an Entry type.");
            }
            SplayedEntry e = SplayMap.firstEntry(SplayMap.this.root);
            while (e != null) {
                if (e.equals(target)) {
                    SplayMap.this.delete(e);
                    return true;
                }
                e = SplayMap.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            SplayMap.this.clear();
        }
    }

    protected class SplayMapKeySet
    extends AbstractSet<UnsignedInteger>
    implements NavigableSet<UnsignedInteger> {
        protected SplayMapKeySet() {
        }

        @Override
        public Iterator<UnsignedInteger> iterator() {
            return new SplayMapKeyIterator(SplayMap.firstEntry(SplayMap.this.root));
        }

        @Override
        public int size() {
            return SplayMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return SplayMap.this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            return SplayMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object target) {
            SplayedEntry e = SplayMap.firstEntry(SplayMap.this.root);
            while (e != null) {
                if (e.keyEquals(target)) {
                    SplayMap.this.delete(e);
                    return true;
                }
                e = SplayMap.successor(e);
            }
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Objects.requireNonNull(c);
            boolean modified = false;
            SplayedEntry e = SplayMap.firstEntry(SplayMap.this.root);
            while (e != null) {
                if (c.contains(e.getKey())) {
                    e = SplayMap.successor(e);
                    continue;
                }
                SplayedEntry target = e;
                e = SplayMap.successor(e);
                SplayMap.this.delete(target);
                modified = true;
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            int i = 0;
            SplayedEntry e = SplayMap.firstEntry(SplayMap.this.root);
            while (e != null) {
                result[i] = e.getKey();
                e = SplayMap.successor(e);
                ++i;
            }
            return result;
        }

        @Override
        public void clear() {
            SplayMap.this.clear();
        }

        @Override
        public Comparator<? super UnsignedInteger> comparator() {
            return COMPARATOR;
        }

        @Override
        public UnsignedInteger first() {
            return SplayMap.this.firstKey();
        }

        @Override
        public UnsignedInteger last() {
            return SplayMap.this.lastKey();
        }

        @Override
        public UnsignedInteger lower(UnsignedInteger key) {
            return SplayMap.this.lowerKey(key);
        }

        @Override
        public UnsignedInteger floor(UnsignedInteger key) {
            return SplayMap.this.floorKey(key);
        }

        @Override
        public UnsignedInteger ceiling(UnsignedInteger key) {
            return SplayMap.this.ceilingKey(key);
        }

        @Override
        public UnsignedInteger higher(UnsignedInteger key) {
            return SplayMap.this.higherKey(key);
        }

        @Override
        public UnsignedInteger pollFirst() {
            Map.Entry first = SplayMap.this.pollFirstEntry();
            return first == null ? null : (UnsignedInteger)first.getKey();
        }

        @Override
        public UnsignedInteger pollLast() {
            Map.Entry first = SplayMap.this.pollLastEntry();
            return first == null ? null : (UnsignedInteger)first.getKey();
        }

        @Override
        public NavigableSet<UnsignedInteger> descendingSet() {
            return SplayMap.this.descendingMap().navigableKeySet();
        }

        @Override
        public Iterator<UnsignedInteger> descendingIterator() {
            return SplayMap.this.descendingMap().keySet().iterator();
        }

        @Override
        public NavigableSet<UnsignedInteger> subSet(UnsignedInteger fromElement, boolean fromInclusive, UnsignedInteger toElement, boolean toInclusive) {
            return new AscendingSubMap(SplayMap.this, false, fromElement.intValue(), fromInclusive, false, toElement.intValue(), toInclusive).navigableKeySet();
        }

        @Override
        public NavigableSet<UnsignedInteger> headSet(UnsignedInteger toElement, boolean inclusive) {
            return new AscendingSubMap(SplayMap.this, true, 0, true, false, toElement.intValue(), inclusive).navigableKeySet();
        }

        @Override
        public NavigableSet<UnsignedInteger> tailSet(UnsignedInteger fromElement, boolean inclusive) {
            return new AscendingSubMap(SplayMap.this, false, fromElement.intValue(), inclusive, true, 0, true).navigableKeySet();
        }

        @Override
        public SortedSet<UnsignedInteger> subSet(UnsignedInteger fromElement, UnsignedInteger toElement) {
            return this.subSet(fromElement, true, toElement, true);
        }

        @Override
        public SortedSet<UnsignedInteger> headSet(UnsignedInteger toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<UnsignedInteger> tailSet(UnsignedInteger fromElement) {
            return this.tailSet(fromElement, false);
        }
    }

    private final class SplayMapValues
    extends AbstractCollection<E> {
        private SplayMapValues() {
        }

        @Override
        public Iterator<E> iterator() {
            return new SplayMapValueIterator(SplayMap.firstEntry(SplayMap.this.root));
        }

        @Override
        public int size() {
            return SplayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return SplayMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object target) {
            SplayedEntry e = SplayMap.firstEntry(SplayMap.this.root);
            while (e != null) {
                if (e.valueEquals(target)) {
                    SplayMap.this.delete(e);
                    return true;
                }
                e = SplayMap.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            SplayMap.this.clear();
        }
    }

    private class SplayMapValueIterator
    extends SplayMapIterator<E> {
        public SplayMapValueIterator(SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public E next() {
            return this.nextNode().getValue();
        }
    }

    final class ReverseSplayMapKeyIterator
    extends SplayMapIterator<UnsignedInteger> {
        public ReverseSplayMapKeyIterator(SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public UnsignedInteger next() {
            return this.previousNode().getKey();
        }
    }

    private class SplayMapKeyIterator
    extends SplayMapIterator<UnsignedInteger> {
        public SplayMapKeyIterator(SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public UnsignedInteger next() {
            return this.nextNode().getKey();
        }
    }

    private class SplayMapEntryIterator
    extends SplayMapIterator<Map.Entry<UnsignedInteger, E>> {
        public SplayMapEntryIterator(SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public Map.Entry<UnsignedInteger, E> next() {
            return this.nextNode();
        }
    }

    private abstract class SplayMapIterator<T>
    implements Iterator<T> {
        protected SplayedEntry<E> nextNode;
        protected SplayedEntry<E> lastReturned;
        protected int expectedModCount;

        public SplayMapIterator(SplayedEntry<E> startAt) {
            this.nextNode = startAt;
            this.expectedModCount = SplayMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        protected SplayedEntry<E> nextNode() {
            SplayedEntry entry = this.nextNode;
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != SplayMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = SplayMap.successor(this.nextNode);
            this.lastReturned = entry;
            return this.lastReturned;
        }

        protected SplayedEntry<E> previousNode() {
            SplayedEntry entry = this.nextNode;
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != SplayMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = SplayMap.predecessor(this.nextNode);
            this.lastReturned = entry;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SplayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SplayMap.this.delete(this.lastReturned);
            this.expectedModCount = SplayMap.this.modCount;
            this.lastReturned = null;
        }
    }
}

