/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.messaging;

import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Section;

public final class Header
implements Section<Header> {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(112L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:header:list");
    public static final boolean DEFAULT_DURABILITY = false;
    public static final byte DEFAULT_PRIORITY = 4;
    public static final long DEFAULT_TIME_TO_LIVE = UnsignedInteger.MAX_VALUE.longValue();
    public static final boolean DEFAULT_FIRST_ACQUIRER = false;
    public static final long DEFAULT_DELIVERY_COUNT = 0L;
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int DURABLE = 1;
    private static final int PRIORITY = 2;
    private static final int TIME_TO_LIVE = 4;
    private static final int FIRST_ACQUIRER = 8;
    private static final int DELIVERY_COUNT = 16;
    private int modified = 0;
    private boolean durable = false;
    private byte priority = (byte)4;
    private long timeToLive = DEFAULT_TIME_TO_LIVE;
    private boolean firstAcquirer = false;
    private long deliveryCount = 0L;

    public Header() {
    }

    public Header(Header other) {
        this.durable = other.durable;
        this.priority = other.priority;
        this.timeToLive = other.timeToLive;
        this.firstAcquirer = other.firstAcquirer;
        this.deliveryCount = other.deliveryCount;
        this.modified = other.modified;
    }

    public Header copy() {
        return new Header(this);
    }

    @Override
    public Header getValue() {
        return this;
    }

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasDurable() {
        return (this.modified & 1) == 1;
    }

    public boolean hasPriority() {
        return (this.modified & 2) == 2;
    }

    public boolean hasTimeToLive() {
        return (this.modified & 4) == 4;
    }

    public boolean hasFirstAcquirer() {
        return (this.modified & 8) == 8;
    }

    public boolean hasDeliveryCount() {
        return (this.modified & 0x10) == 16;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public Header setDurable(boolean value) {
        this.modified = value ? (this.modified |= 1) : (this.modified &= 0xFFFFFFFE);
        this.durable = value;
        return this;
    }

    public Header clearDurable() {
        this.modified &= 0xFFFFFFFE;
        this.durable = false;
        return this;
    }

    public byte getPriority() {
        return this.priority;
    }

    public Header setPriority(byte value) {
        this.modified = value == 4 ? (this.modified &= 0xFFFFFFFD) : (this.modified |= 2);
        this.priority = value;
        return this;
    }

    public Header clearPriority() {
        this.modified &= 0xFFFFFFFD;
        this.priority = (byte)4;
        return this;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public Header setTimeToLive(int value) {
        return this.setTimeToLive(Integer.toUnsignedLong(value));
    }

    public Header setTimeToLive(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("TTL value given is out of range: " + value);
        }
        this.modified |= 4;
        this.timeToLive = value;
        return this;
    }

    public Header clearTimeToLive() {
        this.modified &= 0xFFFFFFFB;
        this.timeToLive = DEFAULT_TIME_TO_LIVE;
        return this;
    }

    public boolean isFirstAcquirer() {
        return this.firstAcquirer;
    }

    public Header setFirstAcquirer(boolean value) {
        this.modified = value ? (this.modified |= 8) : (this.modified &= 0xFFFFFFF7);
        this.firstAcquirer = value;
        return this;
    }

    public Header clearFirstAcquirer() {
        this.modified &= 0xFFFFFFF7;
        this.firstAcquirer = false;
        return this;
    }

    public long getDeliveryCount() {
        return this.deliveryCount;
    }

    public Header setDeliveryCount(int value) {
        return this.setDeliveryCount(Integer.toUnsignedLong(value));
    }

    public Header setDeliveryCount(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Delivery Count value given is out of range: " + value);
        }
        this.modified = value == 0L ? (this.modified &= 0xFFFFFFEF) : (this.modified |= 0x10);
        this.deliveryCount = value;
        return this;
    }

    public Header clearDeliveryCount() {
        this.modified &= 0xFFFFFFEF;
        this.deliveryCount = 0L;
        return this;
    }

    public Header reset() {
        this.modified = 0;
        this.durable = false;
        this.priority = (byte)4;
        this.timeToLive = DEFAULT_TIME_TO_LIVE;
        this.firstAcquirer = false;
        this.deliveryCount = 0L;
        return this;
    }

    public String toString() {
        return "Header{ durable=" + String.valueOf(this.hasDurable() ? Boolean.valueOf(this.durable) : "null") + ", priority=" + String.valueOf(this.hasPriority() ? Byte.valueOf(this.priority) : "null") + ", ttl=" + String.valueOf(this.hasTimeToLive() ? Long.valueOf(this.timeToLive) : "null") + ", firstAcquirer=" + String.valueOf(this.hasFirstAcquirer() ? Boolean.valueOf(this.firstAcquirer) : "null") + ", deliveryCount=" + String.valueOf(this.hasDeliveryCount() ? Long.valueOf(this.deliveryCount) : "null") + " }";
    }

    @Override
    public Section.SectionType getType() {
        return Section.SectionType.Header;
    }
}

