/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

@ThreadSafe
public abstract class ArraySapDB
implements Array {
    private final ConnectionSapDB _connection;
    private final Tracer _tracer;
    private final DataType _elementType;
    private final Object[] _elements;

    public static Object[] newArray(DataType elementType, int length) throws SQLException {
        switch (elementType) {
            case BOOLEAN: {
                return new Boolean[length];
            }
            case TINYINT: 
            case SMALLINT: {
                return new Short[length];
            }
            case INT: {
                return new Integer[length];
            }
            case BIGINT: {
                return new Long[length];
            }
            case REAL: {
                return new Float[length];
            }
            case DOUBLE: {
                return new Double[length];
            }
            case DECIMAL: 
            case FIXED8: 
            case FIXED12: 
            case FIXED16: {
                return new BigDecimal[length];
            }
            case DATE: 
            case DAYDATE: {
                return new Date[length];
            }
            case TIME: 
            case SECONDTIME: {
                return new Time[length];
            }
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                return new Timestamp[length];
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case STRING: 
            case NSTRING: 
            case VARCHAR2: 
            case ALPHANUM: {
                return new String[length];
            }
            case BINARY: 
            case VARBINARY: 
            case BSTRING: {
                return new byte[length][];
            }
        }
        throw SQLExceptionSapDB.newInstance("error.method.unsupported", "Unsupported element type: " + elementType.getDisplayName(), "Array");
    }

    public ArraySapDB(ConnectionSapDB connection, DataType elementType, Object[] elements) throws SQLException {
        this._connection = connection;
        this._tracer = connection.getTracer();
        this._elementType = elementType;
        this._elements = elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getBaseTypeName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBaseTypeName") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getBaseTypeName", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._elementType.getSQLTypeName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getBaseType() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBaseType") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getBaseType", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._elementType.getSQLType();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Object getArray() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getArray") : null;
        try {
            Object[] result;
            if (on) {
                this._tracer.printCall(this, "getArray", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = ArraySapDB.newArray(this._elementType, this._elements.length);
                this._arrayCopy(0, this._elements.length, result);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Object[] objectArray = result;
            return objectArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getArray", map);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ArraySapDB._getUnsupportedMethodException("getArray( Map )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Object getArray(long index, int count) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getArray") : null;
        try {
            Object[] result;
            if (on) {
                this._tracer.printCall(this, "getArray", index, count);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = ArraySapDB.newArray(this._elementType, count);
                this._arrayCopy((int)index - 1, count, result);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Object[] objectArray = result;
            return objectArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getArray", index, count, map);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ArraySapDB._getUnsupportedMethodException("getArray( long, int, Map )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public ResultSet getResultSet() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getResultSet") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getResultSet", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ArraySapDB._getUnsupportedMethodException("getResultSet()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getResultSet") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getResultSet", map);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ArraySapDB._getUnsupportedMethodException("getResultSet( Map )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public ResultSet getResultSet(long index, int count) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getResultSet") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getResultSet", index, count);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ArraySapDB._getUnsupportedMethodException("getResultSet( long, int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getResultSet") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getResultSet", index, count, map);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ArraySapDB._getUnsupportedMethodException("getResultSet( long, int, Map )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public void free() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("free") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "free", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    private static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "Array");
    }

    private TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this._connection, null, null, "Array", methodName);
    }

    private void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    private void _arrayCopy(int srcOff, int srcLen, Object[] dst) throws SQLException {
        switch (this._elementType) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case REAL: 
            case DOUBLE: 
            case DECIMAL: 
            case FIXED8: 
            case FIXED12: 
            case FIXED16: {
                System.arraycopy(this._elements, srcOff, dst, 0, srcLen);
                break;
            }
            case DATE: 
            case DAYDATE: {
                for (int i = 0; i < srcLen; ++i) {
                    Date date = (Date)this._elements[srcOff + i];
                    dst[i] = date != null ? new Date(date.getTime()) : null;
                }
                break;
            }
            case TIME: 
            case SECONDTIME: {
                for (int i = 0; i < srcLen; ++i) {
                    Time time = (Time)this._elements[srcOff + i];
                    dst[i] = time != null ? new Time(time.getTime()) : null;
                }
                break;
            }
            case TIMESTAMP: 
            case SECONDDATE: 
            case LONGDATE: {
                for (int i = 0; i < srcLen; ++i) {
                    Timestamp copy;
                    Timestamp timestamp = (Timestamp)this._elements[srcOff + i];
                    if (timestamp != null) {
                        copy = new Timestamp(timestamp.getTime());
                        copy.setNanos(timestamp.getNanos());
                    } else {
                        copy = null;
                    }
                    dst[i] = copy;
                }
                break;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case STRING: 
            case NSTRING: 
            case VARCHAR2: 
            case ALPHANUM: {
                System.arraycopy(this._elements, srcOff, dst, 0, srcLen);
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case BSTRING: {
                for (int i = 0; i < srcLen; ++i) {
                    byte[] bytes = (byte[])this._elements[srcOff + i];
                    dst[i] = bytes != null ? bytes.clone() : null;
                }
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.method.unsupported", "Unsupported element type: " + this._elementType.getDisplayName(), "Array");
            }
        }
    }
}

