/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

@ThreadSafe
abstract class ResultSetMetaDataSapDB
extends WrapperDummy
implements ResultSetMetaData {
    private final Tracer _tracer;
    private final ConnectionSapDB _connection;
    private final DataFormatDescription _columnInfo;

    protected ResultSetMetaDataSapDB(Tracer tracer, ConnectionSapDB connection, DataFormatDescription columnInfo) {
        this._tracer = tracer;
        this._connection = connection;
        this._columnInfo = columnInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getColumnCount() throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getColumnCount", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._columnInfo.getResultSetColumnCount();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isAutoIncrement(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isAutoIncrement", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isAutoIncrement();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isCaseSensitive(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isCaseSensitive", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isCaseSensitive();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isSearchable(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isSearchable", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isSearchable();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isCurrency(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isCurrency", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isCurrency();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int isNullable(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "isNullable", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isNullable();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isSigned(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isSigned", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isSigned();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getColumnDisplaySize(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getColumnDisplaySize", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getColumnDisplaySize();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getColumnLabel(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getColumnLabel", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getColumnLabel();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getColumnName(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getColumnName", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getColumnName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getSchemaName(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getSchemaName", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getSchemaName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getPrecision(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getPrecision", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getPrecision();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getScale(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getScale", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getScale();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getTableName(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getTableName", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getTableName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getCatalogName(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getCatalogName", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getCatalogName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getColumnType(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getColumnType", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getColumnType();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getColumnTypeName(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getColumnTypeName", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getColumnTypeName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isReadOnly(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isReadOnly", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isReadOnly();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isWritable(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isWritable", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isWritable();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isDefinitelyWritable(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isDefinitelyWritable", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).isDefinitelyWritable();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getColumnClassName(int column) throws SQLException {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getColumnClassName", column);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(column).getColumnClassName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    private AbstractConverter _getConverter(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columnInfo.getResultSetColumnCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.column.index", String.valueOf(columnIndex));
        }
        return this._columnInfo.getResultSetConverter(columnIndex);
    }

    AbstractConverter getConverter(int parameterIndex) throws SQLException {
        return this._getConverter(parameterIndex);
    }
}

