/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;

@Immutable
public final class HexUtils {
    public static final char[] HEXARRAY_LOWER = "0123456789abcdef".toCharArray();
    public static final char[] HEXARRAY_UPPER = "0123456789ABCDEF".toCharArray();

    private HexUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(HexUtils._bytesToHex(bytes, 0, bytes.length, false, false));
    }

    public static String toHexString(byte[] bytes, int off, int len) {
        if (bytes == null) {
            return null;
        }
        return new String(HexUtils._bytesToHex(bytes, off, len, false, false));
    }

    public static String toHexString(byte[] bytes, boolean upperCase) {
        if (bytes == null) {
            return null;
        }
        return new String(HexUtils._bytesToHex(bytes, 0, bytes.length, false, upperCase));
    }

    public static String toHexString(byte[] bytes, int off, int len, boolean upperCase) {
        if (bytes == null) {
            return null;
        }
        return new String(HexUtils._bytesToHex(bytes, off, len, false, upperCase));
    }

    public static String toDisplayHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return "[" + new String(HexUtils._bytesToHex(bytes, 0, bytes.length, true, false)) + "]";
    }

    public static String toDisplayHexString(byte[] bytes, int off, int len) {
        if (bytes == null) {
            return "null";
        }
        return "[" + new String(HexUtils._bytesToHex(bytes, off, len, true, false)) + "]";
    }

    public static String toDisplayHexString(byte[] bytes, int headAndTailLength) {
        if (bytes == null) {
            return "null";
        }
        int len = bytes.length;
        if (len <= headAndTailLength * 2) {
            return "[" + new String(HexUtils._bytesToHex(bytes, 0, len, true, false)) + "]";
        }
        return "[" + new String(HexUtils._bytesToHex(bytes, 0, headAndTailLength, true, false)) + " ... " + new String(HexUtils._bytesToHex(bytes, len - headAndTailLength, headAndTailLength, true, false)) + "]";
    }

    private static char[] _bytesToHex(byte[] bytes, int off, int len, boolean forDisplay, boolean upperCase) {
        if (len == 0) {
            return new char[0];
        }
        int length = forDisplay ? len * 3 - 1 : len * 2;
        char[] hexChars = new char[length];
        int j = 0;
        int n = off + len;
        for (int i = off; i < n; ++i) {
            int v = bytes[i] & 0xFF;
            if (forDisplay && j > 0) {
                hexChars[j++] = 32;
            }
            hexChars[j++] = (upperCase ? HEXARRAY_UPPER : HEXARRAY_LOWER)[v >>> 4];
            hexChars[j++] = (upperCase ? HEXARRAY_UPPER : HEXARRAY_LOWER)[v & 0xF];
        }
        return hexChars;
    }
}

