/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet.response;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.InvalidParameterException;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.PayloadTooLargeException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.LogLevel;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.UnexpectedErrorResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.AbstractResponseMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.ConstraintViolationExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.EntityAlreadyExistsExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.EntityNotFoundExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.IllegalArgumentExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.JsonSyntaxExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.NumberFormatExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.PropertyBindingExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.ResponseMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.StringParsingExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.TimeoutExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.UnsupportedOperationExceptionMapper;
import java.util.IdentityHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorResponseBuilder.class);
    public static final int MAX_STACK_TRACE_LEVEL = 20;
    protected final IdentityHashMap<Class<?>, ResponseMapper<?>> responseMappers = Maps.newIdentityHashMap();

    @Nonnull
    public static ErrorResponseBuilder newBuilder() {
        return new ErrorResponseBuilder().withMapper(new IllegalArgumentExceptionMapper()).withMapper(new JsonSyntaxExceptionMapper()).withMapper(new NumberFormatExceptionMapper()).withMapper(new PropertyBindingExceptionMapper()).withMapper(new StringParsingExceptionMapper()).withMapper(new TimeoutExceptionMapper()).withMapper(new UnsupportedOperationExceptionMapper()).withMapper(new ConstraintViolationExceptionMapper()).withMapper(new EntityAlreadyExistsExceptionMapper()).withMapper(new EntityNotFoundExceptionMapper()).logAsWarning(InvalidParameterException.class).logAsWarning(PayloadTooLargeException.class);
    }

    @Nonnull
    public ErrorResponseBuilder withMapper(@Nonnull ResponseMapper<?> responseMapper) {
        Class<?> throwableClass = responseMapper.getThrowableClass();
        this.responseMappers.put(throwableClass, responseMapper);
        if (log.isInfoEnabled()) {
            log.info("Successfully set {} for {}.", (Object)responseMapper.getClass().getName(), (Object)throwableClass.getName());
        }
        return this;
    }

    @Nonnull
    public <ThrowableT extends Throwable> ErrorResponseBuilder withMapper(@Nonnull ResponseMapper<ThrowableT> responseMapper, @Nonnull LogLevel logLevel) {
        Class<ThrowableT> throwableClass = responseMapper.getThrowableClass();
        this.responseMappers.put(throwableClass, new LogLevelDelegateMapper<ThrowableT>(responseMapper, logLevel));
        if (log.isInfoEnabled()) {
            log.info("Successfully set {} for {} with log level {}.", new Object[]{responseMapper.getClass().getName(), throwableClass.getName(), logLevel});
        }
        return this;
    }

    @Nonnull
    public <ThrowableT extends Throwable> ErrorResponseBuilder logAsLevel(final @Nonnull Class<ThrowableT> throwableClass, final @Nonnull LogLevel logLevel) {
        ResponseMapper<?> responseMapper = this.responseMappers.get(throwableClass);
        if (responseMapper != null) {
            ResponseMapper<?> mapper = responseMapper;
            return this.withMapper(mapper, logLevel);
        }
        this.responseMappers.put(throwableClass, new AbstractResponseMapper<ThrowableT>(){

            @Override
            @Nonnull
            public Class<ThrowableT> getThrowableClass() {
                return throwableClass;
            }

            @Override
            @Nonnull
            public ResponseWithErrorCode toResponse(@Nonnull Throwable throwable) {
                return ((WithErrorResponse)((Object)throwable)).getErrorResponse();
            }

            @Override
            @Nonnull
            public LogLevel getLogLevel(@Nonnull Throwable throwable) {
                return logLevel;
            }
        });
        if (log.isInfoEnabled()) {
            log.info("Using log level {} for {}.", (Object)logLevel, (Object)throwableClass.getName());
        }
        return this;
    }

    @Nonnull
    public <ThrowableT extends Throwable> ErrorResponseBuilder logAsError(@Nonnull Class<ThrowableT> throwableClass) {
        return this.logAsLevel(throwableClass, LogLevel.INFO);
    }

    @Nonnull
    public <ThrowableT extends Throwable> ErrorResponseBuilder logAsWarning(@Nonnull Class<ThrowableT> throwableClass) {
        return this.logAsLevel(throwableClass, LogLevel.WARNING);
    }

    @Nonnull
    public <ThrowableT extends Throwable> ErrorResponseBuilder logAsInfo(@Nonnull Class<ThrowableT> throwableClass) {
        return this.logAsLevel(throwableClass, LogLevel.INFO);
    }

    @Nonnull
    public <ThrowableT extends Throwable> ErrorResponseBuilder removeMapping(@Nonnull Class<ThrowableT> throwableClass) {
        ResponseMapper<?> removed = this.responseMappers.remove(throwableClass);
        if (log.isInfoEnabled()) {
            if (removed != null) {
                log.info("Successfully removed {} for {}.", (Object)removed.getClass().getName(), (Object)throwableClass.getName());
            } else {
                log.info("There was no ResponseMapper for {} that could be removed.", (Object)throwableClass.getName());
            }
        }
        return this;
    }

    @Nonnull
    public ResponseWithErrorCode build(@Nonnull Throwable throwable) {
        return this.toResponse(throwable, 0);
    }

    protected int getMaxStackTraceLevel() {
        return 20;
    }

    protected ResponseWithErrorCode toResponse(@Nonnull Throwable throwable, int stackTraceLevel) {
        if (stackTraceLevel >= this.getMaxStackTraceLevel()) {
            return this.toResponse(throwable);
        }
        if (throwable.getCause() != null && throwable != throwable.getCause()) {
            this.toResponse(throwable.getCause(), stackTraceLevel + 1);
        }
        return this.toResponse(throwable);
    }

    protected ResponseWithErrorCode toResponse(@Nonnull Throwable throwable) {
        ResponseMapper<?> responseMapper = this.responseMappers.get(throwable.getClass());
        ResponseWithErrorCode response = null;
        LogLevel logLevel = null;
        String logMessage = null;
        if (responseMapper != null) {
            response = responseMapper.toResponse(throwable);
            logLevel = responseMapper.getLogLevel(throwable);
            logMessage = responseMapper.getErrorMessage(throwable);
        }
        if (response == null) {
            response = throwable instanceof WithErrorResponse ? ((WithErrorResponse)((Object)throwable)).getErrorResponse() : new UnexpectedErrorResponse("An unexpected error occurred. For details, please refer to the application log entry with the given referenceId.");
        }
        if (logLevel == null) {
            logLevel = LogLevel.ERROR;
        }
        if (logMessage == null) {
            logMessage = throwable.getMessage();
        }
        logMessage = "Handling throwable with error response (referenceId: " + response.getReferenceId() + ")." + (logMessage == null ? "" : " Message: " + logMessage);
        if (logLevel == LogLevel.WARNING) {
            if (log.isWarnEnabled()) {
                log.warn(logMessage, throwable);
            }
        } else if (logLevel == LogLevel.INFO) {
            if (log.isInfoEnabled()) {
                log.info(logMessage, throwable);
            }
        } else {
            log.error(logMessage, throwable);
        }
        return response;
    }

    private static class LogLevelDelegateMapper<ThrowableT extends Throwable>
    extends AbstractResponseMapper<ThrowableT> {
        @Nonnull
        private final ResponseMapper<ThrowableT> delegate;
        @Nonnull
        private final LogLevel logLevel;

        @Override
        @Nonnull
        public Class<ThrowableT> getThrowableClass() {
            return this.delegate.getThrowableClass();
        }

        @Override
        @Nullable
        public ResponseWithErrorCode toResponse(@Nonnull Throwable throwable) {
            return this.delegate.toResponse(throwable);
        }

        @Override
        @Nonnull
        public LogLevel getLogLevel(@Nonnull Throwable throwable) {
            return this.logLevel;
        }

        @Override
        @Nullable
        public String getErrorMessage(@Nonnull Throwable throwable) {
            return this.delegate.getErrorMessage(throwable);
        }

        @Generated
        public LogLevelDelegateMapper(@Nonnull ResponseMapper<ThrowableT> delegate, @Nonnull LogLevel logLevel) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (logLevel == null) {
                throw new NullPointerException("logLevel is marked non-null but is null");
            }
            this.delegate = delegate;
            this.logLevel = logLevel;
        }
    }
}

