/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.soebes.maven.plugins.dmg;

/**
 * This will define the kinds of parameters which are existing in
 * doxygen configuration file.
 * 
 * @author Karl Heinz Marbaise
 *
 */
public enum DoxygenParameterType {
	/**
	 * A value as-it. 
	 */
	LITERAL,
	/**
	 * A usual string value.
	 */
	STRING,
	/**
	 * A quoted string means a string value which is quoted
	 * by using dobule quotes. 
	 */
	STRING_QUOTED,
	/**
	 * An integer values. 
	 */
	INTEGER,
	/**
	 * An boolean value which is represented by 'YES'
	 * and 'NO' in the doxygen configuration.
	 */
	BOOLEAN,
}