/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.dmg;

import com.soebes.maven.plugins.dmg.AbstractDoxygenConfigurationMojo;
import com.soebes.maven.plugins.dmg.DoxygenParameterType;
import com.soebes.maven.plugins.dmg.DoxygenParameters;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

public abstract class AbstractDoxygenMojo
extends AbstractDoxygenConfigurationMojo {
    private File outputDirectory;
    private String executable;
    private MavenSession session;
    private File basedir;
    private boolean skip;

    protected File getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.getBasedir(), this.outputDirectory.getPath());
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return this.outputDirectory.getAbsoluteFile();
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    private String getExecutablePath() {
        File execFile = new File(this.executable);
        if (execFile.exists()) {
            this.getLog().debug((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            return execFile.getAbsolutePath();
        }
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in doxygen plugin: " + tc));
            this.executable = tc.findTool(this.executable);
        }
        return this.executable;
    }

    public File buildConfigurationFile() throws MavenReportException {
        File ret = this.getConfigurationFile();
        if (ret == null) {
            ret = new File(this.getOutputDirectory(), "doxygen.config");
            this.buildConfigurationFile(ret);
        } else if (!ret.exists()) {
            this.buildConfigurationFile(ret);
        }
        return ret;
    }

    public void buildConfigurationFile(File config) throws MavenReportException {
        config.getParentFile().mkdirs();
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(config)));
            this.addConfiguration(out, DoxygenParameters.DOXYFILE_ENCODING, this.getDoxyfileEncoding());
            this.addConfiguration(out, DoxygenParameters.PROJECT_NAME, this.getProjectName());
            this.addConfiguration(out, DoxygenParameters.PROJECT_NUMBER, this.getProjectNumber());
            this.addConfiguration(out, DoxygenParameters.OUTPUT_DIRECTORY, this.getOutputDirectory().getAbsolutePath());
            this.addConfiguration(out, DoxygenParameters.CREATE_SUBDIRS, this.isCreateSubdirs());
            this.addConfiguration(out, DoxygenParameters.OUTPUT_LANGUAGE, this.getOutputLanguage());
            this.addConfiguration(out, DoxygenParameters.BRIEF_MEMBER_DESC, this.isBriefMemberDesc());
            this.addConfiguration(out, DoxygenParameters.REPEAT_BRIEF, this.isRepeatBrief());
            this.addConfiguration(out, DoxygenParameters.ABBREVIATE_BRIEF, this.getAbbreviateBrief());
            this.addConfiguration(out, DoxygenParameters.ALWAYS_DETAILED_SEC, this.isAlwaysDetailedSec());
            this.addConfiguration(out, DoxygenParameters.INLINE_INHERITED_MEMB, this.isInlineInheritedMemb());
            this.addConfiguration(out, DoxygenParameters.FULL_PATH_NAMES, this.isFullPathNames());
            this.addConfiguration(out, DoxygenParameters.STRIP_FROM_PATH, this.getStripFromPath());
            this.addConfiguration(out, DoxygenParameters.STRIP_FROM_INC_PATH, this.getStripFromIncPath());
            this.addConfiguration(out, DoxygenParameters.SHORT_NAMES, this.isShortNames());
            this.addConfiguration(out, DoxygenParameters.JAVADOC_AUTOBRIEF, this.isJavadocAutobrief());
            this.addConfiguration(out, DoxygenParameters.QT_AUTOBRIEF, this.isQtAutobrief());
            this.addConfiguration(out, DoxygenParameters.MULTILINE_CPP_IS_BRIEF, this.isMultilineCppIsBrief());
            this.addConfiguration(out, DoxygenParameters.INHERIT_DOCS, this.isInheritDocs());
            this.addConfiguration(out, DoxygenParameters.SEPARATE_MEMBER_PAGES, this.isSeparateMemberPages());
            this.addConfiguration(out, DoxygenParameters.TAB_SIZE, this.getTabSize());
            this.addConfiguration(out, DoxygenParameters.ALIASES, this.getAliases());
            this.addConfiguration(out, DoxygenParameters.OPTIMIZE_OUTPUT_FOR_C, this.isOptimizeOutputForC());
            this.addConfiguration(out, DoxygenParameters.OPTIMIZE_OUTPUT_JAVA, this.isOptimizeOutputJava());
            this.addConfiguration(out, DoxygenParameters.OPTIMIZE_FOR_FORTRAN, this.isOptimizeForFortran());
            this.addConfiguration(out, DoxygenParameters.OPTIMIZE_OUTPUT_VHDL, this.isOptimizeOutputVhdl());
            this.addConfiguration(out, DoxygenParameters.BUILTIN_STL_SUPPORT, this.isBuiltinStlSupport());
            this.addConfiguration(out, DoxygenParameters.CPP_CLI_SUPPORT, this.isCppCliSupport());
            this.addConfiguration(out, DoxygenParameters.SIP_SUPPORT, this.isSipSupport());
            this.addConfiguration(out, DoxygenParameters.IDL_PROPERTY_SUPPORT, this.isIdlPropertySupport());
            this.addConfiguration(out, DoxygenParameters.DISTRIBUTE_GROUP_DOC, this.isDistributeGroupDoc());
            this.addConfiguration(out, DoxygenParameters.SUBGROUPING, this.isSubgrouping());
            this.addConfiguration(out, DoxygenParameters.TYPEDEF_HIDES_STRUCT, this.isTypedefHidesStruct());
            this.addConfiguration(out, DoxygenParameters.SYMBOL_CACHE_SIZE, this.getSymbolCacheSize());
            this.addConfiguration(out, DoxygenParameters.EXTRACT_ALL, this.isExtractAll());
            this.addConfiguration(out, DoxygenParameters.EXTRACT_PRIVATE, this.isExtractPrivate());
            this.addConfiguration(out, DoxygenParameters.EXTRACT_STATIC, this.isExtractStatic());
            this.addConfiguration(out, DoxygenParameters.EXTRACT_LOCAL_CLASSES, this.isExtractLocalClasses());
            this.addConfiguration(out, DoxygenParameters.EXTRACT_LOCAL_METHODS, this.isExtractLocalMethods());
            this.addConfiguration(out, DoxygenParameters.EXTRACT_ANON_NSPACES, this.isExtractAnonNspaces());
            this.addConfiguration(out, DoxygenParameters.HIDE_UNDOC_MEMBERS, this.isHideUndocMembers());
            this.addConfiguration(out, DoxygenParameters.HIDE_UNDOC_CLASSES, this.isHideUndocClasses());
            this.addConfiguration(out, DoxygenParameters.HIDE_FRIEND_COMPOUNDS, this.isHideFriendCompounds());
            this.addConfiguration(out, DoxygenParameters.HIDE_IN_BODY_DOCS, this.isHideInBodyDocs());
            this.addConfiguration(out, DoxygenParameters.INTERNAL_DOCS, this.isInternalDocs());
            this.addConfiguration(out, DoxygenParameters.CASE_SENSE_NAMES, this.isCaseSenseNames());
            this.addConfiguration(out, DoxygenParameters.HIDE_SCOPE_NAMES, this.isHideScopeNames());
            this.addConfiguration(out, DoxygenParameters.SHOW_INCLUDE_FILES, this.isShowIncludeFiles());
            this.addConfiguration(out, DoxygenParameters.INLINE_INFO, this.isInlineInfo());
            this.addConfiguration(out, DoxygenParameters.SORT_MEMBER_DOCS, this.isSortMemberDocs());
            this.addConfiguration(out, DoxygenParameters.SORT_BRIEF_DOCS, this.isSortBriefDocs());
            this.addConfiguration(out, DoxygenParameters.SORT_GROUP_NAMES, this.isSortGroupNames());
            this.addConfiguration(out, DoxygenParameters.SORT_BY_SCOPE_NAME, this.isSortByScopeName());
            this.addConfiguration(out, DoxygenParameters.GENERATE_TODOLIST, this.isGenerateTodolist());
            this.addConfiguration(out, DoxygenParameters.GENERATE_TESTLIST, this.isGenerateTestlist());
            this.addConfiguration(out, DoxygenParameters.GENERATE_BUGLIST, this.isGenerateBuglist());
            this.addConfiguration(out, DoxygenParameters.GENERATE_DEPRECATEDLIST, this.isGenerateDeprecatedlist());
            this.addConfiguration(out, DoxygenParameters.ENABLED_SECTIONS, this.getEnabledSections());
            this.addConfiguration(out, DoxygenParameters.MAX_INITIALIZER_LINES, this.getMaxInitializerLines());
            this.addConfiguration(out, DoxygenParameters.SHOW_USED_FILES, this.isShowUsedFiles());
            this.addConfiguration(out, DoxygenParameters.SHOW_DIRECTORIES, this.isShowDirectories());
            this.addConfiguration(out, DoxygenParameters.SHOW_FILES, this.isShowFiles());
            this.addConfiguration(out, DoxygenParameters.SHOW_NAMESPACES, this.isShowNamespaces());
            this.addConfiguration(out, DoxygenParameters.FILE_VERSION_FILTER, this.getFileVersionFilter());
            this.addConfiguration(out, DoxygenParameters.LAYOUT_FILE, this.getLayoutFile());
            this.addConfiguration(out, DoxygenParameters.QUIET, this.isQuiet());
            this.addConfiguration(out, DoxygenParameters.WARNINGS, this.isWarnings());
            this.addConfiguration(out, DoxygenParameters.WARN_IF_UNDOCUMENTED, this.isWarnIfUndocumented());
            this.addConfiguration(out, DoxygenParameters.WARN_IF_DOC_ERROR, this.isWarnIfDocError());
            this.addConfiguration(out, DoxygenParameters.WARN_NO_PARAMDOC, this.isWarnNoParamdoc());
            this.addConfiguration(out, DoxygenParameters.WARN_FORMAT, this.getWarnFormat());
            this.addConfiguration(out, DoxygenParameters.WARN_LOGFILE, this.getWarnLogfile());
            this.addConfiguration(out, DoxygenParameters.INPUT, this.getInput());
            this.addConfiguration(out, DoxygenParameters.INPUT_ENCODING, this.getInputEncoding());
            this.addConfiguration(out, DoxygenParameters.FILE_PATTERNS, this.getFilePatterns());
            this.addConfiguration(out, DoxygenParameters.RECURSIVE, this.isRecursive());
            this.addConfiguration(out, DoxygenParameters.EXCLUDE, this.getExclude());
            this.addConfiguration(out, DoxygenParameters.EXCLUDE_SYMLINKS, this.isExcludeSymlinks());
            this.addConfiguration(out, DoxygenParameters.EXCLUDE_PATTERNS, this.getExcludePatterns());
            this.addConfiguration(out, DoxygenParameters.EXCLUDE_SYMBOLS, this.getExcludeSymbols());
            this.addConfiguration(out, DoxygenParameters.EXAMPLE_PATH, this.getExamplePath());
            this.addConfiguration(out, DoxygenParameters.EXAMPLE_PATTERNS, this.getExamplePatterns());
            this.addConfiguration(out, DoxygenParameters.EXAMPLE_RECURSIVE, this.isExampleRecursive());
            this.addConfiguration(out, DoxygenParameters.IMAGE_PATH, this.getImagePath());
            this.addConfiguration(out, DoxygenParameters.INPUT_FILTER, this.getInputFilter());
            this.addConfiguration(out, DoxygenParameters.FILTER_PATTERNS, this.getFilterPatterns());
            this.addConfiguration(out, DoxygenParameters.FILTER_SOURCE_FILES, this.isFilterSourceFiles());
            this.addConfiguration(out, DoxygenParameters.SOURCE_BROWSER, this.isSourceBrowser());
            this.addConfiguration(out, DoxygenParameters.INLINE_SOURCES, this.isInlineSources());
            this.addConfiguration(out, DoxygenParameters.STRIP_CODE_COMMENTS, this.isStripCodeComments());
            this.addConfiguration(out, DoxygenParameters.REFERENCED_BY_RELATION, this.isReferencedByRelation());
            this.addConfiguration(out, DoxygenParameters.REFERENCES_RELATION, this.isReferencesRelation());
            this.addConfiguration(out, DoxygenParameters.REFERENCES_LINK_SOURCE, this.isReferencesLinkSource());
            this.addConfiguration(out, DoxygenParameters.USE_HTAGS, this.isUseHtags());
            this.addConfiguration(out, DoxygenParameters.VERBATIM_HEADERS, this.isVerbatimHeaders());
            this.addConfiguration(out, DoxygenParameters.ALPHABETICAL_INDEX, this.isAlphabeticalIndex());
            this.addConfiguration(out, DoxygenParameters.COLS_IN_ALPHA_INDEX, this.getColsInAlphaIndex());
            this.addConfiguration(out, DoxygenParameters.IGNORE_PREFIX, this.getIgnorePrefix());
            this.addConfiguration(out, DoxygenParameters.GENERATE_HTML, this.isGenerateHtml());
            this.addConfiguration(out, DoxygenParameters.HTML_OUTPUT, this.getHtmlOutput());
            this.addConfiguration(out, DoxygenParameters.HTML_FILE_EXTENSION, this.getHtmlFileExtension());
            this.addConfiguration(out, DoxygenParameters.HTML_HEADER, this.getHtmlHeader());
            this.addConfiguration(out, DoxygenParameters.HTML_FOOTER, this.getHtmlFooter());
            this.addConfiguration(out, DoxygenParameters.HTML_STYLESHEET, this.getHtmlStylesheet());
            this.addConfiguration(out, DoxygenParameters.HTML_ALIGN_MEMBERS, this.isHtmlAlignMembers());
            this.addConfiguration(out, DoxygenParameters.HTML_DYNAMIC_SECTIONS, this.isHtmlDynamicSections());
            this.addConfiguration(out, DoxygenParameters.GENERATE_DOCSET, this.isGenerateDocset());
            this.addConfiguration(out, DoxygenParameters.DOCSET_FEEDNAME, this.getDocsetFeedname());
            this.addConfiguration(out, DoxygenParameters.DOCSET_BUNDLE_ID, this.getDocsetBundleId());
            this.addConfiguration(out, DoxygenParameters.GENERATE_HTMLHELP, this.isGenerateHtmlhelp());
            this.addConfiguration(out, DoxygenParameters.CHM_FILE, this.getChmFile());
            this.addConfiguration(out, DoxygenParameters.HHC_LOCATION, this.getHhcLocation());
            this.addConfiguration(out, DoxygenParameters.GENERATE_CHI, this.isGenerateChi());
            this.addConfiguration(out, DoxygenParameters.CHM_INDEX_ENCODING, this.getChmIndexEncoding());
            this.addConfiguration(out, DoxygenParameters.BINARY_TOC, this.isBinaryToc());
            this.addConfiguration(out, DoxygenParameters.TOC_EXPAND, this.isTocExpand());
            this.addConfiguration(out, DoxygenParameters.GENERATE_QHP, this.isGenerateQhp());
            this.addConfiguration(out, DoxygenParameters.QCH_FILE, this.getQchFile());
            this.addConfiguration(out, DoxygenParameters.QHP_NAMESPACE, this.getQhpNamespace());
            this.addConfiguration(out, DoxygenParameters.QHP_VIRTUAL_FOLDER, this.getQhpVirtualFolder());
            this.addConfiguration(out, DoxygenParameters.QHG_LOCATION, this.getQhgLocation());
            this.addConfiguration(out, DoxygenParameters.DISABLE_INDEX, this.isDisableIndex());
            this.addConfiguration(out, DoxygenParameters.ENUM_VALUES_PER_LINE, this.getEnumValuesPerLine());
            this.addConfiguration(out, DoxygenParameters.GENERATE_TREEVIEW, this.getGenerateTreeview());
            this.addConfiguration(out, DoxygenParameters.TREEVIEW_WIDTH, this.getTreeviewWidth());
            this.addConfiguration(out, DoxygenParameters.FORMULA_FONTSIZE, this.getFormulaFontsize());
            this.addConfiguration(out, DoxygenParameters.GENERATE_LATEX, this.isGenerateLatex());
            this.addConfiguration(out, DoxygenParameters.LATEX_OUTPUT, this.getLatexOutput());
            this.addConfiguration(out, DoxygenParameters.LATEX_CMD_NAME, this.getLatexCmdName());
            this.addConfiguration(out, DoxygenParameters.MAKEINDEX_CMD_NAME, this.getMakeindexCmdName());
            this.addConfiguration(out, DoxygenParameters.COMPACT_LATEX, this.isCompactLatex());
            this.addConfiguration(out, DoxygenParameters.PAPER_TYPE, this.getPaperType());
            this.addConfiguration(out, DoxygenParameters.EXTRA_PACKAGES, this.getExtraPackages());
            this.addConfiguration(out, DoxygenParameters.LATEX_HEADER, this.getLatexHeader());
            this.addConfiguration(out, DoxygenParameters.PDF_HYPERLINKS, this.isPdfHyperlinks());
            this.addConfiguration(out, DoxygenParameters.USE_PDFLATEX, this.isUsePdflatex());
            this.addConfiguration(out, DoxygenParameters.LATEX_BATCHMODE, this.isLatexBatchmode());
            this.addConfiguration(out, DoxygenParameters.LATEX_HIDE_INDICES, this.isLatexHideIndices());
            this.addConfiguration(out, DoxygenParameters.GENERATE_RTF, this.isGenerateRtf());
            this.addConfiguration(out, DoxygenParameters.RTF_OUTPUT, this.getRtfOutput());
            this.addConfiguration(out, DoxygenParameters.COMPACT_RTF, this.isCompactRtf());
            this.addConfiguration(out, DoxygenParameters.RTF_HYPERLINKS, this.isRtfHyperlinks());
            this.addConfiguration(out, DoxygenParameters.RTF_STYLESHEET_FILE, this.getRtfStylesheetFile());
            this.addConfiguration(out, DoxygenParameters.RTF_EXTENSIONS_FILE, this.getRtfExtensionsFile());
            this.addConfiguration(out, DoxygenParameters.GENERATE_MAN, this.isGenerateMan());
            this.addConfiguration(out, DoxygenParameters.MAN_OUTPUT, this.getManOutput());
            this.addConfiguration(out, DoxygenParameters.MAN_EXTENSION, this.getManExtension());
            this.addConfiguration(out, DoxygenParameters.MAN_LINKS, this.isManLinks());
            this.addConfiguration(out, DoxygenParameters.GENERATE_XML, this.isGenerateXml());
            this.addConfiguration(out, DoxygenParameters.XML_OUTPUT, this.getXmlOutput());
            this.addConfiguration(out, DoxygenParameters.XML_SCHEMA, this.getXmlSchema());
            this.addConfiguration(out, DoxygenParameters.XML_DTD, this.getXmlDtd());
            this.addConfiguration(out, DoxygenParameters.XML_PROGRAMLISTING, this.isXmlProgramlisting());
            this.addConfiguration(out, DoxygenParameters.GENERATE_AUTOGEN_DEF, this.isGenerateAutogenDef());
            this.addConfiguration(out, DoxygenParameters.GENERATE_PERLMOD, this.isGeneratePerlmod());
            this.addConfiguration(out, DoxygenParameters.PERLMOD_LATEX, this.isPerlmodLatex());
            this.addConfiguration(out, DoxygenParameters.PERLMOD_PRETTY, this.isPerlmodPretty());
            this.addConfiguration(out, DoxygenParameters.PERLMOD_MAKEVAR_PREFIX, this.getPerlmodMakevarPrefix());
            this.addConfiguration(out, DoxygenParameters.ENABLE_PREPROCESSING, this.isEnablePreprocessing());
            this.addConfiguration(out, DoxygenParameters.MACRO_EXPANSION, this.isMacroExpansion());
            this.addConfiguration(out, DoxygenParameters.EXPAND_ONLY_PREDEF, this.isExpandOnlyPredef());
            this.addConfiguration(out, DoxygenParameters.SEARCH_INCLUDES, this.isSearchIncludes());
            this.addConfiguration(out, DoxygenParameters.INCLUDE_PATH, this.getIncludePath());
            this.addConfiguration(out, DoxygenParameters.INCLUDE_FILE_PATTERNS, this.getIncludeFilePatterns());
            this.addConfiguration(out, DoxygenParameters.PREDEFINED, this.getPredefined());
            this.addConfiguration(out, DoxygenParameters.EXPAND_AS_DEFINED, this.getExpandAsDefined());
            this.addConfiguration(out, DoxygenParameters.SKIP_FUNCTION_MACROS, this.isSkipFunctionMacros());
            this.addConfiguration(out, DoxygenParameters.TAGFILES, this.getTagfiles());
            this.addConfiguration(out, DoxygenParameters.GENERATE_TAGFILE, this.getGenerateTagfile());
            this.addConfiguration(out, DoxygenParameters.ALLEXTERNALS, this.isAllexternals());
            this.addConfiguration(out, DoxygenParameters.EXTERNAL_GROUPS, this.isExternalGroups());
            this.addConfiguration(out, DoxygenParameters.PERL_PATH, this.getPerlPath());
            this.addConfiguration(out, DoxygenParameters.CLASS_DIAGRAMS, this.isClassDiagrams());
            this.addConfiguration(out, DoxygenParameters.MSCGEN_PATH, this.getMscgenPath());
            this.addConfiguration(out, DoxygenParameters.HIDE_UNDOC_RELATIONS, this.isHideUndocRelations());
            this.addConfiguration(out, DoxygenParameters.HAVE_DOT, this.isHaveDot());
            this.addConfiguration(out, DoxygenParameters.DOT_FONTNAME, this.getDotFontname());
            this.addConfiguration(out, DoxygenParameters.DOT_FONTSIZE, this.getDotFontsize());
            this.addConfiguration(out, DoxygenParameters.DOT_FONTPATH, this.getDotFontpath());
            this.addConfiguration(out, DoxygenParameters.CLASS_GRAPH, this.isClassGraph());
            this.addConfiguration(out, DoxygenParameters.COLLABORATION_GRAPH, this.isCollaborationGraph());
            this.addConfiguration(out, DoxygenParameters.GROUP_GRAPHS, this.isGroupGraphs());
            this.addConfiguration(out, DoxygenParameters.UML_LOOK, this.isUmlLook());
            this.addConfiguration(out, DoxygenParameters.TEMPLATE_RELATIONS, this.isTemplateRelations());
            this.addConfiguration(out, DoxygenParameters.INCLUDE_GRAPH, this.isIncludeGraph());
            this.addConfiguration(out, DoxygenParameters.INCLUDED_BY_GRAPH, this.isIncludedByGraph());
            this.addConfiguration(out, DoxygenParameters.CALL_GRAPH, this.isCallGraph());
            this.addConfiguration(out, DoxygenParameters.CALLER_GRAPH, this.isCallerGraph());
            this.addConfiguration(out, DoxygenParameters.GRAPHICAL_HIERARCHY, this.isGraphicalHierarchy());
            this.addConfiguration(out, DoxygenParameters.DIRECTORY_GRAPH, this.isDirectoryGraph());
            this.addConfiguration(out, DoxygenParameters.DOT_IMAGE_FORMAT, this.getDotImageFormat());
            this.addConfiguration(out, DoxygenParameters.DOT_PATH, this.getDotPath());
            this.addConfiguration(out, DoxygenParameters.DOTFILE_DIRS, this.getDotfileDirs());
            this.addConfiguration(out, DoxygenParameters.DOT_GRAPH_MAX_NODES, this.getDotGraphMaxNodes());
            this.addConfiguration(out, DoxygenParameters.MAX_DOT_GRAPH_DEPTH, this.getMaxDotGraphDepth());
            this.addConfiguration(out, DoxygenParameters.DOT_TRANSPARENT, this.isDotTransparent());
            this.addConfiguration(out, DoxygenParameters.DOT_MULTI_TARGETS, this.isDotMultiTargets());
            this.addConfiguration(out, DoxygenParameters.GENERATE_LEGEND, this.isGenerateLegend());
            this.addConfiguration(out, DoxygenParameters.DOT_CLEANUP, this.isDotCleanup());
            this.addConfiguration(out, DoxygenParameters.SEARCHENGINE, this.isSearchengine());
        }
        catch (IOException ex) {
            throw new MavenReportException("Error creating Doxygen configuration file '" + config.getAbsolutePath() + "'.", (Exception)ex);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void addConfiguration(PrintWriter config, DoxygenParameters key, boolean value) {
        if (value) {
            this.addConfiguration(config, key, "YES");
        } else {
            this.addConfiguration(config, key, "NO");
        }
    }

    private void addConfiguration(PrintWriter config, DoxygenParameters key, Integer value) {
        if (value == null) {
            value = Integer.parseInt(key.getDefaultValue());
        }
        this.addConfiguration(config, key, value.toString());
    }

    private void addConfiguration(PrintWriter config, DoxygenParameters key, String value) {
        if (value == null) {
            value = key.getDefaultValue();
        } else if (value.length() == 0 || value.trim().length() == 0) {
            value = key.getDefaultValue();
        }
        if (key.getType().equals((Object)DoxygenParameterType.STRING_QUOTED)) {
            value = '\"' + value + '\"';
        }
        this.addConfiguration(config, key.getDescription(), key.name(), value);
    }

    private void addConfiguration(PrintWriter config, String desc, String key, String value) {
        config.print(desc);
        config.println();
        config.printf("%-22s", key);
        config.print(" = ");
        if (value != null) {
            config.println(value);
        } else {
            config.println();
        }
        config.println();
    }

    protected void executeReport(Locale unusedLocale) throws MavenReportException {
        File config = this.buildConfigurationFile();
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.getBasedir().getAbsolutePath());
        cli.setExecutable(this.getExecutablePath());
        cli.createArgument().setValue(config.getAbsolutePath());
        StringWriter stringWriter = new StringWriter();
        WriterStreamConsumer out = new WriterStreamConsumer((Writer)stringWriter);
        WriterStreamConsumer err = new WriterStreamConsumer((Writer)stringWriter);
        try {
            int returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            if (!this.isQuiet()) {
                String[] lines = ((Object)stringWriter).toString().split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    lines[i] = lines[i].replaceAll("\n|\r", "");
                    this.getLog().info((CharSequence)("doxygen: " + lines[i]));
                }
            }
            if (returnCode != 0) {
                throw new MavenReportException("Failed to generate Doxygen documentation.");
            }
        }
        catch (CommandLineException ex) {
            throw new MavenReportException("Error while executing Doxygen.", (Exception)((Object)ex));
        }
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

