/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.services.core.model.SolaceServiceCredentials;
import com.solace.spring.boot.autoconfigure.CloudCondition;
import com.solace.spring.boot.autoconfigure.SolaceJmsAutoConfigurationBase;
import com.solace.spring.boot.autoconfigure.SolaceJmsProperties;
import com.solace.spring.cloud.core.SolaceServiceCredentialsFactory;
import com.solacesystems.jms.SolConnectionFactory;
import java.util.List;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiTemplate;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, SolConnectionFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class, JndiTemplate.class})
@Conditional(value={CloudCondition.class})
@EnableConfigurationProperties(value={SolaceJmsProperties.class})
public class SolaceJmsAutoCloudConfiguration
extends SolaceJmsAutoConfigurationBase {
    private static final Logger logger = LoggerFactory.getLogger(SolaceJmsAutoCloudConfiguration.class);

    @Autowired
    public SolaceJmsAutoCloudConfiguration(SolaceJmsProperties properties) {
        super(properties);
    }

    @Override
    SolaceServiceCredentials findFirstSolaceServiceCredentialsImpl() {
        List credentials = SolaceServiceCredentialsFactory.getAllFromCloudFoundry();
        return credentials.size() == 0 ? null : (SolaceServiceCredentials)credentials.get(0);
    }

    @Override
    public List<SolaceServiceCredentials> getSolaceServiceCredentials() {
        return SolaceServiceCredentialsFactory.getAllFromCloudFoundry();
    }
}

