/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.services.core.loader.SolaceCredentialsLoader;
import com.solace.services.core.model.SolaceServiceCredentials;
import com.solace.spring.boot.autoconfigure.SolaceJmsAutoConfigurationBase;
import com.solace.spring.boot.autoconfigure.SolaceJmsProperties;
import com.solacesystems.jms.SolConnectionFactory;
import java.util.ArrayList;
import java.util.List;
import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiTemplate;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, SolConnectionFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class, JndiTemplate.class})
@EnableConfigurationProperties(value={SolaceJmsProperties.class})
public class SolaceJmsAutoConfiguration
extends SolaceJmsAutoConfigurationBase {
    private SolaceCredentialsLoader solaceServicesInfoLoader = new SolaceCredentialsLoader();

    @Autowired
    public SolaceJmsAutoConfiguration(SolaceJmsProperties properties) {
        super(properties);
    }

    @Override
    SolaceServiceCredentials findFirstSolaceServiceCredentialsImpl() {
        return this.solaceServicesInfoLoader.getSolaceServiceInfo();
    }

    @Override
    public List<SolaceServiceCredentials> getSolaceServiceCredentials() {
        return new ArrayList<SolaceServiceCredentials>(this.solaceServicesInfoLoader.getAllSolaceServiceInfo().values());
    }
}

