/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.services.core.model.SolaceServiceCredentials;
import com.solace.services.core.model.SolaceServiceCredentialsImpl;
import com.solace.spring.boot.autoconfigure.SolaceJmsProperties;
import com.solace.spring.cloud.core.SolaceServiceCredentialsFactory;
import com.solacesystems.jms.SolConnectionFactory;
import com.solacesystems.jms.SolConnectionFactoryImpl;
import com.solacesystems.jms.SpringSolJmsConnectionFactoryCloudFactory;
import com.solacesystems.jms.SpringSolJmsJndiTemplateCloudFactory;
import com.solacesystems.jms.property.JMSProperties;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.jndi.JndiTemplate;

abstract class SolaceJmsAutoConfigurationBase
implements SpringSolJmsConnectionFactoryCloudFactory,
SpringSolJmsJndiTemplateCloudFactory {
    private static final Logger logger = LoggerFactory.getLogger(SolaceJmsAutoConfigurationBase.class);
    private SolaceJmsProperties properties;

    SolaceJmsAutoConfigurationBase(SolaceJmsProperties properties) {
        this.properties = properties;
    }

    abstract SolaceServiceCredentials findFirstSolaceServiceCredentialsImpl();

    @Override
    public abstract List<SolaceServiceCredentials> getSolaceServiceCredentials();

    @Override
    @Bean
    @ConditionalOnMissingBean
    public SolaceServiceCredentials findFirstSolaceServiceCredentials() {
        return this.findFirstSolaceServiceCredentialsImpl();
    }

    @Override
    @Bean
    public SolConnectionFactory getSolConnectionFactory() {
        return this.getSolConnectionFactory(this.findFirstSolaceServiceCredentialsImpl());
    }

    @Override
    public SolConnectionFactory getSolConnectionFactory(String id) {
        SolaceServiceCredentials solaceServiceCredentials = this.findSolaceServiceCredentialsById(id);
        return solaceServiceCredentials == null ? null : this.getSolConnectionFactory(solaceServiceCredentials);
    }

    @Override
    public SolConnectionFactory getSolConnectionFactory(SolaceServiceCredentials solaceServiceCredentials) {
        try {
            Hashtable<String, String> ht = new Hashtable<String, String>(this.properties.getApiProperties());
            JMSProperties props = new JMSProperties(ht);
            props.initialize();
            SolConnectionFactoryImpl cf = new SolConnectionFactoryImpl(props);
            SolaceServiceCredentials credentials = solaceServiceCredentials != null ? solaceServiceCredentials : new SolaceServiceCredentialsImpl();
            cf.setHost(credentials.getSmfHost() != null ? credentials.getSmfHost() : this.properties.getHost());
            cf.setVPN(credentials.getMsgVpnName() != null ? credentials.getMsgVpnName() : this.properties.getMsgVpn());
            cf.setUsername(credentials.getClientUsername() != null ? credentials.getClientUsername() : this.properties.getClientUsername());
            cf.setPassword(credentials.getClientPassword() != null ? credentials.getClientPassword() : this.properties.getClientPassword());
            cf.setDirectTransport(Boolean.valueOf(this.properties.isDirectTransport()));
            return cf;
        }
        catch (Exception ex) {
            logger.error("Exception found during Solace Connection Factory creation.", (Throwable)ex);
            throw new IllegalStateException("Unable to create Solace connection factory, ensure that the sol-jms-<version>.jar is the classpath", ex);
        }
    }

    private SolaceServiceCredentials findSolaceServiceCredentialsById(String id) {
        for (SolaceServiceCredentials credentials : this.getSolaceServiceCredentials()) {
            if (!credentials.getId().equals(id)) continue;
            return credentials;
        }
        return null;
    }

    void setProperties(SolaceJmsProperties properties) {
        this.properties = properties;
    }

    @Override
    @Bean
    public JndiTemplate getJndiTemplate() {
        return this.getJndiTemplate(this.findFirstSolaceServiceCredentialsImpl());
    }

    @Override
    public JndiTemplate getJndiTemplate(SolaceServiceCredentials solaceServiceCredentials) {
        try {
            SolaceServiceCredentials credentials = solaceServiceCredentials != null ? solaceServiceCredentials : new SolaceServiceCredentialsImpl();
            Properties env = new Properties();
            env.putAll(this.properties.getApiProperties());
            env.put("java.naming.factory.initial", "com.solacesystems.jndi.SolJNDIInitialContextFactory");
            env.put("java.naming.provider.url", credentials.getJmsJndiUri() != null ? credentials.getJmsJndiUri() : this.properties.getHost());
            env.put("java.naming.security.principal", credentials.getClientUsername() != null && credentials.getMsgVpnName() != null ? credentials.getClientUsername() + '@' + credentials.getMsgVpnName() : this.properties.getClientUsername() + '@' + this.properties.getMsgVpn());
            env.put("java.naming.security.credentials", credentials.getClientPassword() != null ? credentials.getClientPassword() : this.properties.getClientPassword());
            JndiTemplate jndiTemplate = new JndiTemplate();
            jndiTemplate.setEnvironment(env);
            return jndiTemplate;
        }
        catch (Exception ex) {
            logger.error("Exception found during Solace JNDI Initial Context creation.", (Throwable)ex);
            throw new IllegalStateException("Unable to create Solace JNDI Initial Context, ensure that the sol-jms-<version>.jar is the classpath", ex);
        }
    }

    @Override
    public JndiTemplate getJndiTemplate(String id) {
        List credentials = SolaceServiceCredentialsFactory.getAllFromCloudFoundry();
        return credentials.size() == 0 ? null : this.getJndiTemplate((SolaceServiceCredentials)credentials.get(0));
    }
}

