/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.jndi;

import com.solacesystems.common.jndi.JNDIException;
import com.solacesystems.common.jndi.JNDINoSuchObjectException;
import com.solacesystems.common.jndi.JNDIObject;
import com.solacesystems.common.jndi.JNDIObjectList;
import com.solacesystems.common.jndi.JNDIObjectType;
import com.solacesystems.common.jndi.JNDIUtil;
import com.solacesystems.common.jndi.PropertyList;
import com.solacesystems.common.semp.SEMPNoSuchObjectException;
import com.solacesystems.common.semp.SEMPSAXParser;
import com.solacesystems.common.xml.XMLUtils;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JNDISAXParser
extends SEMPSAXParser {
    private static final String ObjectKeyword = "object";
    private static final String ConnectionFactoriesKeyword = "connection-factories";
    private static final String ConnectionFactoryKeyword = "connection-factory";
    private static final String TopicsKeyword = "topics";
    private static final String TopicKeyword = "topic";
    private static final String QueuesKeyword = "queues";
    private static final String QueueKeyword = "queue";
    private static final String PropertyListKeyword = "property-list";
    private static final String PropertyKeyword = "property";
    private static final String NameKeyword = "name";
    private static final String ValueKeyword = "value";
    private static final String VersionKeyword = "schema-version";
    private static final String PrimaryPropertyKeyword = "primary-property";
    private static final String MessageVpnKeyword = "message-vpn";
    private static final String RequestPreamble = "<rpc><show><jndi>";
    private static final String LookupRequestPreamble = "<rpc><show><jndi><object><name>";
    private static final String RequestPostamble = "</jndi></show></rpc>";
    private static final String LookupRequestPostamble = "</name></object></jndi></show></rpc>";
    private JNDIObjectList mObjects = null;
    private JNDIObject mCurrentObject = null;
    private PropertyList mCurrentPropertyList = null;
    private String mCurrentName = null;
    private String mCurrentValue = null;
    private boolean mInProperty = false;
    private boolean mInResult = false;

    public JNDIObjectList parse(String str) throws JNDIException {
        this.mObjects = new JNDIObjectList();
        super.initializeParser(str);
        StringReader strreader = new StringReader(str);
        try {
            this.mSAXParser.parse(new InputSource(strreader), (DefaultHandler)this);
            this.processResponse();
        }
        catch (SEMPNoSuchObjectException e) {
            throw new JNDINoSuchObjectException(e.getMessage());
        }
        catch (Exception e) {
            throw new JNDIException(e.getMessage());
        }
        return this.mObjects;
    }

    public void startElement(String s, String s1, String s2, Attributes attributes1) throws SAXException {
        super.startElement(s, s1, s2, attributes1);
        if (s2.equalsIgnoreCase(ConnectionFactoriesKeyword) || s2.equalsIgnoreCase(TopicsKeyword) || s2.equalsIgnoreCase(QueuesKeyword) || s2.equalsIgnoreCase(ObjectKeyword)) {
            this.mInResult = true;
        }
        if (this.mInResult && s2.equalsIgnoreCase(ConnectionFactoryKeyword)) {
            this.mCurrentObject = new JNDIObject(JNDIObjectType.ConnectionFactory);
            this.mCurrentPropertyList = this.mCurrentObject.getPropertyList("___DEFAULT___");
        } else if (this.mInResult && s2.equalsIgnoreCase(TopicKeyword)) {
            this.mCurrentObject = new JNDIObject(JNDIObjectType.Topic);
            this.mCurrentPropertyList = this.mCurrentObject.getPropertyList("___DEFAULT___");
        } else if (this.mInResult && s2.equalsIgnoreCase(QueueKeyword)) {
            this.mCurrentObject = new JNDIObject(JNDIObjectType.Queue);
            this.mCurrentPropertyList = this.mCurrentObject.getPropertyList("___DEFAULT___");
        } else if (s2.equalsIgnoreCase(PropertyListKeyword)) {
            this.mCurrentPropertyList = new PropertyList();
        } else if (s2.equalsIgnoreCase(PropertyKeyword) || s2.equalsIgnoreCase(PrimaryPropertyKeyword)) {
            this.mInProperty = true;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (qName.equalsIgnoreCase(ConnectionFactoriesKeyword) || qName.equalsIgnoreCase(TopicsKeyword) || qName.equalsIgnoreCase(QueuesKeyword) || qName.equalsIgnoreCase(ObjectKeyword)) {
            this.mInResult = false;
            this.mCurrentObject = null;
            this.mCurrentPropertyList = null;
        } else if (this.mInResult && (qName.equalsIgnoreCase(ConnectionFactoryKeyword) || qName.equalsIgnoreCase(TopicKeyword) || qName.equalsIgnoreCase(QueueKeyword))) {
            this.mObjects.addJNDIObject(this.mCurrentObject);
            this.mCurrentObject = null;
            this.mCurrentPropertyList = null;
        } else if (qName.equalsIgnoreCase(PropertyListKeyword)) {
            this.mCurrentPropertyList = null;
        } else if (qName.equalsIgnoreCase(PropertyKeyword) || qName.equalsIgnoreCase(PrimaryPropertyKeyword)) {
            this.mInProperty = false;
            if (this.mCurrentName != null && this.mCurrentName.length() > 0 && this.mCurrentValue != null && this.mCurrentPropertyList != null) {
                this.mCurrentPropertyList.addProperty(this.mCurrentName, this.mCurrentValue);
            }
            this.mCurrentName = null;
            this.mCurrentValue = null;
        } else if (qName.equalsIgnoreCase(NameKeyword)) {
            this.mCurrentName = this.mCurrentElementText.toString();
            if (this.mCurrentObject != null && !this.mInProperty && this.mCurrentPropertyList != null) {
                if (this.mCurrentPropertyList.getName() != null && this.mCurrentPropertyList.getName().equals("___DEFAULT___")) {
                    this.mCurrentObject.setJNDIName(this.mCurrentName);
                } else {
                    this.mCurrentPropertyList.setName(this.mCurrentName);
                    this.mCurrentObject.addPropertyList(this.mCurrentPropertyList);
                }
            }
        } else if (qName.equalsIgnoreCase(MessageVpnKeyword)) {
            if (this.mCurrentObject != null && !this.mInProperty) {
                this.mCurrentObject.setVpnName(this.mCurrentElementText.toString());
            }
        } else if (qName.equalsIgnoreCase(ValueKeyword)) {
            this.mCurrentValue = this.mCurrentElementText.toString();
        } else if (qName.equalsIgnoreCase(VersionKeyword)) {
            this.mObjects.setVersion(this.mCurrentElementText.toString());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.mCurrentElementText.append(ch, start, length);
    }

    public static String createLookupRequest(String name) {
        String escapedName = XMLUtils.escape(name);
        JNDIUtil.isValidJNDIName(escapedName);
        StringBuilder bldr = new StringBuilder(LookupRequestPreamble);
        bldr.append(escapedName);
        bldr.append(LookupRequestPostamble);
        return bldr.toString();
    }
}

