/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.property.impl;

import com.solacesystems.common.property.PropertySourceChangeEvent;
import com.solacesystems.common.property.PropertyVetoException;
import com.solacesystems.common.property.VetoablePropertySourceChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeConstraint<T>
implements VetoablePropertySourceChangeListener<T> {
    protected Comparable<T> mMin;
    protected Comparable<T> mMax;

    public RangeConstraint(Comparable<T> min, Comparable<T> max) {
        this.mMin = min;
        this.mMax = max;
    }

    @Override
    public void vetoablePropertySourceChanged(PropertySourceChangeEvent<T> event) throws PropertyVetoException {
        if (event.isSet() && event.getNewValue() != null) {
            if (this.mMin != null && this.mMin.compareTo(event.getNewValue()) > 0) {
                throw new PropertyVetoException(event, "new value is below minimum value allowed");
            }
            if (this.mMax != null && this.mMax.compareTo(event.getNewValue()) < 0) {
                throw new PropertyVetoException(event, "new value is above maximum value allowed");
            }
        }
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("min=");
        bldr.append(this.mMin);
        bldr.append(", max=");
        bldr.append(this.mMax);
        return bldr.toString();
    }
}

