/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolReserved;

public class ProducerFlowProperties {
    protected int windowSize = 255;
    private boolean isRtrWindowedAck = true;
    private String ackEventMode = "SUPPORTED_ACK_EVENT_MODE_PER_MSG";

    public ProducerFlowProperties() {
    }

    public ProducerFlowProperties(ProducerFlowProperties tocopy) {
        this();
        if (tocopy != null) {
            this.windowSize = tocopy.windowSize;
            this.isRtrWindowedAck = tocopy.isRtrWindowedAck;
            this.ackEventMode = tocopy.ackEventMode;
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public ProducerFlowProperties setWindowSize(int windowSize) {
        if (windowSize < 1 || windowSize > 255) {
            throw new IllegalArgumentException(String.format("Illegal window size %d, must be in the range [1,255]", windowSize));
        }
        this.windowSize = windowSize;
        return this;
    }

    @SolReserved
    public boolean isRtrWindowedAck() {
        return this.isRtrWindowedAck;
    }

    @SolReserved
    public ProducerFlowProperties setRtrWindowedAck(boolean isRtrWindowedAck) {
        this.isRtrWindowedAck = isRtrWindowedAck;
        return this;
    }

    public String getAckEventMode() {
        return this.ackEventMode;
    }

    public ProducerFlowProperties setAckEventMode(String ackEventMode) {
        this.ackEventMode = ackEventMode;
        return this;
    }
}

