/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.BufferCloningPool;
import com.solacesystems.jcsmp.impl.ContentBuffer;
import com.solacesystems.jcsmp.impl.JCSMPBytesXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPStreamXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPTextXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.MessageDumpStandardProvider;
import com.solacesystems.jcsmp.impl.MessageDumpUtil;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class JCSMPGenericXMLMessage
extends JCSMPXMLMessage
implements JCSMPBytesXMLMessage,
JCSMPStreamXMLMessage,
JCSMPTextXMLMessage {
    private int readMark;
    private InputStream in;
    private String charset;
    private TLVBuffer tlvBuffer;

    protected JCSMPGenericXMLMessage(int maxContentLength) {
        this(maxContentLength, false, true);
    }

    protected JCSMPGenericXMLMessage(int maxContentLength, boolean useDirect, boolean isPub) {
        super(useDirect, isPub);
        this.contentCB = new ContentBuffer(maxContentLength, useDirect);
    }

    protected JCSMPGenericXMLMessage(JCSMPGenericXMLMessage toclone, BufferCloningPool contentBufPool) {
        super(toclone, contentBufPool);
        this.readMark = toclone.readMark;
        this.in = toclone.in;
        this.charset = toclone.charset;
        this.tlvBuffer = toclone.tlvBuffer == null ? null : new TLVBuffer(toclone.tlvBuffer);
    }

    protected TLVBuffer getTLVBuffer() {
        if (this.tlvBuffer == null) {
            this.tlvBuffer = new TLVBuffer(1024);
        }
        return this.tlvBuffer;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean resetMsgType) {
        super.reset(resetMsgType);
        this.readMark = 0;
        this.in = null;
        this.charset = null;
    }

    public void setMessageIdForResend(String messageId) {
        this.setMessageIdLong(Long.parseLong(messageId));
        this.newMsgIdRequired = false;
    }

    public int readContentBytes(int srcPos, byte[] destination, int destPos, int length) {
        if (this.getContentLength() == 0) {
            return -1;
        }
        int lenToRead = length;
        lenToRead = Math.min(lenToRead, this.getContentLength() - srcPos);
        if ((lenToRead = Math.min(lenToRead, destination.length - destPos)) <= 0) {
            return -1;
        }
        if (this.contentCB == null) {
            return -1;
        }
        this.contentCB.read(srcPos, destination, destPos, length);
        return lenToRead;
    }

    public int readContentBytes(byte[] byteOutputBuffer, int length) {
        return this.readContentBytes(0, byteOutputBuffer, 0, length);
    }

    public int readContentBytes(byte[] byteOutputBuffer) {
        return this.readContentBytes(0, byteOutputBuffer, 0, byteOutputBuffer.length);
    }

    public int readBytes(byte[] value) {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) {
        if (this.getContentLength() - this.readMark < length) {
            length = this.getContentLength() - this.readMark;
        }
        if (length <= 0) {
            return -1;
        }
        this.contentCB.read(this.readMark, value, 0, length);
        this.readMark += length;
        return length;
    }

    public void rewindContent() {
        this.readMark = 0;
    }

    public void writeBytes(byte[] value) {
        if (this.readOnly) {
            throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPBytesXMLMessage.mayNotWriteToReadOnly"));
        }
        this.newMsgIdRequired = true;
        if (value != null) {
            this.writeBytes(value, 0, value.length);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) {
        if (this.readOnly) {
            throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPBytesXMLMessage.mayNotWriteToReadOnly"));
        }
        this.newMsgIdRequired = true;
        this.contentCB.appendFromBytes(value, offset, length);
    }

    public byte[] getBytes() {
        if (this.readOnly && this.getContentLength() > 0) {
            return this.contentCB.getBufferRefInternal();
        }
        return new byte[0];
    }

    public InputStream getStream() {
        return this.in;
    }

    public void setStream(InputStream stream) throws IOException {
        if (this.readOnly) {
            throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPStreamXMLMessage.mayNotSetIStreamToReadOnlyMsg"));
        }
        this.newMsgIdRequired = true;
        this.in = stream;
        int len = 0;
        this.contentCB.reset();
        if (this.readBuffer == null) {
            this.readBuffer = new byte[8192];
        }
        while ((len = this.in.read(this.readBuffer)) != -1) {
            this.contentCB.appendFromBytes(this.readBuffer, 0, len);
        }
    }

    public String getText() {
        if (this.getContentLength() == 0) {
            return "";
        }
        byte[] byteData = new byte[this.getContentLength()];
        this.contentCB.read(0, byteData, 0, this.getContentLength());
        if (this.charset == null) {
            return new String(byteData, 0, this.getContentLength());
        }
        try {
            return new String(byteData, 0, this.getContentLength(), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPTextXMLMessage.notSupportedEncoding", new Object[]{this.charset}));
        }
    }

    public void setText(String text) {
        if (this.readOnly) {
            throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPTextXMLMessage.mayNotSetTextToReadOnlyMsg"));
        }
        this.newMsgIdRequired = true;
        byte[] bytes = text.getBytes();
        this.contentCB.writeFromBytes(bytes, 0, bytes.length);
    }

    public void setText(String text, String charsetName) throws UnsupportedEncodingException {
        if (this.readOnly) {
            throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPTextXMLMessage.mayNotSetTextToReadOnlyMsg"));
        }
        this.newMsgIdRequired = true;
        byte[] bytes = text.getBytes(charsetName);
        this.charset = charsetName;
        this.contentCB.writeFromBytes(bytes, 0, bytes.length);
    }

    public String dump() {
        return this.dump(1);
    }

    public String dump(int flags) {
        return MessageDumpUtil.dump(MessageDumpStandardProvider.getStandardFieldProviders(), this, flags);
    }
}

