/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;

public class ClientMessageFactory {
    private JCSMPBasicSession _session;

    public ClientMessageFactory(JCSMPBasicSession session) {
        this._session = session;
    }

    public WireMessage getAdCtrlBind(Endpoint bindTo, Topic newTopic, int winSz, int corrTag, String flowName, AssuredCtrlEnums.FlowType flowType, long lastMsgAcked, long lastMsgIdRecved, String sqlSelector, EndpointProperties tmpEndpointProperties, Long transactedSessionId, boolean noLocal, boolean activeFlowIndication) throws JCSMPException {
        TlvParameterFactorySmf pfac = TlvParameterFactorySmf.instance();
        WireMessage msgReq = new WireMessage();
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(9).setTtl(1);
        AssuredCtrlHeaderBean assBean = this._session.getAssuredCtrlFactory().createBindRequest(this._session, bindTo, newTopic, winSz, corrTag, flowName, flowType, lastMsgAcked, lastMsgIdRecved, sqlSelector, tmpEndpointProperties, transactedSessionId, noLocal, activeFlowIndication);
        smfHeader.addParam(pfac.getCorrelationId(corrTag));
        msgReq.setSmfHeader(smfHeader);
        msgReq.addHeaderBean(assBean);
        return msgReq;
    }

    public WireMessage getUnbindRequest(long flowId, int corrTag, boolean linger, Long lastMsgIdAcked) throws JCSMPException {
        TlvParameterFactorySmf pfac = TlvParameterFactorySmf.instance();
        WireMessage msgReq = new WireMessage();
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(9).setTtl(1);
        smfHeader.addParam(pfac.getCorrelationId(corrTag));
        AssuredCtrlHeaderBean assBean = this._session.getAssuredCtrlFactory().createUnbindRequest(flowId, linger, lastMsgIdAcked);
        msgReq.setSmfHeader(smfHeader);
        msgReq.addHeaderBean(assBean);
        return msgReq;
    }

    public WireMessage getUnsubscribeRequest(String endpointName, int corrTag) throws JCSMPException {
        TlvParameterFactorySmf pfac = TlvParameterFactorySmf.instance();
        WireMessage msgReq = new WireMessage();
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(9).setTtl(1);
        smfHeader.addParam(pfac.getCorrelationId(corrTag));
        AssuredCtrlHeaderBean assBean = this._session.getAssuredCtrlFactory().createUnsubscribeRequest(endpointName);
        msgReq.setSmfHeader(smfHeader);
        msgReq.addHeaderBean(assBean);
        return msgReq;
    }

    public WireMessage getFlowChangeUpdateResponse(long flowId, boolean activeFlowIndication, long respCode, String respString) throws JCSMPException {
        TlvParameterFactorySmf pfac = TlvParameterFactorySmf.instance();
        WireMessage msgReq = new WireMessage();
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(9).setTtl(1);
        smfHeader.addParam(pfac.getResponse(respCode, respString));
        AssuredCtrlHeaderBean assBean = this._session.getAssuredCtrlFactory().createFlowChangeUpdateResponse(flowId, activeFlowIndication);
        msgReq.setSmfHeader(smfHeader);
        msgReq.addHeaderBean(assBean);
        return msgReq;
    }
}

