/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPStreamingPublishCorrelatingEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.MsgIdInfo;
import com.solacesystems.jcsmp.protocol.nio.Notification;
import com.solacesystems.jcsmp.protocol.nio.impl.AbstractNotification;
import com.solacesystems.jcsmp.statistics.StatType;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProducerResponseNotification
extends AbstractNotification
implements Notification {
    private static final Log log = LogFactory.getLog(ProducerResponseNotification.class);
    private JCSMPStreamingPublishEventHandler _handler;
    private JCSMPXMLMessageProducer _producer;
    private List<MsgIdInfo> _msgInfos = new LinkedList<MsgIdInfo>();

    public ProducerResponseNotification(JCSMPStreamingPublishEventHandler handler, JCSMPXMLMessageProducer producer) {
        this._handler = handler;
        this._producer = producer;
    }

    public void addMsgInfo(MsgIdInfo info) {
        this._msgInfos.add(info);
    }

    public int handleNotification() {
        if (this.is_canceled()) {
            return 0;
        }
        if (this._handler != null) {
            try {
                if (this._handler != this._producer.getStreamingCallbackHandler()) {
                    log.info((Object)"Streaming publish event handler has been changed, abort notify");
                }
                for (MsgIdInfo info : this._msgInfos) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Notify response received for message " + info.getMsgId()));
                    }
                    if (this._handler instanceof JCSMPStreamingPublishCorrelatingEventHandler) {
                        ((JCSMPStreamingPublishCorrelatingEventHandler)this._handler).responseReceivedEx(info.getCorrKey());
                    } else {
                        this._handler.responseReceived(info.getMsgId());
                    }
                    this._producer.getSessionStats().incStat(StatType.TOTAL_OK_RESPONSE_CALLBACKS);
                }
            }
            catch (JCSMPException e) {
                log.info((Object)"Message producer is closed, abort notify");
            }
        } else {
            log.info((Object)"Streaming publish event handler is null, abort notify");
        }
        return 0;
    }

    public boolean usesHandler(JCSMPStreamingPublishEventHandler handler) {
        return this._handler == handler;
    }

    public boolean usesListener(XMLMessageListener listener) {
        return false;
    }
}

