/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.common.util.SolByteBuffer;
import com.solacesystems.common.util.StringUtil;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.SubscriberEndpoint;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.QueueImpl;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactionSteps;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactoryAssuredCtrl;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssuredCtrlFactory {
    private final int MAX_SELECTOR_LEN = 1023;
    private static final int MAX_USHORT = 65535;
    private static TlvParameterFactoryAssuredCtrl pfac = TlvParameterFactoryAssuredCtrl.instance();
    private final int _protocolVersion;
    private static final Log Trace = LogFactory.getLog(AssuredCtrlFactory.class);
    public static final byte XASTART_FLAG_NONE = 0;
    public static final byte XASTART_FLAG_RESUME = 1;
    public static final byte XASTART_FLAG_JOIN = 2;
    public static final byte XAEND_FLAG_NONE = 0;
    public static final byte XAEND_FLAG_SUSPEND = 1;
    public static final byte XAEND_FLAG_FAILED = 2;
    public static final byte XAEND_FLAG_ROLLBACK = 4;
    public static final byte XAPREPARE_FLAG_NONE = 0;
    public static final byte XACOMMIT_FLAG_NONE = 0;
    public static final byte XACOMMIT_FLAG_ONE_PHASE = 1;
    public static final byte XAROLLBACK_FLAG_NONE = 0;
    public static final byte XAFORGET_FLAG_NONE = 0;
    public static final byte XARECOVER_FLAG_NONE = 0;
    public static final byte XARECOVER_FLAG_RESUME = 1;

    public AssuredCtrlFactory(int protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    public AssuredCtrlHeaderBean createOpenFlowRequest(long lastMsgIdSent, long lastMsgIdAcked, int winSz, String flowName, Long transactedSessionId) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(0);
        if (transactedSessionId != null) {
            assBean.addParam(pfac.getTransactedSessionId(transactedSessionId));
        }
        assBean.addParam(pfac.getFlowName(flowName == null ? "" : flowName));
        assBean.addParam(pfac.getLastMsgIdSent(lastMsgIdSent));
        assBean.addParam(pfac.getLastMsgIdAcked(lastMsgIdAcked));
        assBean.addParam(pfac.getWindowSize(winSz > 255 ? 255 : winSz));
        return assBean;
    }

    public AssuredCtrlHeaderBean createCloseFlowRequest(long flowId) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(7);
        assBean.addParam(pfac.getFlowId(flowId));
        return assBean;
    }

    public AssuredCtrlHeaderBean createCreateEndpointRequest(Endpoint bindTo, AssuredCtrlEnums.QueueAccessType accessType, Integer quotaMB, Integer maxMessageSize, Integer allOthersPermission, Boolean respectTtl, Integer discardBehaviour, Integer maxMsgRedelivery) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(8);
        if (bindTo instanceof Queue) {
            QueueImpl qImpl = (QueueImpl)bindTo;
            assBean.addParam(pfac.getQueueName(qImpl.getNamePartInternal()));
        } else if (bindTo instanceof TopicEndpoint) {
            assBean.addParam(pfac.getDurableTopicEndpointName(bindTo.getName()));
        } else {
            throw new IllegalArgumentException("Endpoint must be Queue or TopicEndpoint");
        }
        assBean.addParam(pfac.getDurability(AssuredCtrlEnums.EndpointDurability.DURABLE));
        if (allOthersPermission != null) {
            assBean.addParam(pfac.getAllOthersPermissions(allOthersPermission));
        }
        if (accessType != null) {
            assBean.addParam(pfac.getAccessType(accessType));
        }
        if (quotaMB != null) {
            assBean.addParam(pfac.getEndpointQuotaMB(quotaMB));
        }
        if (maxMessageSize != null) {
            assBean.addParam(pfac.getEndpointMaxMessageSize(maxMessageSize));
        }
        if (respectTtl != null) {
            assBean.addParam(pfac.getRespectTTL(respectTtl));
        }
        if (discardBehaviour != null) {
            assBean.addParam(pfac.getQEndpointBehaviour(null, discardBehaviour));
        }
        if (maxMsgRedelivery != null) {
            assBean.addParam(pfac.getMaxMsgRedelivery(maxMsgRedelivery));
        }
        return assBean;
    }

    public AssuredCtrlHeaderBean createDeleteEndpointRequest(Endpoint ep_del) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(9);
        if (ep_del instanceof Queue) {
            QueueImpl qImpl = (QueueImpl)ep_del;
            assBean.addParam(pfac.getQueueName(qImpl.getNamePartInternal()));
        } else if (ep_del instanceof TopicEndpoint) {
            assBean.addParam(pfac.getDurableTopicEndpointName(ep_del.getName()));
        } else {
            throw new IllegalArgumentException("Endpoint must be Queue or TopicEndpoint");
        }
        return assBean;
    }

    public AssuredCtrlHeaderBean createFlowRecoverRequest(int flowId, int winSz) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(10);
        assBean.addParam(pfac.getFlowId(flowId));
        assBean.addParam(pfac.getTransportWindowSize(winSz));
        return assBean;
    }

    public AssuredCtrlHeaderBean createResponse(long lastMsgIdAcked, int winSz) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(0);
        assBean.addParam(pfac.getLastMsgIdAcked(lastMsgIdAcked));
        assBean.addParam(pfac.getWindowSize(winSz));
        return assBean;
    }

    public void addTransportAck(AssuredCtrlHeaderBean ctrlBean, long flowId, long lastMsgIdRx, int winSz) {
        ctrlBean.setMsgType(3);
        pfac.addFlowId(ctrlBean, flowId);
        pfac.addLastMsgIdAcked(ctrlBean, lastMsgIdRx);
        pfac.addWindowSize(ctrlBean, winSz);
    }

    public AssuredCtrlHeaderBean createOpenTransactedSession(AssuredCtrlHeaderParameters.ParamTransactionId tid, String transactedSessionName) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(11);
        assBean.addParam(pfac.getTransactionCtrlMessageType(AssuredCtrlEnums.TransactionCtrlMessageType.OPEN_TRANSACTED_SESSION));
        assBean.addParam(pfac.getTransactionId(tid));
        if (!StringUtil.isEmpty(transactedSessionName)) {
            assBean.addParam(pfac.getTransactedSessionName(StringUtil.truncate(transactedSessionName, 64)));
        }
        return assBean;
    }

    public AssuredCtrlHeaderBean createCloseTransactedSession(int transactedSessionId) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(11);
        assBean.addParam(pfac.getTransactionCtrlMessageType(AssuredCtrlEnums.TransactionCtrlMessageType.CLOSE_TRANSACTED_SESSION));
        assBean.addParam(pfac.getTransactedSessionId(transactedSessionId));
        return assBean;
    }

    public AssuredCtrlHeaderBean createCommitTransaction(long transactedSessionId, AssuredCtrlHeaderParameters.ParamTransactionId tid, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(11);
        assBean.addParam(pfac.getTransactionCtrlMessageType(AssuredCtrlEnums.TransactionCtrlMessageType.COMMIT_TRANSACTION));
        assBean.addParam(pfac.getTransactedSessionId(transactedSessionId));
        assBean.addParam(pfac.getTransactionId(tid));
        if (pubnotify != null) {
            assBean.addParam(pfac.getTransactionFDPubNotify(pubnotify));
        }
        if (suback != null) {
            assBean.addParam(pfac.getTransactionFDSubAck(suback));
        }
        return assBean;
    }

    public AssuredCtrlHeaderBean createRollbackTransaction(long transactedSessionId, AssuredCtrlHeaderParameters.ParamTransactionId tid, AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify pubnotify, AssuredCtrlHeaderParameters.ParamTransactionFDSubAck suback) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(11);
        assBean.addParam(pfac.getTransactionCtrlMessageType(AssuredCtrlEnums.TransactionCtrlMessageType.ROLLBACK_TRANSACTION));
        assBean.addParam(pfac.getTransactedSessionId(transactedSessionId));
        assBean.addParam(pfac.getTransactionId(tid));
        if (pubnotify != null) {
            assBean.addParam(pfac.getTransactionFDPubNotify(pubnotify));
        }
        if (suback != null) {
            assBean.addParam(pfac.getTransactionFDSubAck(suback));
        }
        return assBean;
    }

    public AssuredCtrlHeaderBean createOpenXASession(byte version) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getOpenXASessionMessageType(version));
        return assBean;
    }

    public AssuredCtrlHeaderBean createResumeXASession(byte xaVersion, String transactedSessionName) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getResumeXASessionMessageType(xaVersion, transactedSessionName));
        return assBean;
    }

    public AssuredCtrlHeaderBean createCloseXASession(String transactedSessionName) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getCloseXASessionMessageType(transactedSessionName));
        return assBean;
    }

    public AssuredCtrlHeaderBean createXAStart(long transactedSessionId, int transactionTimeout, byte flags, Xid xid) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getXAStartMessageType(flags, (int)transactedSessionId, transactionTimeout, AssuredCtrlFactory.encodeXid(xid)));
        return assBean;
    }

    public AssuredCtrlHeaderBean createXAEnd(long reqTransactedSessionId, long recvTransactedSessionId, byte flags, Xid xid, TransactionSteps txSteps, JCSMPXMLMessageProducer producer) {
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> inputSteps = txSteps.getInputSteps();
        long lastMsgIdSent = 0L;
        if (producer != null) {
            lastMsgIdSent = producer.getPubADManager().lastMessageIdSent;
        }
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getXAEndMessageType(flags, (int)reqTransactedSessionId, (int)recvTransactedSessionId, AssuredCtrlFactory.encodeXid(xid), lastMsgIdSent, AssuredCtrlFactory.encodeConsumedMessageList(inputSteps)));
        return assBean;
    }

    public AssuredCtrlHeaderBean createXAPrepare(long transactedSessionId, byte flags, Xid xid) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getXAPrepareMessageType(flags, (int)transactedSessionId, AssuredCtrlFactory.encodeXid(xid)));
        return assBean;
    }

    public AssuredCtrlHeaderBean createXACommit(long transactedSessionId, byte flags, Xid xid) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getXACommitMessageType(flags, (int)transactedSessionId, AssuredCtrlFactory.encodeXid(xid)));
        return assBean;
    }

    public AssuredCtrlHeaderBean createXARollback(long transactedSessionId, byte flags, Xid xid) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getXARollbackMessageType(flags, (int)transactedSessionId, AssuredCtrlFactory.encodeXid(xid)));
        return assBean;
    }

    public AssuredCtrlHeaderBean createXAForget(long transactedSessionId, byte flags, Xid xid) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getXAForgetMessageType(flags, (int)transactedSessionId, AssuredCtrlFactory.encodeXid(xid)));
        return assBean;
    }

    public AssuredCtrlHeaderBean createXARecover(byte flags, int maxNumXids, byte[] scanCursor) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(14);
        assBean.addParam(pfac.getXARecoverMessageType(flags, maxNumXids, scanCursor));
        return assBean;
    }

    public static byte[] encodeXid(Xid xid) {
        int i;
        byte[] bQual;
        int txIdLength = 0;
        int bQualLength = 0;
        byte[] txId = xid.getGlobalTransactionId();
        if (txId != null) {
            txIdLength = txId.length;
        }
        if ((bQual = xid.getBranchQualifier()) != null) {
            bQualLength = bQual.length;
        }
        byte[] xidEnc = new byte[6 + txIdLength + bQualLength];
        byte[] fmtId = NetworkByteOrderNumberUtil.intToFourByte((long)xid.getFormatId() & 0xFFFFFFFFL);
        for (int i2 = 0; i2 < 4; ++i2) {
            xidEnc[i2] = fmtId[i2];
        }
        if (txIdLength > 64) {
            throw new IllegalArgumentException(String.format("Xid global transaction id size of %d bytes is larger than the maximum of %d", txIdLength, 64));
        }
        xidEnc[4] = (byte)txIdLength;
        if (bQualLength > 64) {
            throw new IllegalArgumentException(String.format("Xid branch qualifier size of %d bytes is larger than the maximum of %d", bQualLength, 64));
        }
        xidEnc[5] = (byte)bQualLength;
        int idx = 6;
        for (i = 0; i < txIdLength; ++i) {
            xidEnc[idx] = txId[i];
            ++idx;
        }
        for (i = 0; i < bQualLength; ++i) {
            xidEnc[idx] = bQual[i];
            ++idx;
        }
        return xidEnc;
    }

    public static byte[] encodeConsumedMessageList(Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> inputSteps) {
        int numMessages = 0;
        String str_buf = "encodeConsumedMessageList: ";
        for (TransactionSteps.InputFlowExtendedInfo inputFlowExtendedInfo : inputSteps.values()) {
            numMessages += inputFlowExtendedInfo.size();
        }
        str_buf = str_buf + "totalNumMsg=" + numMessages;
        int n = numMessages * 8 + inputSteps.size() * 6 + 2;
        SolByteBuffer buffer = new SolByteBuffer(n);
        if (inputSteps.size() > 65535) {
            throw new IllegalArgumentException(String.format("Input Steps size of %d is larger than the maximum size of %d", inputSteps.size(), 65535));
        }
        buffer.writeUShort(inputSteps.size());
        Iterator<FlowHandleImpl> flowIT = inputSteps.keySet().iterator();
        while (flowIT.hasNext()) {
            Long lastMsgRecved = null;
            FlowHandleImpl flow = flowIT.next();
            TransactionSteps.InputFlowExtendedInfo info = (TransactionSteps.InputFlowExtendedInfo)inputSteps.get(flow);
            Long[] msgArr = info.getReceivedIds(true);
            buffer.writeUInt(flow.getEndpointId());
            if (msgArr.length > 65535) {
                throw new IllegalArgumentException(String.format("Message list size of %d is larger than the maximum size of %d", msgArr.length, 65535));
            }
            buffer.writeUShort(msgArr.length);
            lastMsgRecved = null;
            for (Long msgId : msgArr) {
                buffer.writeLong(msgId);
                lastMsgRecved = msgId;
            }
            if (lastMsgRecved == null) continue;
            str_buf = str_buf + ", (numMsgs=" + msgArr.length + " lastMsgRecved=" + lastMsgRecved + ") ";
        }
        if (Trace.isDebugEnabled() && str_buf.length() > 0) {
            Trace.debug((Object)str_buf);
        }
        byte[] msgListEnc = new byte[n];
        System.arraycopy(buffer.getBackingArray(), 0, msgListEnc, 0, n);
        return msgListEnc;
    }

    public AssuredCtrlHeaderBean createFlowChangeUpdateResponse(long flowId, boolean activeFlowIndication) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(12);
        assBean.addParam(pfac.getFlowId(flowId));
        assBean.addParam(pfac.getActiveFlowIndication(activeFlowIndication));
        return assBean;
    }

    public AssuredCtrlHeaderBean createBindRequest(JCSMPSession session, Endpoint bindTo, Topic newTopic, int winSz, int corrTag, String flowName, AssuredCtrlEnums.FlowType flowType, long lastMsgAcked, long lastMsgIdRecved, String sqlSelector, EndpointProperties tmpEndpointProperties, Long transactedSessionId, boolean noLocal, boolean activeFlowIndication) throws InvalidOperationException {
        AssuredCtrlEnums.EndpointDurability dur;
        QueueImpl qimpl;
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(4);
        boolean isTempCapable = session.isCapable(CapabilityType.TEMP_ENDPOINT);
        boolean isBrowserCapable = session.isCapable(CapabilityType.BROWSER);
        boolean isEpMgmtCapable = session.isCapable(CapabilityType.ENDPOINT_MANAGEMENT);
        boolean isSelectorCapable = session.isCapable(CapabilityType.SELECTOR);
        boolean isEndpointTTLCapable = session.isCapable(CapabilityType.ENDPOINT_MESSAGE_TTL);
        boolean isQEndpointFlagsCapable = session.isCapable(CapabilityType.ENDPOINT_DISCARD_BEHAVIOR);
        if (!bindTo.isDurable() && !isTempCapable) {
            throw new InvalidOperationException("Capability mismatch: could not bind to temporary endpoint.");
        }
        if (sqlSelector != null && !isSelectorCapable) {
            throw new InvalidOperationException("Capability mismatch: could not set selector.");
        }
        if (noLocal && !session.isCapable(CapabilityType.NO_LOCAL)) {
            throw new InvalidOperationException("Capability mismatch: peer does not support NoLocal.");
        }
        if (activeFlowIndication && !session.isCapable(CapabilityType.ACTIVE_FLOW_INDICATION)) {
            throw new InvalidOperationException("Capability mismatch: peer does not support active flow indication.");
        }
        if (transactedSessionId != null) {
            assBean.addParam(pfac.getTransactedSessionId(transactedSessionId));
        }
        if (flowType == AssuredCtrlEnums.FlowType.BROWSER) {
            if (!isBrowserCapable) {
                throw new InvalidOperationException("Capability mismatch: could not create browser flow.");
            }
            assBean.addParam(pfac.getFlowType(flowType));
        }
        if (tmpEndpointProperties != null && tmpEndpointProperties.isRespectsMsgTTL() != null && tmpEndpointProperties.isRespectsMsgTTL().booleanValue() && !isEndpointTTLCapable) {
            throw new InvalidOperationException("Capability mismatch: could not set respectsTTL.");
        }
        boolean ep_durable = bindTo.isDurable();
        if (bindTo instanceof Queue) {
            qimpl = (QueueImpl)bindTo;
            assBean.addParam(pfac.getQueueName(qimpl.getNamePartInternal()));
            dur = ep_durable ? AssuredCtrlEnums.EndpointDurability.DURABLE : AssuredCtrlEnums.EndpointDurability.NON_DURABLE_GUARANTEED;
            assBean.addParam(pfac.getDurability(dur));
            if (activeFlowIndication) {
                assBean.addParam(pfac.getWantFlowChangeUpdate(true));
            }
        } else if (bindTo instanceof TopicEndpoint) {
            TopicEndpoint te = (TopicEndpoint)bindTo;
            assBean.addParam(pfac.getDurableTopicEndpointName(te.getName()));
            assBean.addParam(pfac.getTopicName(newTopic.getName()));
            dur = ep_durable ? AssuredCtrlEnums.EndpointDurability.DURABLE : AssuredCtrlEnums.EndpointDurability.NON_DURABLE_GUARANTEED;
            assBean.addParam(pfac.getDurability(dur));
        } else if (bindTo instanceof SubscriberEndpoint) {
            qimpl = (QueueImpl)QueueImpl.createWithInit(bindTo.getName(), true);
            assBean.addParam(pfac.getQueueName(qimpl.getNamePartInternal()));
            assBean.addParam(pfac.getDurability(AssuredCtrlEnums.EndpointDurability.DURABLE));
        } else {
            throw new IllegalArgumentException();
        }
        assBean.addParam(pfac.getWindowSize(winSz));
        if (flowName != null) {
            assBean.addParam(pfac.getFlowName(flowName));
        }
        assBean.addParam(pfac.getLastMsgIdAcked(lastMsgAcked));
        assBean.addParam(pfac.getLastMsgIdRecved(lastMsgIdRecved));
        if (isTempCapable && isEpMgmtCapable && !ep_durable && tmpEndpointProperties != null) {
            Integer allOthersPermission = tmpEndpointProperties.getPermission();
            Integer quotaMB = tmpEndpointProperties.getQuota();
            Integer maxMessageSize = tmpEndpointProperties.getMaxMsgSize();
            Boolean respectsTTL = tmpEndpointProperties.isRespectsMsgTTL();
            Integer discardBehaviour = tmpEndpointProperties.getDiscardBehavior();
            Integer maxMsgRedelivery = tmpEndpointProperties.getMaxMsgRedelivery();
            if (allOthersPermission != null) {
                assBean.addParam(pfac.getAllOthersPermissions(allOthersPermission));
            }
            if (quotaMB != null) {
                assBean.addParam(pfac.getEndpointQuotaMB(quotaMB));
            }
            if (maxMessageSize != null) {
                assBean.addParam(pfac.getEndpointMaxMessageSize(maxMessageSize));
            }
            if (respectsTTL != null && isEndpointTTLCapable) {
                assBean.addParam(pfac.getRespectTTL(respectsTTL));
            }
            if (discardBehaviour != null && isQEndpointFlagsCapable) {
                assBean.addParam(pfac.getQEndpointBehaviour(null, discardBehaviour));
            }
            if (maxMsgRedelivery != null) {
                assBean.addParam(pfac.getMaxMsgRedelivery(maxMsgRedelivery));
            }
        }
        if (sqlSelector != null) {
            try {
                if (sqlSelector.getBytes("UTF-8").length > 1023) {
                    throw new IllegalArgumentException(String.format("Selector is too long, max length is %s bytes.", 1023));
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            assBean.addParam(pfac.getMessageSelector(sqlSelector));
        }
        if (noLocal) {
            assBean.addParam(pfac.getNoLocal());
        }
        return assBean;
    }

    public AssuredCtrlHeaderBean createUnbindRequest(long flowId, boolean linger) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setAssuredCtrlVersion(this._protocolVersion);
        assBean.setMsgType(5);
        assBean.addParam(pfac.getFlowId(flowId));
        if (linger) {
            assBean.addParam(pfac.getUnbindLinger());
        }
        return assBean;
    }

    public AssuredCtrlHeaderBean createUnbindRequest(long flowId, boolean linger, Long lastMsgIdAcked) {
        AssuredCtrlHeaderBean assBean = this.createUnbindRequest(flowId, linger);
        if (lastMsgIdAcked != null) {
            assBean.addParam(pfac.getLastMsgIdAcked(lastMsgIdAcked));
        }
        return assBean;
    }

    public AssuredCtrlHeaderBean createUnsubscribeRequest(String endpointName) {
        AssuredCtrlHeaderBean assBean = new AssuredCtrlHeaderBean();
        assBean.setMsgType(6);
        assBean.addParam(pfac.getDurableTopicEndpointName(endpointName));
        return assBean;
    }
}

