/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import java.io.IOException;
import java.io.InputStream;

public class NetworkIOUtil {
    public static int readDataSafely(InputStream istr, byte[] buf, int off, int len) throws IOException {
        int bytesRead;
        for (int bytesToRead = len; bytesToRead > 0; bytesToRead -= bytesRead) {
            bytesRead = istr.read(buf, off + (len - bytesToRead), bytesToRead);
            if (bytesRead > -1) {
                continue;
            }
            throw new IOException(JCSMPRB.BUNDLE.getStringSafely("NetworkIOUtil.unableToReadEnoughBytesFromStream"));
        }
        return len;
    }

    public static int skipDataSafely(InputStream istr, int bytes) throws IOException {
        int bytesToRead = bytes;
        while (bytesToRead > 0) {
            long bytesRead = istr.skip(bytes);
            if (bytesRead > -1L) {
                bytesToRead = (int)((long)bytesToRead - bytesRead);
                continue;
            }
            throw new IOException(JCSMPRB.BUNDLE.getStringSafely("NetworkIOUtil.unableToSkipEnoughBytesFromStream"));
        }
        return bytes;
    }
}

