/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolMessageConsumer;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTemporaryQueueIF;
import com.solacesystems.jms.SolTemporaryTopicIF;
import com.solacesystems.jms.impl.JCSMPConsumerFactory;
import com.solacesystems.jms.impl.JCSMPMessageListener;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.Validator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolTopicSubscriber
extends SolMessageConsumer
implements TopicSubscriber {
    private static final Log log = LogFactory.getLog(SolTopicSubscriber.class);
    protected String mName;

    SolTopicSubscriber(SolSessionIF session, Topic topic, String messageSelector, boolean noLocal, String name, JMSState state) throws JMSException {
        super(session, (Destination)topic, messageSelector, noLocal, state, name != null);
        this.mName = name;
        this.createConsumer();
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolTopicSubscriber created.");
        }
    }

    public boolean getNoLocal() throws JMSException {
        Validator.checkClosed(this.mState, "MessageConsumer");
        return this.mNoLocal;
    }

    public Topic getTopic() throws JMSException {
        Validator.checkClosed(this.mState, "MessageConsumer");
        return (Topic)this.mDestination;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting message listener in SolTopicSubscriber " + this.mName));
            }
            if (listener == null) {
                ((FlowReceiver)this.mConsumer).setMessageListener(null);
                this.mListener.setMessageListener(listener);
            } else {
                this.mListener.setMessageListener(listener);
                ((FlowReceiver)this.mConsumer).setMessageListener(this.mListener);
            }
            this.processDelayStart();
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.consumer.setlistener", e);
        }
    }

    protected void createConsumer() throws JMSException {
        com.solacesystems.jcsmp.Topic topic = (com.solacesystems.jcsmp.Topic)((SolDestination)this.mDestination).getJCSMPDestination();
        boolean nonDurable = this.mName == null;
        try {
            JCSMPMessageListener listener = this.mListener.getMessageListener() == null ? null : this.mListener;
            if (nonDurable) {
                boolean direct = this.mSessionProps.getConnectionProperties().getPropertyBean().getDirectTransport();
                if (!direct && this.mEndpoint == null) {
                    this.mEndpoint = this.mSessionProps.getConnectionProperties().getJCSMPSession().createNonDurableTopicEndpoint();
                }
                this.mConsumer = this.mConsumerFac.createNonDurableConsumer(topic, (XMLMessageListener)listener, this.mEndpoint, JCSMPConsumerFactory.standard);
            } else {
                if (this.mEndpoint == null) {
                    this.mEndpoint = JCSMPFactory.onlyInstance().createDurableTopicEndpoint(this.mName);
                }
                this.mConsumer = this.mConsumerFac.createDurableConsumer(topic, (XMLMessageListener)listener, this.mEndpoint, JCSMPConsumerFactory.standard);
            }
            super.createConsumer();
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.consumer.create", e);
        }
    }

    public boolean isTemporaryQueueUsed(SolTemporaryQueueIF queue) {
        return false;
    }

    public boolean isTemporaryTopicUsed(SolTemporaryTopicIF topic) {
        if (this.mState != JMSState.Closed) {
            return topic.equals(this.mDestination);
        }
        return false;
    }
}

