/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.transaction.RollbackException;
import com.solacesystems.jcsmp.transaction.TransactedSession;
import com.solacesystems.jms.impl.ConnectionConsumerTransactionStrategy;
import com.solacesystems.jms.impl.JCSMPConsumerFactory;
import com.solacesystems.jms.impl.JCSMPTransactedSession;
import com.solacesystems.jms.impl.Validator;
import java.util.Collection;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TransactionRolledBackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionConsumerLocalTxStrategy
extends ConnectionConsumerTransactionStrategy {
    private static final Log log = LogFactory.getLog(ConnectionConsumerLocalTxStrategy.class);
    private TransactedSession mTxSession;
    private JMSException mLastException = null;
    private final ReentrantLock mTxLock = new ReentrantLock();
    private final Condition mTxCondition = this.mTxLock.newCondition();

    public ConnectionConsumerLocalTxStrategy(ConnectionConsumerTransactionStrategy.InitProperties iprop) {
        super(iprop);
        this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE;
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConnectionConsumerLocalTxStrategy created.");
        }
    }

    @Override
    public void createConsumer() throws JMSException {
        try {
            TransactedSession txsession = this.mConnection.getProperties().getJCSMPSession().createTransactedSession();
            this.mSessionProps.getUserProperties().put("TransactedSession", new JCSMPTransactedSession(txsession));
            this.mTxSession = txsession;
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.session.create", (Throwable)((Object)e));
        }
        this.createConsumerImpl(JCSMPConsumerFactory.standard);
    }

    @Override
    public void closeConsumer() {
        super.closeConsumer();
        if (this.mTxSession != null) {
            this.mTxSession.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consumer closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        try {
            this.mTxLock.lock();
            this.mTxCondition.signalAll();
            Object var2_1 = null;
            this.mTxLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mTxLock.unlock();
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConnectionConsumerLocalTxStrategy closed");
        }
    }

    @Override
    public void reset() {
        this.mTxLock.lock();
        this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE;
        this.mLastException = null;
        this.mTxLock.unlock();
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConnectionConsumerLocalTxStrategy reset");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Collection<Message> msgs) throws JMSException {
        try {
            this.mTxLock.lock();
            this.checkClosed();
            this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE;
            this.mTxCondition.signal();
            Object var3_2 = null;
            this.mTxLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mTxLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommit(Collection<Message> msgs) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering onCommit");
        }
        try {
            this.mTxLock.lock();
            this.checkClosed();
            this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.COMMITTING;
            this.mTxCondition.signal();
            Object var3_2 = null;
            this.mTxLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mTxLock.unlock();
            throw throwable;
        }
        this.mTxLock.lock();
        try {
            try {
                while (this.mTxState == ConnectionConsumerTransactionStrategy.TransactionState.COMMITTING) {
                    this.mTxCondition.await();
                }
                if (this.mLastException != null) {
                    throw this.mLastException;
                }
                Object var5_6 = null;
                this.mTxLock.unlock();
            }
            catch (InterruptedException e) {
                Validator.createJMSException("soljms.operation.session.commit", e);
                Object var5_7 = null;
                this.mTxLock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.mTxLock.unlock();
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving onCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRollback(Collection<Message> msgs) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering onRollback");
        }
        try {
            this.mTxLock.lock();
            this.checkClosed();
            assert (this.mTxState == ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE);
            this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ROLLINGBACK;
            this.mTxCondition.signal();
            Object var3_2 = null;
            this.mTxLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mTxLock.unlock();
            throw throwable;
        }
        this.mTxLock.lock();
        try {
            try {
                while (this.mTxState == ConnectionConsumerTransactionStrategy.TransactionState.ROLLINGBACK) {
                    this.mTxCondition.await();
                }
                if (this.mLastException != null) {
                    throw this.mLastException;
                }
                Object var5_6 = null;
                this.mTxLock.unlock();
            }
            catch (InterruptedException e) {
                Validator.createJMSException("soljms.operation.session.rollback", e);
                Object var5_7 = null;
                this.mTxLock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.mTxLock.unlock();
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving onRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterDelivery() throws JMSException {
        try {
            try {
                this.mTxLock.lock();
                this.checkClosed();
                while (this.mTxState == ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE) {
                    this.mTxCondition.await();
                }
                Object var3_1 = null;
                this.mTxLock.unlock();
            }
            catch (InterruptedException e) {
                throw new JMSException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.mTxLock.unlock();
            throw throwable;
        }
        switch (this.mTxState) {
            case COMMITTING: {
                try {
                    this.mTxSession.commit();
                }
                catch (RollbackException e) {
                    this.mLastException = new TransactionRolledBackException(e.getMessage());
                }
                catch (JCSMPException e) {
                    this.mLastException = Validator.createJMSException("soljms.operation.session.commit", (Throwable)((Object)e));
                }
                break;
            }
            case ROLLINGBACK: {
                try {
                    this.mTxSession.rollback();
                }
                catch (JCSMPException e) {
                    this.mLastException = Validator.createJMSException("soljms.operation.session.rollback", (Throwable)((Object)e));
                }
                break;
            }
        }
        try {
            this.mTxLock.lock();
            this.checkClosed();
            this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE;
            this.mTxCondition.signal();
            Object var5_8 = null;
            this.mTxLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.mTxLock.unlock();
            throw throwable;
        }
    }
}

