/*
 *
 * Copyright (c) 2006-2019, Speedment, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); You may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.speedment.common.tuple;

import com.speedment.common.tuple.internal.TupleInfiniteDegreeOfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple0OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple10OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple11OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple12OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple13OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple14OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple15OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple16OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple17OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple18OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple19OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple1OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple20OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple21OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple22OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple23OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple2OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple3OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple4OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple5OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple6OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple7OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple8OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.Tuple9OfNullablesImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple0OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple10OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple11OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple12OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple13OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple14OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple15OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple16OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple17OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple18OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple19OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple1OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple20OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple21OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple22OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple23OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple2OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple3OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple4OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple5OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple6OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple7OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple8OfNullablesMapperImpl;
import com.speedment.common.tuple.internal.nullable.mapper.Tuple9OfNullablesMapperImpl;
import com.speedment.common.tuple.nullable.Tuple0OfNullables;
import com.speedment.common.tuple.nullable.Tuple10OfNullables;
import com.speedment.common.tuple.nullable.Tuple11OfNullables;
import com.speedment.common.tuple.nullable.Tuple12OfNullables;
import com.speedment.common.tuple.nullable.Tuple13OfNullables;
import com.speedment.common.tuple.nullable.Tuple14OfNullables;
import com.speedment.common.tuple.nullable.Tuple15OfNullables;
import com.speedment.common.tuple.nullable.Tuple16OfNullables;
import com.speedment.common.tuple.nullable.Tuple17OfNullables;
import com.speedment.common.tuple.nullable.Tuple18OfNullables;
import com.speedment.common.tuple.nullable.Tuple19OfNullables;
import com.speedment.common.tuple.nullable.Tuple1OfNullables;
import com.speedment.common.tuple.nullable.Tuple20OfNullables;
import com.speedment.common.tuple.nullable.Tuple21OfNullables;
import com.speedment.common.tuple.nullable.Tuple22OfNullables;
import com.speedment.common.tuple.nullable.Tuple23OfNullables;
import com.speedment.common.tuple.nullable.Tuple2OfNullables;
import com.speedment.common.tuple.nullable.Tuple3OfNullables;
import com.speedment.common.tuple.nullable.Tuple4OfNullables;
import com.speedment.common.tuple.nullable.Tuple5OfNullables;
import com.speedment.common.tuple.nullable.Tuple6OfNullables;
import com.speedment.common.tuple.nullable.Tuple7OfNullables;
import com.speedment.common.tuple.nullable.Tuple8OfNullables;
import com.speedment.common.tuple.nullable.Tuple9OfNullables;

import java.util.function.Function;

/**
 * A collection of static methods to produce different types of {@link
 * TupleOfNullables} objects.
 * <p>
 * Generated by com.speedment.sources.pattern.tuple.TuplesOfNullablesPattern
 * 
 * @author Per Minborg
 */
public final class TuplesOfNullables {
    
    private TuplesOfNullables() {}
    
    /**
     * Creates and returns a new {@link Tuple0OfNullables}  with the given
     * parameters.
     * 
     * @return a new {@link Tuple0OfNullables}  with the given parameters.
     * 
     * @see Tuple0
     * @see Tuple
     */
    public static Tuple0OfNullables ofNullables() {
        return Tuple0OfNullablesImpl.EMPTY_TUPLE;
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple0OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T> type of the initial object to be used by the function to
     *            create a {@link Tuple0 }
     * @return    a Function that, when applied, creates a {@link Tuple0} from
     *            an initial object of type T by applying the given mappers.
     * 
     * @see Tuple0
     * @see Tuple
     */
    @SuppressWarnings("unchecked")
    public static <T> Function<T, Tuple0OfNullables> toTupleOfNullables() {
        return (Function<T, Tuple0OfNullables>) Tuple0OfNullablesMapperImpl.EMPTY_MAPPER;
    }
    
    /**
     * Creates and returns a new {@link Tuple1OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param e0   element 0
     * @return     a new {@link Tuple1OfNullables}  with the given parameters.
     * 
     * @see Tuple1
     * @see Tuple
     */
    public static <T0> Tuple1OfNullables<T0> ofNullables(T0 e0) {
        return new Tuple1OfNullablesImpl<>(e0);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple1OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple1 }
     * @param <T0> target type of m0
     * @param m0   mapper to apply for Tuple1's element 0
     * @return     a Function that, when applied, creates a {@link Tuple1} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple1
     * @see Tuple
     */
    public static <T, T0> Function<T, Tuple1OfNullables<T0>> toTupleOfNullables(Function<T, T0> m0) {
        return new Tuple1OfNullablesMapperImpl<>(m0);
    }
    
    /**
     * Creates and returns a new {@link Tuple2OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param e0   element 0
     * @param e1   element 1
     * @return     a new {@link Tuple2OfNullables}  with the given parameters.
     * 
     * @see Tuple2
     * @see Tuple
     */
    public static <T0, T1> Tuple2OfNullables<T0, T1> ofNullables(T0 e0, T1 e1) {
        return new Tuple2OfNullablesImpl<>(e0, e1);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple2OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple2 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param m0   mapper to apply for Tuple2's element 0
     * @param m1   mapper to apply for Tuple2's element 1
     * @return     a Function that, when applied, creates a {@link Tuple2} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple2
     * @see Tuple
     */
    public static <T, T0, T1> Function<T, Tuple2OfNullables<T0, T1>> toTupleOfNullables(Function<T, T0> m0, Function<T, T1> m1) {
        return new Tuple2OfNullablesMapperImpl<>(m0, m1);
    }
    
    /**
     * Creates and returns a new {@link Tuple3OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @return     a new {@link Tuple3OfNullables}  with the given parameters.
     * 
     * @see Tuple3
     * @see Tuple
     */
    public static <T0, T1, T2> Tuple3OfNullables<T0, T1, T2> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2) {
        return new Tuple3OfNullablesImpl<>(e0, e1, e2);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple3OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple3 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param <T2> target type of m2
     * @param m0   mapper to apply for Tuple3's element 0
     * @param m1   mapper to apply for Tuple3's element 1
     * @param m2   mapper to apply for Tuple3's element 2
     * @return     a Function that, when applied, creates a {@link Tuple3} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple3
     * @see Tuple
     */
    public static <T, T0, T1, T2> Function<T, Tuple3OfNullables<T0, T1, T2>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2) {
        return new Tuple3OfNullablesMapperImpl<>(m0, m1, m2);
    }
    
    /**
     * Creates and returns a new {@link Tuple4OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @return     a new {@link Tuple4OfNullables}  with the given parameters.
     * 
     * @see Tuple4
     * @see Tuple
     */
    public static <T0, T1, T2, T3> Tuple4OfNullables<T0, T1, T2, T3> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3) {
        return new Tuple4OfNullablesImpl<>(e0, e1, e2, e3);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple4OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple4 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param <T2> target type of m2
     * @param <T3> target type of m3
     * @param m0   mapper to apply for Tuple4's element 0
     * @param m1   mapper to apply for Tuple4's element 1
     * @param m2   mapper to apply for Tuple4's element 2
     * @param m3   mapper to apply for Tuple4's element 3
     * @return     a Function that, when applied, creates a {@link Tuple4} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple4
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3> Function<T, Tuple4OfNullables<T0, T1, T2, T3>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3) {
        return new Tuple4OfNullablesMapperImpl<>(m0, m1, m2, m3);
    }
    
    /**
     * Creates and returns a new {@link Tuple5OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @return     a new {@link Tuple5OfNullables}  with the given parameters.
     * 
     * @see Tuple5
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4> Tuple5OfNullables<T0, T1, T2, T3, T4> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4) {
        return new Tuple5OfNullablesImpl<>(e0, e1, e2, e3, e4);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple5OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple5 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param <T2> target type of m2
     * @param <T3> target type of m3
     * @param <T4> target type of m4
     * @param m0   mapper to apply for Tuple5's element 0
     * @param m1   mapper to apply for Tuple5's element 1
     * @param m2   mapper to apply for Tuple5's element 2
     * @param m3   mapper to apply for Tuple5's element 3
     * @param m4   mapper to apply for Tuple5's element 4
     * @return     a Function that, when applied, creates a {@link Tuple5} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple5
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4> Function<T, Tuple5OfNullables<T0, T1, T2, T3, T4>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4) {
        return new Tuple5OfNullablesMapperImpl<>(m0, m1, m2, m3, m4);
    }
    
    /**
     * Creates and returns a new {@link Tuple6OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @return     a new {@link Tuple6OfNullables}  with the given parameters.
     * 
     * @see Tuple6
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5> Tuple6OfNullables<T0, T1, T2, T3, T4, T5> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5) {
        return new Tuple6OfNullablesImpl<>(e0, e1, e2, e3, e4, e5);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple6OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple6 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param <T2> target type of m2
     * @param <T3> target type of m3
     * @param <T4> target type of m4
     * @param <T5> target type of m5
     * @param m0   mapper to apply for Tuple6's element 0
     * @param m1   mapper to apply for Tuple6's element 1
     * @param m2   mapper to apply for Tuple6's element 2
     * @param m3   mapper to apply for Tuple6's element 3
     * @param m4   mapper to apply for Tuple6's element 4
     * @param m5   mapper to apply for Tuple6's element 5
     * @return     a Function that, when applied, creates a {@link Tuple6} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple6
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5> Function<T, Tuple6OfNullables<T0, T1, T2, T3, T4, T5>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5) {
        return new Tuple6OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5);
    }
    
    /**
     * Creates and returns a new {@link Tuple7OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @param e6   element 6
     * @return     a new {@link Tuple7OfNullables}  with the given parameters.
     * 
     * @see Tuple7
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6> Tuple7OfNullables<T0, T1, T2, T3, T4, T5, T6> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6) {
        return new Tuple7OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple7OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple7 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param <T2> target type of m2
     * @param <T3> target type of m3
     * @param <T4> target type of m4
     * @param <T5> target type of m5
     * @param <T6> target type of m6
     * @param m0   mapper to apply for Tuple7's element 0
     * @param m1   mapper to apply for Tuple7's element 1
     * @param m2   mapper to apply for Tuple7's element 2
     * @param m3   mapper to apply for Tuple7's element 3
     * @param m4   mapper to apply for Tuple7's element 4
     * @param m5   mapper to apply for Tuple7's element 5
     * @param m6   mapper to apply for Tuple7's element 6
     * @return     a Function that, when applied, creates a {@link Tuple7} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple7
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6> Function<T, Tuple7OfNullables<T0, T1, T2, T3, T4, T5, T6>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6) {
        return new Tuple7OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6);
    }
    
    /**
     * Creates and returns a new {@link Tuple8OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @param e6   element 6
     * @param e7   element 7
     * @return     a new {@link Tuple8OfNullables}  with the given parameters.
     * 
     * @see Tuple8
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7> Tuple8OfNullables<T0, T1, T2, T3, T4, T5, T6, T7> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7) {
        return new Tuple8OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple8OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple8 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param <T2> target type of m2
     * @param <T3> target type of m3
     * @param <T4> target type of m4
     * @param <T5> target type of m5
     * @param <T6> target type of m6
     * @param <T7> target type of m7
     * @param m0   mapper to apply for Tuple8's element 0
     * @param m1   mapper to apply for Tuple8's element 1
     * @param m2   mapper to apply for Tuple8's element 2
     * @param m3   mapper to apply for Tuple8's element 3
     * @param m4   mapper to apply for Tuple8's element 4
     * @param m5   mapper to apply for Tuple8's element 5
     * @param m6   mapper to apply for Tuple8's element 6
     * @param m7   mapper to apply for Tuple8's element 7
     * @return     a Function that, when applied, creates a {@link Tuple8} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple8
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7> Function<T, Tuple8OfNullables<T0, T1, T2, T3, T4, T5, T6, T7>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7) {
        return new Tuple8OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7);
    }
    
    /**
     * Creates and returns a new {@link Tuple9OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @param <T8> type of element 8
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @param e6   element 6
     * @param e7   element 7
     * @param e8   element 8
     * @return     a new {@link Tuple9OfNullables}  with the given parameters.
     * 
     * @see Tuple9
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8> Tuple9OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8) {
        return new Tuple9OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple9OfNullables} from an initial object of type T by applying the given
     * mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple9 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param <T2> target type of m2
     * @param <T3> target type of m3
     * @param <T4> target type of m4
     * @param <T5> target type of m5
     * @param <T6> target type of m6
     * @param <T7> target type of m7
     * @param <T8> target type of m8
     * @param m0   mapper to apply for Tuple9's element 0
     * @param m1   mapper to apply for Tuple9's element 1
     * @param m2   mapper to apply for Tuple9's element 2
     * @param m3   mapper to apply for Tuple9's element 3
     * @param m4   mapper to apply for Tuple9's element 4
     * @param m5   mapper to apply for Tuple9's element 5
     * @param m6   mapper to apply for Tuple9's element 6
     * @param m7   mapper to apply for Tuple9's element 7
     * @param m8   mapper to apply for Tuple9's element 8
     * @return     a Function that, when applied, creates a {@link Tuple9} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple9
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8> Function<T, Tuple9OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8) {
        return new Tuple9OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8);
    }
    
    /**
     * Creates and returns a new {@link Tuple10OfNullables}  with the given
     * parameters.
     * 
     * @param <T0> type of element 0
     * @param <T1> type of element 1
     * @param <T2> type of element 2
     * @param <T3> type of element 3
     * @param <T4> type of element 4
     * @param <T5> type of element 5
     * @param <T6> type of element 6
     * @param <T7> type of element 7
     * @param <T8> type of element 8
     * @param <T9> type of element 9
     * @param e0   element 0
     * @param e1   element 1
     * @param e2   element 2
     * @param e3   element 3
     * @param e4   element 4
     * @param e5   element 5
     * @param e6   element 6
     * @param e7   element 7
     * @param e8   element 8
     * @param e9   element 9
     * @return     a new {@link Tuple10OfNullables}  with the given parameters.
     * 
     * @see Tuple10
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> Tuple10OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9) {
        return new Tuple10OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple10OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>  type of the initial object to be used by the function to
     *             create a {@link Tuple10 }
     * @param <T0> target type of m0
     * @param <T1> target type of m1
     * @param <T2> target type of m2
     * @param <T3> target type of m3
     * @param <T4> target type of m4
     * @param <T5> target type of m5
     * @param <T6> target type of m6
     * @param <T7> target type of m7
     * @param <T8> target type of m8
     * @param <T9> target type of m9
     * @param m0   mapper to apply for Tuple10's element 0
     * @param m1   mapper to apply for Tuple10's element 1
     * @param m2   mapper to apply for Tuple10's element 2
     * @param m3   mapper to apply for Tuple10's element 3
     * @param m4   mapper to apply for Tuple10's element 4
     * @param m5   mapper to apply for Tuple10's element 5
     * @param m6   mapper to apply for Tuple10's element 6
     * @param m7   mapper to apply for Tuple10's element 7
     * @param m8   mapper to apply for Tuple10's element 8
     * @param m9   mapper to apply for Tuple10's element 9
     * @return     a Function that, when applied, creates a {@link Tuple10} from
     *             an initial object of type T by applying the given mappers.
     * 
     * @see Tuple10
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> Function<T, Tuple10OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9) {
        return new Tuple10OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9);
    }
    
    /**
     * Creates and returns a new {@link Tuple11OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @return      a new {@link Tuple11OfNullables}  with the given parameters.
     * 
     * @see Tuple11
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Tuple11OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10) {
        return new Tuple11OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple11OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple11 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param m0    mapper to apply for Tuple11's element 0
     * @param m1    mapper to apply for Tuple11's element 1
     * @param m2    mapper to apply for Tuple11's element 2
     * @param m3    mapper to apply for Tuple11's element 3
     * @param m4    mapper to apply for Tuple11's element 4
     * @param m5    mapper to apply for Tuple11's element 5
     * @param m6    mapper to apply for Tuple11's element 6
     * @param m7    mapper to apply for Tuple11's element 7
     * @param m8    mapper to apply for Tuple11's element 8
     * @param m9    mapper to apply for Tuple11's element 9
     * @param m10   mapper to apply for Tuple11's element 10
     * @return      a Function that, when applied, creates a {@link Tuple11}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple11
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Function<T, Tuple11OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10) {
        return new Tuple11OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10);
    }
    
    /**
     * Creates and returns a new {@link Tuple12OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @return      a new {@link Tuple12OfNullables}  with the given parameters.
     * 
     * @see Tuple12
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Tuple12OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11) {
        return new Tuple12OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple12OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple12 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param m0    mapper to apply for Tuple12's element 0
     * @param m1    mapper to apply for Tuple12's element 1
     * @param m2    mapper to apply for Tuple12's element 2
     * @param m3    mapper to apply for Tuple12's element 3
     * @param m4    mapper to apply for Tuple12's element 4
     * @param m5    mapper to apply for Tuple12's element 5
     * @param m6    mapper to apply for Tuple12's element 6
     * @param m7    mapper to apply for Tuple12's element 7
     * @param m8    mapper to apply for Tuple12's element 8
     * @param m9    mapper to apply for Tuple12's element 9
     * @param m10   mapper to apply for Tuple12's element 10
     * @param m11   mapper to apply for Tuple12's element 11
     * @return      a Function that, when applied, creates a {@link Tuple12}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple12
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Function<T, Tuple12OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11) {
        return new Tuple12OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11);
    }
    
    /**
     * Creates and returns a new {@link Tuple13OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @return      a new {@link Tuple13OfNullables}  with the given parameters.
     * 
     * @see Tuple13
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Tuple13OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12) {
        return new Tuple13OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple13OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple13 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param m0    mapper to apply for Tuple13's element 0
     * @param m1    mapper to apply for Tuple13's element 1
     * @param m2    mapper to apply for Tuple13's element 2
     * @param m3    mapper to apply for Tuple13's element 3
     * @param m4    mapper to apply for Tuple13's element 4
     * @param m5    mapper to apply for Tuple13's element 5
     * @param m6    mapper to apply for Tuple13's element 6
     * @param m7    mapper to apply for Tuple13's element 7
     * @param m8    mapper to apply for Tuple13's element 8
     * @param m9    mapper to apply for Tuple13's element 9
     * @param m10   mapper to apply for Tuple13's element 10
     * @param m11   mapper to apply for Tuple13's element 11
     * @param m12   mapper to apply for Tuple13's element 12
     * @return      a Function that, when applied, creates a {@link Tuple13}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple13
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Function<T, Tuple13OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12) {
        return new Tuple13OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12);
    }
    
    /**
     * Creates and returns a new {@link Tuple14OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @return      a new {@link Tuple14OfNullables}  with the given parameters.
     * 
     * @see Tuple14
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Tuple14OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13) {
        return new Tuple14OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple14OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple14 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param m0    mapper to apply for Tuple14's element 0
     * @param m1    mapper to apply for Tuple14's element 1
     * @param m2    mapper to apply for Tuple14's element 2
     * @param m3    mapper to apply for Tuple14's element 3
     * @param m4    mapper to apply for Tuple14's element 4
     * @param m5    mapper to apply for Tuple14's element 5
     * @param m6    mapper to apply for Tuple14's element 6
     * @param m7    mapper to apply for Tuple14's element 7
     * @param m8    mapper to apply for Tuple14's element 8
     * @param m9    mapper to apply for Tuple14's element 9
     * @param m10   mapper to apply for Tuple14's element 10
     * @param m11   mapper to apply for Tuple14's element 11
     * @param m12   mapper to apply for Tuple14's element 12
     * @param m13   mapper to apply for Tuple14's element 13
     * @return      a Function that, when applied, creates a {@link Tuple14}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple14
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Function<T, Tuple14OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13) {
        return new Tuple14OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13);
    }
    
    /**
     * Creates and returns a new {@link Tuple15OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @return      a new {@link Tuple15OfNullables}  with the given parameters.
     * 
     * @see Tuple15
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Tuple15OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14) {
        return new Tuple15OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple15OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple15 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param m0    mapper to apply for Tuple15's element 0
     * @param m1    mapper to apply for Tuple15's element 1
     * @param m2    mapper to apply for Tuple15's element 2
     * @param m3    mapper to apply for Tuple15's element 3
     * @param m4    mapper to apply for Tuple15's element 4
     * @param m5    mapper to apply for Tuple15's element 5
     * @param m6    mapper to apply for Tuple15's element 6
     * @param m7    mapper to apply for Tuple15's element 7
     * @param m8    mapper to apply for Tuple15's element 8
     * @param m9    mapper to apply for Tuple15's element 9
     * @param m10   mapper to apply for Tuple15's element 10
     * @param m11   mapper to apply for Tuple15's element 11
     * @param m12   mapper to apply for Tuple15's element 12
     * @param m13   mapper to apply for Tuple15's element 13
     * @param m14   mapper to apply for Tuple15's element 14
     * @return      a Function that, when applied, creates a {@link Tuple15}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple15
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Function<T, Tuple15OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14) {
        return new Tuple15OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14);
    }
    
    /**
     * Creates and returns a new {@link Tuple16OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @return      a new {@link Tuple16OfNullables}  with the given parameters.
     * 
     * @see Tuple16
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Tuple16OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14,
            T15 e15) {
        return new Tuple16OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple16OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple16 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param <T15> target type of m15
     * @param m0    mapper to apply for Tuple16's element 0
     * @param m1    mapper to apply for Tuple16's element 1
     * @param m2    mapper to apply for Tuple16's element 2
     * @param m3    mapper to apply for Tuple16's element 3
     * @param m4    mapper to apply for Tuple16's element 4
     * @param m5    mapper to apply for Tuple16's element 5
     * @param m6    mapper to apply for Tuple16's element 6
     * @param m7    mapper to apply for Tuple16's element 7
     * @param m8    mapper to apply for Tuple16's element 8
     * @param m9    mapper to apply for Tuple16's element 9
     * @param m10   mapper to apply for Tuple16's element 10
     * @param m11   mapper to apply for Tuple16's element 11
     * @param m12   mapper to apply for Tuple16's element 12
     * @param m13   mapper to apply for Tuple16's element 13
     * @param m14   mapper to apply for Tuple16's element 14
     * @param m15   mapper to apply for Tuple16's element 15
     * @return      a Function that, when applied, creates a {@link Tuple16}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple16
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Function<T, Tuple16OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14,
            Function<T, T15> m15) {
        return new Tuple16OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15);
    }
    
    /**
     * Creates and returns a new {@link Tuple17OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @return      a new {@link Tuple17OfNullables}  with the given parameters.
     * 
     * @see Tuple17
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Tuple17OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14,
            T15 e15,
            T16 e16) {
        return new Tuple17OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple17OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple17 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param <T15> target type of m15
     * @param <T16> target type of m16
     * @param m0    mapper to apply for Tuple17's element 0
     * @param m1    mapper to apply for Tuple17's element 1
     * @param m2    mapper to apply for Tuple17's element 2
     * @param m3    mapper to apply for Tuple17's element 3
     * @param m4    mapper to apply for Tuple17's element 4
     * @param m5    mapper to apply for Tuple17's element 5
     * @param m6    mapper to apply for Tuple17's element 6
     * @param m7    mapper to apply for Tuple17's element 7
     * @param m8    mapper to apply for Tuple17's element 8
     * @param m9    mapper to apply for Tuple17's element 9
     * @param m10   mapper to apply for Tuple17's element 10
     * @param m11   mapper to apply for Tuple17's element 11
     * @param m12   mapper to apply for Tuple17's element 12
     * @param m13   mapper to apply for Tuple17's element 13
     * @param m14   mapper to apply for Tuple17's element 14
     * @param m15   mapper to apply for Tuple17's element 15
     * @param m16   mapper to apply for Tuple17's element 16
     * @return      a Function that, when applied, creates a {@link Tuple17}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple17
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Function<T, Tuple17OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14,
            Function<T, T15> m15,
            Function<T, T16> m16) {
        return new Tuple17OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16);
    }
    
    /**
     * Creates and returns a new {@link Tuple18OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @return      a new {@link Tuple18OfNullables}  with the given parameters.
     * 
     * @see Tuple18
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> Tuple18OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14,
            T15 e15,
            T16 e16,
            T17 e17) {
        return new Tuple18OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple18OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple18 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param <T15> target type of m15
     * @param <T16> target type of m16
     * @param <T17> target type of m17
     * @param m0    mapper to apply for Tuple18's element 0
     * @param m1    mapper to apply for Tuple18's element 1
     * @param m2    mapper to apply for Tuple18's element 2
     * @param m3    mapper to apply for Tuple18's element 3
     * @param m4    mapper to apply for Tuple18's element 4
     * @param m5    mapper to apply for Tuple18's element 5
     * @param m6    mapper to apply for Tuple18's element 6
     * @param m7    mapper to apply for Tuple18's element 7
     * @param m8    mapper to apply for Tuple18's element 8
     * @param m9    mapper to apply for Tuple18's element 9
     * @param m10   mapper to apply for Tuple18's element 10
     * @param m11   mapper to apply for Tuple18's element 11
     * @param m12   mapper to apply for Tuple18's element 12
     * @param m13   mapper to apply for Tuple18's element 13
     * @param m14   mapper to apply for Tuple18's element 14
     * @param m15   mapper to apply for Tuple18's element 15
     * @param m16   mapper to apply for Tuple18's element 16
     * @param m17   mapper to apply for Tuple18's element 17
     * @return      a Function that, when applied, creates a {@link Tuple18}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple18
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> Function<T, Tuple18OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14,
            Function<T, T15> m15,
            Function<T, T16> m16,
            Function<T, T17> m17) {
        return new Tuple18OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17);
    }
    
    /**
     * Creates and returns a new {@link Tuple19OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @return      a new {@link Tuple19OfNullables}  with the given parameters.
     * 
     * @see Tuple19
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> Tuple19OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14,
            T15 e15,
            T16 e16,
            T17 e17,
            T18 e18) {
        return new Tuple19OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple19OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple19 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param <T15> target type of m15
     * @param <T16> target type of m16
     * @param <T17> target type of m17
     * @param <T18> target type of m18
     * @param m0    mapper to apply for Tuple19's element 0
     * @param m1    mapper to apply for Tuple19's element 1
     * @param m2    mapper to apply for Tuple19's element 2
     * @param m3    mapper to apply for Tuple19's element 3
     * @param m4    mapper to apply for Tuple19's element 4
     * @param m5    mapper to apply for Tuple19's element 5
     * @param m6    mapper to apply for Tuple19's element 6
     * @param m7    mapper to apply for Tuple19's element 7
     * @param m8    mapper to apply for Tuple19's element 8
     * @param m9    mapper to apply for Tuple19's element 9
     * @param m10   mapper to apply for Tuple19's element 10
     * @param m11   mapper to apply for Tuple19's element 11
     * @param m12   mapper to apply for Tuple19's element 12
     * @param m13   mapper to apply for Tuple19's element 13
     * @param m14   mapper to apply for Tuple19's element 14
     * @param m15   mapper to apply for Tuple19's element 15
     * @param m16   mapper to apply for Tuple19's element 16
     * @param m17   mapper to apply for Tuple19's element 17
     * @param m18   mapper to apply for Tuple19's element 18
     * @return      a Function that, when applied, creates a {@link Tuple19}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple19
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> Function<T, Tuple19OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14,
            Function<T, T15> m15,
            Function<T, T16> m16,
            Function<T, T17> m17,
            Function<T, T18> m18) {
        return new Tuple19OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18);
    }
    
    /**
     * Creates and returns a new {@link Tuple20OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @param e19   element 19
     * @return      a new {@link Tuple20OfNullables}  with the given parameters.
     * 
     * @see Tuple20
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> Tuple20OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14,
            T15 e15,
            T16 e16,
            T17 e17,
            T18 e18,
            T19 e19) {
        return new Tuple20OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple20OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple20 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param <T15> target type of m15
     * @param <T16> target type of m16
     * @param <T17> target type of m17
     * @param <T18> target type of m18
     * @param <T19> target type of m19
     * @param m0    mapper to apply for Tuple20's element 0
     * @param m1    mapper to apply for Tuple20's element 1
     * @param m2    mapper to apply for Tuple20's element 2
     * @param m3    mapper to apply for Tuple20's element 3
     * @param m4    mapper to apply for Tuple20's element 4
     * @param m5    mapper to apply for Tuple20's element 5
     * @param m6    mapper to apply for Tuple20's element 6
     * @param m7    mapper to apply for Tuple20's element 7
     * @param m8    mapper to apply for Tuple20's element 8
     * @param m9    mapper to apply for Tuple20's element 9
     * @param m10   mapper to apply for Tuple20's element 10
     * @param m11   mapper to apply for Tuple20's element 11
     * @param m12   mapper to apply for Tuple20's element 12
     * @param m13   mapper to apply for Tuple20's element 13
     * @param m14   mapper to apply for Tuple20's element 14
     * @param m15   mapper to apply for Tuple20's element 15
     * @param m16   mapper to apply for Tuple20's element 16
     * @param m17   mapper to apply for Tuple20's element 17
     * @param m18   mapper to apply for Tuple20's element 18
     * @param m19   mapper to apply for Tuple20's element 19
     * @return      a Function that, when applied, creates a {@link Tuple20}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple20
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> Function<T, Tuple20OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14,
            Function<T, T15> m15,
            Function<T, T16> m16,
            Function<T, T17> m17,
            Function<T, T18> m18,
            Function<T, T19> m19) {
        return new Tuple20OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19);
    }
    
    /**
     * Creates and returns a new {@link Tuple21OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @param e19   element 19
     * @param e20   element 20
     * @return      a new {@link Tuple21OfNullables}  with the given parameters.
     * 
     * @see Tuple21
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> Tuple21OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14,
            T15 e15,
            T16 e16,
            T17 e17,
            T18 e18,
            T19 e19,
            T20 e20) {
        return new Tuple21OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple21OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple21 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param <T15> target type of m15
     * @param <T16> target type of m16
     * @param <T17> target type of m17
     * @param <T18> target type of m18
     * @param <T19> target type of m19
     * @param <T20> target type of m20
     * @param m0    mapper to apply for Tuple21's element 0
     * @param m1    mapper to apply for Tuple21's element 1
     * @param m2    mapper to apply for Tuple21's element 2
     * @param m3    mapper to apply for Tuple21's element 3
     * @param m4    mapper to apply for Tuple21's element 4
     * @param m5    mapper to apply for Tuple21's element 5
     * @param m6    mapper to apply for Tuple21's element 6
     * @param m7    mapper to apply for Tuple21's element 7
     * @param m8    mapper to apply for Tuple21's element 8
     * @param m9    mapper to apply for Tuple21's element 9
     * @param m10   mapper to apply for Tuple21's element 10
     * @param m11   mapper to apply for Tuple21's element 11
     * @param m12   mapper to apply for Tuple21's element 12
     * @param m13   mapper to apply for Tuple21's element 13
     * @param m14   mapper to apply for Tuple21's element 14
     * @param m15   mapper to apply for Tuple21's element 15
     * @param m16   mapper to apply for Tuple21's element 16
     * @param m17   mapper to apply for Tuple21's element 17
     * @param m18   mapper to apply for Tuple21's element 18
     * @param m19   mapper to apply for Tuple21's element 19
     * @param m20   mapper to apply for Tuple21's element 20
     * @return      a Function that, when applied, creates a {@link Tuple21}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple21
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> Function<T, Tuple21OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14,
            Function<T, T15> m15,
            Function<T, T16> m16,
            Function<T, T17> m17,
            Function<T, T18> m18,
            Function<T, T19> m19,
            Function<T, T20> m20) {
        return new Tuple21OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20);
    }
    
    /**
     * Creates and returns a new {@link Tuple22OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @param <T21> type of element 21
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @param e19   element 19
     * @param e20   element 20
     * @param e21   element 21
     * @return      a new {@link Tuple22OfNullables}  with the given parameters.
     * 
     * @see Tuple22
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> Tuple22OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14,
            T15 e15,
            T16 e16,
            T17 e17,
            T18 e18,
            T19 e19,
            T20 e20,
            T21 e21) {
        return new Tuple22OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple22OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple22 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param <T15> target type of m15
     * @param <T16> target type of m16
     * @param <T17> target type of m17
     * @param <T18> target type of m18
     * @param <T19> target type of m19
     * @param <T20> target type of m20
     * @param <T21> target type of m21
     * @param m0    mapper to apply for Tuple22's element 0
     * @param m1    mapper to apply for Tuple22's element 1
     * @param m2    mapper to apply for Tuple22's element 2
     * @param m3    mapper to apply for Tuple22's element 3
     * @param m4    mapper to apply for Tuple22's element 4
     * @param m5    mapper to apply for Tuple22's element 5
     * @param m6    mapper to apply for Tuple22's element 6
     * @param m7    mapper to apply for Tuple22's element 7
     * @param m8    mapper to apply for Tuple22's element 8
     * @param m9    mapper to apply for Tuple22's element 9
     * @param m10   mapper to apply for Tuple22's element 10
     * @param m11   mapper to apply for Tuple22's element 11
     * @param m12   mapper to apply for Tuple22's element 12
     * @param m13   mapper to apply for Tuple22's element 13
     * @param m14   mapper to apply for Tuple22's element 14
     * @param m15   mapper to apply for Tuple22's element 15
     * @param m16   mapper to apply for Tuple22's element 16
     * @param m17   mapper to apply for Tuple22's element 17
     * @param m18   mapper to apply for Tuple22's element 18
     * @param m19   mapper to apply for Tuple22's element 19
     * @param m20   mapper to apply for Tuple22's element 20
     * @param m21   mapper to apply for Tuple22's element 21
     * @return      a Function that, when applied, creates a {@link Tuple22}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple22
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> Function<T, Tuple22OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14,
            Function<T, T15> m15,
            Function<T, T16> m16,
            Function<T, T17> m17,
            Function<T, T18> m18,
            Function<T, T19> m19,
            Function<T, T20> m20,
            Function<T, T21> m21) {
        return new Tuple22OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21);
    }
    
    /**
     * Creates and returns a new {@link Tuple23OfNullables}  with the given
     * parameters.
     * 
     * @param <T0>  type of element 0
     * @param <T1>  type of element 1
     * @param <T2>  type of element 2
     * @param <T3>  type of element 3
     * @param <T4>  type of element 4
     * @param <T5>  type of element 5
     * @param <T6>  type of element 6
     * @param <T7>  type of element 7
     * @param <T8>  type of element 8
     * @param <T9>  type of element 9
     * @param <T10> type of element 10
     * @param <T11> type of element 11
     * @param <T12> type of element 12
     * @param <T13> type of element 13
     * @param <T14> type of element 14
     * @param <T15> type of element 15
     * @param <T16> type of element 16
     * @param <T17> type of element 17
     * @param <T18> type of element 18
     * @param <T19> type of element 19
     * @param <T20> type of element 20
     * @param <T21> type of element 21
     * @param <T22> type of element 22
     * @param e0    element 0
     * @param e1    element 1
     * @param e2    element 2
     * @param e3    element 3
     * @param e4    element 4
     * @param e5    element 5
     * @param e6    element 6
     * @param e7    element 7
     * @param e8    element 8
     * @param e9    element 9
     * @param e10   element 10
     * @param e11   element 11
     * @param e12   element 12
     * @param e13   element 13
     * @param e14   element 14
     * @param e15   element 15
     * @param e16   element 16
     * @param e17   element 17
     * @param e18   element 18
     * @param e19   element 19
     * @param e20   element 20
     * @param e21   element 21
     * @param e22   element 22
     * @return      a new {@link Tuple23OfNullables}  with the given parameters.
     * 
     * @see Tuple23
     * @see Tuple
     */
    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> Tuple23OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> ofNullables(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14,
            T15 e15,
            T16 e16,
            T17 e17,
            T18 e18,
            T19 e19,
            T20 e20,
            T21 e21,
            T22 e22) {
        return new Tuple23OfNullablesImpl<>(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22);
    }
    
    /**
     * Creates and returns a Function that, when applied, creates a {@link
     * Tuple23OfNullables} from an initial object of type T by applying the
     * given mappers.
     * 
     * @param <T>   type of the initial object to be used by the function to
     *              create a {@link Tuple23 }
     * @param <T0>  target type of m0
     * @param <T1>  target type of m1
     * @param <T2>  target type of m2
     * @param <T3>  target type of m3
     * @param <T4>  target type of m4
     * @param <T5>  target type of m5
     * @param <T6>  target type of m6
     * @param <T7>  target type of m7
     * @param <T8>  target type of m8
     * @param <T9>  target type of m9
     * @param <T10> target type of m10
     * @param <T11> target type of m11
     * @param <T12> target type of m12
     * @param <T13> target type of m13
     * @param <T14> target type of m14
     * @param <T15> target type of m15
     * @param <T16> target type of m16
     * @param <T17> target type of m17
     * @param <T18> target type of m18
     * @param <T19> target type of m19
     * @param <T20> target type of m20
     * @param <T21> target type of m21
     * @param <T22> target type of m22
     * @param m0    mapper to apply for Tuple23's element 0
     * @param m1    mapper to apply for Tuple23's element 1
     * @param m2    mapper to apply for Tuple23's element 2
     * @param m3    mapper to apply for Tuple23's element 3
     * @param m4    mapper to apply for Tuple23's element 4
     * @param m5    mapper to apply for Tuple23's element 5
     * @param m6    mapper to apply for Tuple23's element 6
     * @param m7    mapper to apply for Tuple23's element 7
     * @param m8    mapper to apply for Tuple23's element 8
     * @param m9    mapper to apply for Tuple23's element 9
     * @param m10   mapper to apply for Tuple23's element 10
     * @param m11   mapper to apply for Tuple23's element 11
     * @param m12   mapper to apply for Tuple23's element 12
     * @param m13   mapper to apply for Tuple23's element 13
     * @param m14   mapper to apply for Tuple23's element 14
     * @param m15   mapper to apply for Tuple23's element 15
     * @param m16   mapper to apply for Tuple23's element 16
     * @param m17   mapper to apply for Tuple23's element 17
     * @param m18   mapper to apply for Tuple23's element 18
     * @param m19   mapper to apply for Tuple23's element 19
     * @param m20   mapper to apply for Tuple23's element 20
     * @param m21   mapper to apply for Tuple23's element 21
     * @param m22   mapper to apply for Tuple23's element 22
     * @return      a Function that, when applied, creates a {@link Tuple23}
     *              from an initial object of type T by applying the given
     *              mappers.
     * 
     * @see Tuple23
     * @see Tuple
     */
    public static <T, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> Function<T, Tuple23OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> toTupleOfNullables(
            Function<T, T0> m0,
            Function<T, T1> m1,
            Function<T, T2> m2,
            Function<T, T3> m3,
            Function<T, T4> m4,
            Function<T, T5> m5,
            Function<T, T6> m6,
            Function<T, T7> m7,
            Function<T, T8> m8,
            Function<T, T9> m9,
            Function<T, T10> m10,
            Function<T, T11> m11,
            Function<T, T12> m12,
            Function<T, T13> m13,
            Function<T, T14> m14,
            Function<T, T15> m15,
            Function<T, T16> m16,
            Function<T, T17> m17,
            Function<T, T18> m18,
            Function<T, T19> m19,
            Function<T, T20> m20,
            Function<T, T21> m21,
            Function<T, T22> m22) {
        return new Tuple23OfNullablesMapperImpl<>(m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22);
    }
    
    /**
     * Creates and returns a {@link TupleOfNullables} with the given parameters
     * 
     * @param el array of elements to use for the TupleOfNullables
     * @return   a {@link TupleOfNullables} with the given parameters
     * 
     * @see TupleOfNullables
     */
    public static TupleOfNullables ofNullablesArray(Object... el) {
        switch (el.length) {
            case 0: return ofNullables();
            case 1: return ofNullables(el[0]);
            case 2: return ofNullables(el[0], el[1]);
            case 3: return ofNullables(el[0], el[1], el[2]);
            case 4: return ofNullables(el[0], el[1], el[2], el[3]);
            case 5: return ofNullables(el[0], el[1], el[2], el[3], el[4]);
            case 6: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5]);
            case 7: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6]);
            case 8: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7]);
            case 9: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8]);
            case 10: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9]);
            case 11: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10]);
            case 12: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11]);
            case 13: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12]);
            case 14: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13]);
            case 15: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14]);
            case 16: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14], el[15]);
            case 17: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14], el[15], el[16]);
            case 18: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14], el[15], el[16], el[17]);
            case 19: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14], el[15], el[16], el[17], el[18]);
            case 20: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14], el[15], el[16], el[17], el[18], el[19]);
            case 21: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14], el[15], el[16], el[17], el[18], el[19], el[20]);
            case 22: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14], el[15], el[16], el[17], el[18], el[19], el[20], el[21]);
            case 23: return ofNullables(el[0], el[1], el[2], el[3], el[4], el[5], el[6], el[7], el[8], el[9], el[10], el[11], el[12], el[13], el[14], el[15], el[16], el[17], el[18], el[19], el[20], el[21], el[22]);
            default: return new TupleInfiniteDegreeOfNullablesImpl(el);
        }
    }
}