/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.tuple.internal;

import com.speedment.common.tuple.BasicTuple;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BasicAbstractTuple<T extends BasicTuple<R>, R>
implements BasicTuple<R> {
    protected final Object[] values;
    protected final Class<? extends T> baseClass;

    BasicAbstractTuple(Class<? extends T> baseClass, Object ... values) {
        Objects.requireNonNull(values);
        this.baseClass = Objects.requireNonNull(baseClass);
        if (!this.isNullable()) {
            for (Object v : values) {
                Objects.requireNonNull(v, () -> this.getClass().getName() + " cannot hold null values.");
            }
        }
        this.values = Arrays.copyOf(values, values.length);
        if (values.length != this.degree()) {
            throw new IllegalArgumentException("A Tuple of degree " + this.degree() + " must contain exactly " + this.degree() + " elements. Element length was " + values.length);
        }
    }

    protected abstract boolean isNullable();

    protected int assertIndexBounds(int index) {
        if (index < 0 || index >= this.degree()) {
            throw new IndexOutOfBoundsException("index " + index + " is illegal. The degree of this Tuple is " + this.degree() + ".");
        }
        return index;
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.baseClass.isInstance(obj)) {
            return false;
        }
        if (obj instanceof BasicAbstractTuple) {
            BasicAbstractTuple tuple = (BasicAbstractTuple)obj;
            return Arrays.equals(this.values, tuple.values);
        }
        BasicTuple tuple = (BasicTuple)obj;
        int capacity = tuple.degree();
        for (int i = 0; i < capacity; ++i) {
            if (Objects.equals(this.get(i), tuple.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + Stream.of(this.values).map(Objects::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    @Override
    public <C> Stream<C> streamOf(Class<C> clazz) {
        Objects.requireNonNull(clazz);
        return Stream.of(this.values).filter(clazz::isInstance).map(clazz::cast);
    }
}

