/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field;

import com.speedment.common.function.ToBooleanFunction;
import com.speedment.common.function.ToByteFunction;
import com.speedment.common.function.ToCharFunction;
import com.speedment.common.function.ToFloatFunction;
import com.speedment.common.function.ToShortFunction;
import com.speedment.runtime.compute.ToBigDecimalNullable;
import com.speedment.runtime.compute.ToBooleanNullable;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToCharNullable;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToEnumNullable;
import com.speedment.runtime.compute.ToFloatNullable;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToLongNullable;
import com.speedment.runtime.compute.ToShortNullable;
import com.speedment.runtime.compute.ToStringNullable;
import com.speedment.runtime.compute.trait.HasMapToDoubleIfPresent;
import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.Field;
import com.speedment.runtime.field.exception.SpeedmentFieldException;
import com.speedment.runtime.field.internal.ReferenceFieldImpl;
import com.speedment.runtime.field.internal.expression.FieldToBigDecimalImpl;
import com.speedment.runtime.field.internal.expression.FieldToBooleanImpl;
import com.speedment.runtime.field.internal.expression.FieldToByteImpl;
import com.speedment.runtime.field.internal.expression.FieldToCharImpl;
import com.speedment.runtime.field.internal.expression.FieldToDoubleImpl;
import com.speedment.runtime.field.internal.expression.FieldToEnumImpl;
import com.speedment.runtime.field.internal.expression.FieldToFloatImpl;
import com.speedment.runtime.field.internal.expression.FieldToIntImpl;
import com.speedment.runtime.field.internal.expression.FieldToLongImpl;
import com.speedment.runtime.field.internal.expression.FieldToShortImpl;
import com.speedment.runtime.field.internal.expression.FieldToStringImpl;
import com.speedment.runtime.field.method.ReferenceGetter;
import com.speedment.runtime.field.method.ReferenceSetter;
import com.speedment.runtime.field.trait.HasReferenceOperators;
import com.speedment.runtime.field.trait.HasReferenceValue;
import com.speedment.runtime.typemapper.TypeMapper;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public interface ReferenceField<ENTITY, D, V>
extends Field<ENTITY>,
HasReferenceOperators<ENTITY>,
HasReferenceValue<ENTITY, D, V>,
HasMapToDoubleIfPresent<ENTITY, ToDoubleFunction<V>> {
    public static <ENTITY, D, V> ReferenceField<ENTITY, D, V> create(ColumnIdentifier<ENTITY> identifier, ReferenceGetter<ENTITY, V> getter, ReferenceSetter<ENTITY, V> setter, TypeMapper<D, V> typeMapper, boolean unique) {
        return new ReferenceFieldImpl<ENTITY, D, V>(identifier, getter, setter, typeMapper, unique);
    }

    public ReferenceField<ENTITY, D, V> tableAlias(String var1);

    default public ToByteNullable<ENTITY> mapToByteIfPresent(ToByteFunction<V> mapper) {
        return new FieldToByteImpl(this, mapper);
    }

    default public ToByteNullable<ENTITY> asByte() {
        return this.mapToByteIfPresent(val -> {
            if (val instanceof Number) {
                Number number = (Number)val;
                return number.byteValue();
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type byte, but it was not.", this.identifier()));
        });
    }

    default public ToShortNullable<ENTITY> mapToShortIfPresent(ToShortFunction<V> mapper) {
        return new FieldToShortImpl(this, mapper);
    }

    default public ToShortNullable<ENTITY> asShort() {
        return this.mapToShortIfPresent(val -> {
            if (val instanceof Number) {
                Number number = (Number)val;
                return number.shortValue();
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type short, but it was not.", this.identifier()));
        });
    }

    default public ToIntNullable<ENTITY> mapToIntIfPresent(ToIntFunction<V> mapper) {
        return new FieldToIntImpl(this, mapper);
    }

    default public ToIntNullable<ENTITY> asInt() {
        return this.mapToIntIfPresent(val -> {
            if (val instanceof Number) {
                Number number = (Number)val;
                return number.intValue();
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type int, but it was not.", this.identifier()));
        });
    }

    default public ToLongNullable<ENTITY> mapToLongIfPresent(ToLongFunction<V> mapper) {
        return new FieldToLongImpl(this, mapper);
    }

    default public ToLongNullable<ENTITY> asLong() {
        return this.mapToLongIfPresent(val -> {
            if (val instanceof Number) {
                Number number = (Number)val;
                return number.longValue();
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type long, but it was not.", this.identifier()));
        });
    }

    default public ToFloatNullable<ENTITY> mapToFloatIfPresent(ToFloatFunction<V> mapper) {
        return new FieldToFloatImpl(this, mapper);
    }

    default public ToFloatNullable<ENTITY> asFloat() {
        return this.mapToFloatIfPresent(val -> {
            if (val instanceof Number) {
                Number number = (Number)val;
                return number.floatValue();
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type float, but it was not.", this.identifier()));
        });
    }

    default public ToDoubleNullable<ENTITY> mapToDoubleIfPresent(ToDoubleFunction<V> mapper) {
        return new FieldToDoubleImpl(this, mapper);
    }

    default public ToDoubleNullable<ENTITY> asDouble() {
        return this.mapToDoubleIfPresent((V val) -> {
            if (val instanceof Number) {
                Number number = (Number)val;
                return number.doubleValue();
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type double, but it was not.", this.identifier()));
        });
    }

    default public ToCharNullable<ENTITY> mapToCharIfPresent(ToCharFunction<V> mapper) {
        return new FieldToCharImpl(this, mapper);
    }

    default public ToCharNullable<ENTITY> asChar() {
        return this.mapToCharIfPresent(val -> {
            if (val instanceof Number) {
                Number number = (Number)val;
                return (char)number.intValue();
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type char, but it was not.", this.identifier()));
        });
    }

    default public ToBooleanNullable<ENTITY> mapToBooleanIfPresent(ToBooleanFunction<V> mapper) {
        return new FieldToBooleanImpl(this, mapper);
    }

    default public ToBooleanNullable<ENTITY> asBoolean() {
        return this.mapToBooleanIfPresent(val -> {
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type boolean, but it was not.", this.identifier()));
        });
    }

    default public ToStringNullable<ENTITY> mapToStringIfPresent(Function<V, String> mapper) {
        return new FieldToStringImpl(this, mapper);
    }

    default public ToStringNullable<ENTITY> asString() {
        return this.mapToStringIfPresent(val -> {
            if (val instanceof String) {
                return (String)val;
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type String, but it was not.", this.identifier()));
        });
    }

    default public ToBigDecimalNullable<ENTITY> mapToBigDecimalIfPresent(Function<V, BigDecimal> mapper) {
        return new FieldToBigDecimalImpl(this, mapper);
    }

    default public ToBigDecimalNullable<ENTITY> asBigDecimal() {
        return this.mapToBigDecimalIfPresent(val -> {
            if (val instanceof BigDecimal) {
                return (BigDecimal)val;
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type BigDecimal, but it was not.", this.identifier()));
        });
    }

    default public <E extends Enum<E>> ToEnumNullable<ENTITY, E> mapToEnumIfPresent(Function<V, E> mapper, Class<E> enumClass) {
        return new FieldToEnumImpl(this, mapper, enumClass);
    }

    default public <E extends Enum<E>> ToEnumNullable<ENTITY, E> asEnum(Class<E> enumClass) {
        return this.mapToEnumIfPresent(val -> {
            if (enumClass.isInstance(val)) {
                return (Enum)enumClass.cast(val);
            }
            throw new SpeedmentFieldException(String.format("Expected field %s to be of type %s, but it was not.", enumClass.getName(), this.identifier()));
        }, enumClass);
    }
}

