/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.field.ByteField;
import com.speedment.runtime.field.ByteForeignKeyField;
import com.speedment.runtime.field.comparator.ByteFieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.ByteFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.BackwardFinderImpl;
import com.speedment.runtime.field.internal.method.FindFromByte;
import com.speedment.runtime.field.internal.method.GetByteImpl;
import com.speedment.runtime.field.internal.predicate.bytes.ByteBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteEqualPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteInPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.BackwardFinder;
import com.speedment.runtime.field.method.ByteGetter;
import com.speedment.runtime.field.method.ByteSetter;
import com.speedment.runtime.field.method.FindFrom;
import com.speedment.runtime.field.method.GetByte;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.SpeedmentPredicate;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class ByteForeignKeyFieldImpl<ENTITY, D, FK_ENTITY>
implements ByteField<ENTITY, D>,
ByteForeignKeyField<ENTITY, D, FK_ENTITY> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetByte<ENTITY, D> getter;
    private final ByteSetter<ENTITY> setter;
    private final ByteField<FK_ENTITY, D> referenced;
    private final TypeMapper<D, Byte> typeMapper;
    private final boolean unique;
    private final String tableAlias;

    public ByteForeignKeyFieldImpl(ColumnIdentifier<ENTITY> identifier, ByteGetter<ENTITY> getter, ByteSetter<ENTITY> setter, ByteField<FK_ENTITY, D> referenced, TypeMapper<D, Byte> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetByteImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.referenced = Objects.requireNonNull(referenced);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = identifier.getTableId();
    }

    private ByteForeignKeyFieldImpl(ColumnIdentifier<ENTITY> identifier, ByteGetter<ENTITY> getter, ByteSetter<ENTITY> setter, ByteField<FK_ENTITY, D> referenced, TypeMapper<D, Byte> typeMapper, boolean unique, String tableAlias) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetByteImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.referenced = Objects.requireNonNull(referenced);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = Objects.requireNonNull(tableAlias);
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public ByteSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetByte<ENTITY, D> getter() {
        return this.getter;
    }

    public ByteField<FK_ENTITY, D> getReferencedField() {
        return this.referenced;
    }

    @Override
    public BackwardFinder<FK_ENTITY, ENTITY> backwardFinder(TableIdentifier<ENTITY> identifier, Supplier<Stream<ENTITY>> streamSupplier) {
        return new BackwardFinderImpl(this, identifier, streamSupplier);
    }

    @Override
    public FindFrom<ENTITY, FK_ENTITY> finder(TableIdentifier<FK_ENTITY> identifier, Supplier<Stream<FK_ENTITY>> streamSupplier) {
        return new FindFromByte(this, this.referenced, identifier, streamSupplier);
    }

    @Override
    public TypeMapper<D, Byte> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String tableAlias() {
        return this.tableAlias;
    }

    @Override
    public ByteFieldComparator<ENTITY, D> comparator() {
        return new ByteFieldComparatorImpl(this);
    }

    @Override
    public ByteFieldComparator<ENTITY, D> reversed() {
        return this.comparator().reversed();
    }

    public ByteFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Byte value) {
        return new ByteEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Byte value) {
        return new ByteGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Byte value) {
        return new ByteGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Byte start, Byte end, Inclusion inclusion) {
        return new ByteBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Byte> values) {
        return new ByteInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Byte value) {
        return new ByteNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Byte value) {
        return new ByteLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Byte value) {
        return new ByteLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Byte start, Byte end, Inclusion inclusion) {
        return new ByteNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Byte> values) {
        return new ByteNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public ByteForeignKeyField<ENTITY, D, FK_ENTITY> tableAlias(String tableAlias) {
        Objects.requireNonNull(tableAlias);
        return new ByteForeignKeyFieldImpl<ENTITY, D, FK_ENTITY>(this.identifier, this.getter, this.setter, this.referenced, this.typeMapper, this.unique, tableAlias);
    }
}

