/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.field.CharField;
import com.speedment.runtime.field.CharForeignKeyField;
import com.speedment.runtime.field.comparator.CharFieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.CharFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.BackwardFinderImpl;
import com.speedment.runtime.field.internal.method.FindFromChar;
import com.speedment.runtime.field.internal.method.GetCharImpl;
import com.speedment.runtime.field.internal.predicate.chars.CharBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharEqualPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharInPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.BackwardFinder;
import com.speedment.runtime.field.method.CharGetter;
import com.speedment.runtime.field.method.CharSetter;
import com.speedment.runtime.field.method.FindFrom;
import com.speedment.runtime.field.method.GetChar;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.SpeedmentPredicate;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class CharForeignKeyFieldImpl<ENTITY, D, FK_ENTITY>
implements CharField<ENTITY, D>,
CharForeignKeyField<ENTITY, D, FK_ENTITY> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetChar<ENTITY, D> getter;
    private final CharSetter<ENTITY> setter;
    private final CharField<FK_ENTITY, D> referenced;
    private final TypeMapper<D, Character> typeMapper;
    private final boolean unique;
    private final String tableAlias;

    public CharForeignKeyFieldImpl(ColumnIdentifier<ENTITY> identifier, CharGetter<ENTITY> getter, CharSetter<ENTITY> setter, CharField<FK_ENTITY, D> referenced, TypeMapper<D, Character> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetCharImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.referenced = Objects.requireNonNull(referenced);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = identifier.getTableId();
    }

    private CharForeignKeyFieldImpl(ColumnIdentifier<ENTITY> identifier, CharGetter<ENTITY> getter, CharSetter<ENTITY> setter, CharField<FK_ENTITY, D> referenced, TypeMapper<D, Character> typeMapper, boolean unique, String tableAlias) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetCharImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.referenced = Objects.requireNonNull(referenced);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = Objects.requireNonNull(tableAlias);
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public CharSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetChar<ENTITY, D> getter() {
        return this.getter;
    }

    public CharField<FK_ENTITY, D> getReferencedField() {
        return this.referenced;
    }

    @Override
    public BackwardFinder<FK_ENTITY, ENTITY> backwardFinder(TableIdentifier<ENTITY> identifier, Supplier<Stream<ENTITY>> streamSupplier) {
        return new BackwardFinderImpl(this, identifier, streamSupplier);
    }

    @Override
    public FindFrom<ENTITY, FK_ENTITY> finder(TableIdentifier<FK_ENTITY> identifier, Supplier<Stream<FK_ENTITY>> streamSupplier) {
        return new FindFromChar(this, this.referenced, identifier, streamSupplier);
    }

    @Override
    public TypeMapper<D, Character> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String tableAlias() {
        return this.tableAlias;
    }

    @Override
    public CharFieldComparator<ENTITY, D> comparator() {
        return new CharFieldComparatorImpl(this);
    }

    @Override
    public CharFieldComparator<ENTITY, D> reversed() {
        return this.comparator().reversed();
    }

    public CharFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Character value) {
        return new CharEqualPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Character value) {
        return new CharGreaterThanPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Character value) {
        return new CharGreaterOrEqualPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> between(Character start, Character end, Inclusion inclusion) {
        return new CharBetweenPredicate(this, start.charValue(), end.charValue(), inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Character> values) {
        return new CharInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Character value) {
        return new CharNotEqualPredicate(this, value.charValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Character value) {
        return new CharLessOrEqualPredicate(this, value.charValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Character value) {
        return new CharLessThanPredicate(this, value.charValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Character start, Character end, Inclusion inclusion) {
        return new CharNotBetweenPredicate(this, start.charValue(), end.charValue(), inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Character> values) {
        return new CharNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public CharForeignKeyField<ENTITY, D, FK_ENTITY> tableAlias(String tableAlias) {
        Objects.requireNonNull(tableAlias);
        return new CharForeignKeyFieldImpl<ENTITY, D, FK_ENTITY>(this.identifier, this.getter, this.setter, this.referenced, this.typeMapper, this.unique, tableAlias);
    }
}

