/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.ComparableField;
import com.speedment.runtime.field.Field;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.ReferenceFieldComparatorImpl;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceInPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceIsNullPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.ReferenceGetter;
import com.speedment.runtime.field.method.ReferenceSetter;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.SpeedmentPredicate;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;

public final class ComparableFieldImpl<ENTITY, D, V extends Comparable<? super V>>
implements ComparableField<ENTITY, D, V>,
FieldComparator<ENTITY> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final ReferenceGetter<ENTITY, V> getter;
    private final ReferenceSetter<ENTITY, V> setter;
    private final TypeMapper<D, V> typeMapper;
    private final boolean unique;
    private final String tableAlias;

    public ComparableFieldImpl(ColumnIdentifier<ENTITY> identifier, ReferenceGetter<ENTITY, V> getter, ReferenceSetter<ENTITY, V> setter, TypeMapper<D, V> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = Objects.requireNonNull(getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = identifier.getTableId();
    }

    private ComparableFieldImpl(ColumnIdentifier<ENTITY> identifier, ReferenceGetter<ENTITY, V> getter, ReferenceSetter<ENTITY, V> setter, TypeMapper<D, V> typeMapper, boolean unique, String tableAlias) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = Objects.requireNonNull(getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = Objects.requireNonNull(tableAlias);
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public ReferenceSetter<ENTITY, V> setter() {
        return this.setter;
    }

    @Override
    public ReferenceGetter<ENTITY, V> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, V> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String tableAlias() {
        return this.tableAlias;
    }

    @Override
    public ComparableField<ENTITY, D, V> tableAlias(String tableAlias) {
        return new ComparableFieldImpl<ENTITY, D, V>(this.identifier, this.getter, this.setter, this.typeMapper, this.unique, tableAlias);
    }

    @Override
    public FieldComparator<ENTITY> comparator() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.LAST);
    }

    @Override
    public FieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.FIRST);
    }

    @Override
    public Field<ENTITY> getField() {
        return this;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        Comparable f = (Comparable)this.get(first);
        Comparable s = (Comparable)this.get(second);
        if (f == null && s == null) {
            return 0;
        }
        if (f == null) {
            return 1;
        }
        if (s == null) {
            return -1;
        }
        return f.compareTo(s);
    }

    @Override
    public FieldPredicate<ENTITY> isNull() {
        return new ReferenceIsNullPredicate(this);
    }

    @Override
    public FieldPredicate<ENTITY> equal(V value) {
        return new ReferenceEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(V value) {
        return new ReferenceNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterThan(V value) {
        return new ReferenceGreaterThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterOrEqual(V value) {
        return new ReferenceGreaterOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(V value) {
        return new ReferenceLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(V value) {
        return new ReferenceLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> between(V start, V end, Inclusion inclusion) {
        return new ReferenceBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(V start, V end, Inclusion inclusion) {
        return new ReferenceNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> in(Collection<V> values) {
        return new ReferenceInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<V> values) {
        return new ReferenceNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }
}

