/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.field.DoubleField;
import com.speedment.runtime.field.DoubleForeignKeyField;
import com.speedment.runtime.field.comparator.DoubleFieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.DoubleFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.BackwardFinderImpl;
import com.speedment.runtime.field.internal.method.FindFromDouble;
import com.speedment.runtime.field.internal.method.GetDoubleImpl;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleEqualPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleInPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.BackwardFinder;
import com.speedment.runtime.field.method.DoubleGetter;
import com.speedment.runtime.field.method.DoubleSetter;
import com.speedment.runtime.field.method.FindFrom;
import com.speedment.runtime.field.method.GetDouble;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.SpeedmentPredicate;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class DoubleForeignKeyFieldImpl<ENTITY, D, FK_ENTITY>
implements DoubleField<ENTITY, D>,
DoubleForeignKeyField<ENTITY, D, FK_ENTITY> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetDouble<ENTITY, D> getter;
    private final DoubleSetter<ENTITY> setter;
    private final DoubleField<FK_ENTITY, D> referenced;
    private final TypeMapper<D, Double> typeMapper;
    private final boolean unique;
    private final String tableAlias;

    public DoubleForeignKeyFieldImpl(ColumnIdentifier<ENTITY> identifier, DoubleGetter<ENTITY> getter, DoubleSetter<ENTITY> setter, DoubleField<FK_ENTITY, D> referenced, TypeMapper<D, Double> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetDoubleImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.referenced = Objects.requireNonNull(referenced);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = identifier.getTableId();
    }

    private DoubleForeignKeyFieldImpl(ColumnIdentifier<ENTITY> identifier, DoubleGetter<ENTITY> getter, DoubleSetter<ENTITY> setter, DoubleField<FK_ENTITY, D> referenced, TypeMapper<D, Double> typeMapper, boolean unique, String tableAlias) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetDoubleImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.referenced = Objects.requireNonNull(referenced);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = Objects.requireNonNull(tableAlias);
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public DoubleSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetDouble<ENTITY, D> getter() {
        return this.getter;
    }

    public DoubleField<FK_ENTITY, D> getReferencedField() {
        return this.referenced;
    }

    @Override
    public BackwardFinder<FK_ENTITY, ENTITY> backwardFinder(TableIdentifier<ENTITY> identifier, Supplier<Stream<ENTITY>> streamSupplier) {
        return new BackwardFinderImpl(this, identifier, streamSupplier);
    }

    @Override
    public FindFrom<ENTITY, FK_ENTITY> finder(TableIdentifier<FK_ENTITY> identifier, Supplier<Stream<FK_ENTITY>> streamSupplier) {
        return new FindFromDouble(this, this.referenced, identifier, streamSupplier);
    }

    @Override
    public TypeMapper<D, Double> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String tableAlias() {
        return this.tableAlias;
    }

    @Override
    public DoubleFieldComparator<ENTITY, D> comparator() {
        return new DoubleFieldComparatorImpl(this);
    }

    @Override
    public DoubleFieldComparator<ENTITY, D> reversed() {
        return this.comparator().reversed();
    }

    public DoubleFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Double value) {
        return new DoubleEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Double value) {
        return new DoubleGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Double value) {
        return new DoubleGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Double start, Double end, Inclusion inclusion) {
        return new DoubleBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Double> values) {
        return new DoubleInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Double value) {
        return new DoubleNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Double value) {
        return new DoubleLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Double value) {
        return new DoubleLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Double start, Double end, Inclusion inclusion) {
        return new DoubleNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Double> values) {
        return new DoubleNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public DoubleForeignKeyField<ENTITY, D, FK_ENTITY> tableAlias(String tableAlias) {
        Objects.requireNonNull(tableAlias);
        return new DoubleForeignKeyFieldImpl<ENTITY, D, FK_ENTITY>(this.identifier, this.getter, this.setter, this.referenced, this.typeMapper, this.unique, tableAlias);
    }
}

