/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.EnumField;
import com.speedment.runtime.field.Field;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.ReferenceFieldComparatorImpl;
import com.speedment.runtime.field.internal.predicate.AlwaysFalsePredicate;
import com.speedment.runtime.field.internal.predicate.enums.EnumIsNotNullPredicate;
import com.speedment.runtime.field.internal.predicate.enums.EnumIsNullPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceEqualPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceInPredicate;
import com.speedment.runtime.field.method.ReferenceGetter;
import com.speedment.runtime.field.method.ReferenceSetter;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.SpeedmentPredicate;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class EnumFieldImpl<ENTITY, D, E extends Enum<E>>
implements EnumField<ENTITY, D, E>,
FieldComparator<ENTITY> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final ReferenceGetter<ENTITY, E> getter;
    private final ReferenceSetter<ENTITY, E> setter;
    private final TypeMapper<D, E> typeMapper;
    private final Function<E, String> enumToString;
    private final Function<String, E> stringToEnum;
    private final Class<E> enumClass;
    private final EnumSet<E> constants;
    private final String tableAlias;

    public EnumFieldImpl(ColumnIdentifier<ENTITY> identifier, ReferenceGetter<ENTITY, E> getter, ReferenceSetter<ENTITY, E> setter, TypeMapper<D, E> typeMapper, Function<E, String> enumToString, Function<String, E> stringToEnum, Class<E> enumClass) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = Objects.requireNonNull(getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.enumToString = Objects.requireNonNull(enumToString);
        this.stringToEnum = Objects.requireNonNull(stringToEnum);
        this.enumClass = Objects.requireNonNull(enumClass);
        this.constants = EnumSet.allOf(enumClass);
        this.tableAlias = identifier.getTableId();
    }

    private EnumFieldImpl(ColumnIdentifier<ENTITY> identifier, ReferenceGetter<ENTITY, E> getter, ReferenceSetter<ENTITY, E> setter, TypeMapper<D, E> typeMapper, Function<E, String> enumToString, Function<String, E> stringToEnum, Class<E> enumClass, String tableAlias) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = Objects.requireNonNull(getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.enumToString = Objects.requireNonNull(enumToString);
        this.stringToEnum = Objects.requireNonNull(stringToEnum);
        this.enumClass = Objects.requireNonNull(enumClass);
        this.constants = EnumSet.allOf(enumClass);
        this.tableAlias = Objects.requireNonNull(tableAlias);
    }

    @Override
    public Class<E> enumClass() {
        return this.enumClass;
    }

    @Override
    public EnumSet<E> constants() {
        return EnumSet.allOf(this.enumClass);
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public ReferenceSetter<ENTITY, E> setter() {
        return this.setter;
    }

    @Override
    public ReferenceGetter<ENTITY, E> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, E> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public Function<String, E> stringToEnum() {
        return this.stringToEnum;
    }

    @Override
    public Function<E, String> enumToString() {
        return this.enumToString;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String tableAlias() {
        return this.tableAlias;
    }

    @Override
    public EnumField<ENTITY, D, E> tableAlias(String tableAlias) {
        return new EnumFieldImpl<ENTITY, D, E>(this.identifier, this.getter, this.setter, this.typeMapper, this.enumToString, this.stringToEnum, this.enumClass, tableAlias);
    }

    @Override
    public FieldComparator<ENTITY> comparator() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.LAST);
    }

    @Override
    public FieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.FIRST);
    }

    @Override
    public Field<ENTITY> getField() {
        return this;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        Enum f = (Enum)this.get(first);
        Enum s = (Enum)this.get(second);
        if (f == null && s == null) {
            return 0;
        }
        if (f == null) {
            return 1;
        }
        if (s == null) {
            return -1;
        }
        return f.compareTo(s);
    }

    @Override
    public EnumIsNullPredicate<ENTITY, D, E> isNull() {
        return new EnumIsNullPredicate(this);
    }

    @Override
    public EnumIsNotNullPredicate<ENTITY, D, E> isNotNull() {
        return new EnumIsNotNullPredicate(this);
    }

    @Override
    public SpeedmentPredicate<ENTITY> equal(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) == 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) != 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) < 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) <= 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterThan(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) > 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterOrEqual(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) >= 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> between(E start, E end, Inclusion inclusion) {
        return this.toEntityPredicate(e -> {
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return e.compareTo(start) > 0 && e.compareTo(end) < 0;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return e.compareTo(start) > 0 && e.compareTo(end) <= 0;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return e.compareTo(start) >= 0 && e.compareTo(end) < 0;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return e.compareTo(start) >= 0 && e.compareTo(end) <= 0;
                }
            }
            throw this.newUnsupportedOperationException(inclusion);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(E start, E end, Inclusion inclusion) {
        return this.toEntityPredicate(e -> {
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return e.compareTo(start) <= 0 || e.compareTo(end) >= 0;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return e.compareTo(start) <= 0 || e.compareTo(end) > 0;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return e.compareTo(start) < 0 || e.compareTo(end) >= 0;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return e.compareTo(start) < 0 || e.compareTo(end) > 0;
                }
            }
            throw this.newUnsupportedOperationException(inclusion);
        });
    }

    private UnsupportedOperationException newUnsupportedOperationException(Inclusion inclusion) {
        return new UnsupportedOperationException("Unknown inclusion '" + (Object)((Object)inclusion) + "'.");
    }

    @Override
    public SpeedmentPredicate<ENTITY> in(Collection<E> values) {
        return this.toEntityPredicate(values::contains);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<E> values) {
        return this.toEntityPredicate(e -> !values.contains(e));
    }

    @Override
    public SpeedmentPredicate<ENTITY> equal(String value) {
        return this.toEntityPredicate(e -> value.equals(this.enumToString.apply(e)));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(String value) {
        return this.toEntityPredicate(e -> !value.equals(this.enumToString.apply(e)));
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.compareTo(value) < 0;
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.compareTo(value) <= 0;
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterThan(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.compareTo(value) > 0;
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterOrEqual(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.compareTo(value) >= 0;
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> between(String start, String end, Inclusion inclusion) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            if (str == null) {
                return false;
            }
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return str.compareTo(start) > 0 && str.compareTo(end) < 0;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return str.compareTo(start) > 0 && str.compareTo(end) <= 0;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return str.compareTo(start) >= 0 && str.compareTo(end) < 0;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return str.compareTo(start) >= 0 && str.compareTo(end) <= 0;
                }
            }
            throw this.newUnsupportedOperationException(inclusion);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(String start, String end, Inclusion inclusion) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            if (str == null) {
                return false;
            }
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return str.compareTo(start) <= 0 || str.compareTo(end) >= 0;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return str.compareTo(start) <= 0 || str.compareTo(end) > 0;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return str.compareTo(start) < 0 || str.compareTo(end) >= 0;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return str.compareTo(start) < 0 || str.compareTo(end) > 0;
                }
            }
            throw this.newUnsupportedOperationException(inclusion);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> isEmpty() {
        return this.toEntityPredicate(e -> "".equals(this.enumToString.apply(e)));
    }

    @Override
    public SpeedmentPredicate<ENTITY> equalIgnoreCase(String value) {
        return this.toEntityPredicate(e -> value.equalsIgnoreCase(this.enumToString.apply(e)));
    }

    @Override
    public SpeedmentPredicate<ENTITY> startsWith(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.startsWith(value);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> startsWithIgnoreCase(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.toLowerCase().startsWith(value.toLowerCase());
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> endsWith(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.endsWith(value);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> endsWithIgnoreCase(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.toLowerCase().endsWith(value.toLowerCase());
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> contains(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.contains(value);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> containsIgnoreCase(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && str.toLowerCase().contains(value.toLowerCase());
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> isNotEmpty() {
        return this.toEntityPredicate(e -> !"".equals(this.enumToString.apply(e)));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqualIgnoreCase(String value) {
        return this.toEntityPredicate(e -> !value.equalsIgnoreCase(this.enumToString.apply(e)));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notStartsWith(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && !str.startsWith(value);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEndsWith(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && !str.endsWith(value);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> notContains(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && !str.contains(value);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> notStartsWithIgnoreCase(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && !str.toLowerCase().startsWith(value.toLowerCase());
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEndsWithIgnoreCase(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && !str.toLowerCase().endsWith(value.toLowerCase());
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> notContainsIgnoreCase(String value) {
        return this.toEntityPredicate(e -> {
            String str = this.enumToString.apply(e);
            return str != null && !str.toLowerCase().contains(value.toLowerCase());
        });
    }

    private SpeedmentPredicate<ENTITY> toEntityPredicate(Predicate<E> predicate) {
        EnumSet<E> valid = this.evaluate(predicate);
        switch (valid.size()) {
            case 0: {
                return new AlwaysFalsePredicate(this);
            }
            case 1: {
                return new ReferenceEqualPredicate(this, (Enum)valid.iterator().next());
            }
        }
        return new ReferenceInPredicate(this, valid);
    }

    private EnumSet<E> evaluate(Predicate<E> predicate) {
        EnumSet<E> result = EnumSet.noneOf(this.enumClass);
        this.constants.stream().filter(predicate).forEach(result::add);
        return result;
    }
}

