/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.ReferenceField;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceIsNullPredicate;
import com.speedment.runtime.field.method.ReferenceGetter;
import com.speedment.runtime.field.method.ReferenceSetter;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Objects;

public final class ReferenceFieldImpl<ENTITY, D, V>
implements ReferenceField<ENTITY, D, V> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final ReferenceGetter<ENTITY, V> getter;
    private final ReferenceSetter<ENTITY, V> setter;
    private final TypeMapper<D, V> typeMapper;
    private final boolean unique;
    private final String tableAlias;

    public ReferenceFieldImpl(ColumnIdentifier<ENTITY> identifier, ReferenceGetter<ENTITY, V> getter, ReferenceSetter<ENTITY, V> setter, TypeMapper<D, V> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = Objects.requireNonNull(getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = identifier.getTableId();
    }

    public ReferenceFieldImpl(ColumnIdentifier<ENTITY> identifier, ReferenceGetter<ENTITY, V> getter, ReferenceSetter<ENTITY, V> setter, TypeMapper<D, V> typeMapper, boolean unique, String tableAlias) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = Objects.requireNonNull(getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = Objects.requireNonNull(tableAlias);
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public ReferenceSetter<ENTITY, V> setter() {
        return this.setter;
    }

    @Override
    public ReferenceGetter<ENTITY, V> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, V> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String tableAlias() {
        return this.tableAlias;
    }

    @Override
    public ReferenceField<ENTITY, D, V> tableAlias(String tableAlias) {
        return new ReferenceFieldImpl<ENTITY, D, V>(this.identifier, this.getter, this.setter, this.typeMapper, this.unique, tableAlias);
    }

    @Override
    public FieldPredicate<ENTITY> isNull() {
        return new ReferenceIsNullPredicate(this);
    }
}

