/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal;

import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.ShortField;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.comparator.ShortFieldComparator;
import com.speedment.runtime.field.internal.comparator.ShortFieldComparatorImpl;
import com.speedment.runtime.field.internal.method.GetShortImpl;
import com.speedment.runtime.field.internal.predicate.shorts.ShortBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortEqualPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortGreaterOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortGreaterThanPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortInPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortLessOrEqualPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortLessThanPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortNotBetweenPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortNotEqualPredicate;
import com.speedment.runtime.field.internal.predicate.shorts.ShortNotInPredicate;
import com.speedment.runtime.field.internal.util.CollectionUtil;
import com.speedment.runtime.field.method.GetShort;
import com.speedment.runtime.field.method.ShortGetter;
import com.speedment.runtime.field.method.ShortSetter;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.SpeedmentPredicate;
import com.speedment.runtime.typemapper.TypeMapper;
import java.util.Collection;
import java.util.Objects;

public final class ShortFieldImpl<ENTITY, D>
implements ShortField<ENTITY, D> {
    private final ColumnIdentifier<ENTITY> identifier;
    private final GetShort<ENTITY, D> getter;
    private final ShortSetter<ENTITY> setter;
    private final TypeMapper<D, Short> typeMapper;
    private final boolean unique;
    private final String tableAlias;

    public ShortFieldImpl(ColumnIdentifier<ENTITY> identifier, ShortGetter<ENTITY> getter, ShortSetter<ENTITY> setter, TypeMapper<D, Short> typeMapper, boolean unique) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetShortImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = identifier.getTableId();
    }

    private ShortFieldImpl(ColumnIdentifier<ENTITY> identifier, ShortGetter<ENTITY> getter, ShortSetter<ENTITY> setter, TypeMapper<D, Short> typeMapper, boolean unique, String tableAlias) {
        this.identifier = Objects.requireNonNull(identifier);
        this.getter = new GetShortImpl(this, getter);
        this.setter = Objects.requireNonNull(setter);
        this.typeMapper = Objects.requireNonNull(typeMapper);
        this.unique = unique;
        this.tableAlias = Objects.requireNonNull(tableAlias);
    }

    @Override
    public ColumnIdentifier<ENTITY> identifier() {
        return this.identifier;
    }

    @Override
    public ShortSetter<ENTITY> setter() {
        return this.setter;
    }

    @Override
    public GetShort<ENTITY, D> getter() {
        return this.getter;
    }

    @Override
    public TypeMapper<D, Short> typeMapper() {
        return this.typeMapper;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String tableAlias() {
        return this.tableAlias;
    }

    @Override
    public ShortField<ENTITY, D> tableAlias(String tableAlias) {
        Objects.requireNonNull(tableAlias);
        return new ShortFieldImpl<ENTITY, D>(this.identifier, this.getter, this.setter, this.typeMapper, this.unique, tableAlias);
    }

    @Override
    public ShortFieldComparator<ENTITY, D> comparator() {
        return new ShortFieldComparatorImpl(this);
    }

    @Override
    public ShortFieldComparator<ENTITY, D> reversed() {
        return this.comparator().reversed();
    }

    public ShortFieldComparator<ENTITY, D> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Short value) {
        return new ShortEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Short value) {
        return new ShortGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Short value) {
        return new ShortGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Short start, Short end, Inclusion inclusion) {
        return new ShortBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Short> values) {
        return new ShortInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Short value) {
        return new ShortNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Short value) {
        return new ShortLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Short value) {
        return new ShortLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Short start, Short end, Inclusion inclusion) {
        return new ShortNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Short> values) {
        return new ShortNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }
}

