/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.comparator;

import com.speedment.common.invariant.NullUtil;
import com.speedment.runtime.field.comparator.CharFieldComparator;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.AbstractFieldComparator;
import com.speedment.runtime.field.trait.HasCharValue;
import java.util.Objects;

public final class CharFieldComparatorImpl<ENTITY, D>
extends AbstractFieldComparator<ENTITY>
implements CharFieldComparator<ENTITY, D> {
    private final HasCharValue<ENTITY, D> field;
    private final boolean reversed;

    public CharFieldComparatorImpl(HasCharValue<ENTITY, D> field) {
        this(field, false);
    }

    CharFieldComparatorImpl(HasCharValue<ENTITY, D> field, boolean reversed) {
        this.field = Objects.requireNonNull(field);
        this.reversed = reversed;
    }

    @Override
    public HasCharValue<ENTITY, D> getField() {
        return this.field;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.NONE;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public CharFieldComparatorImpl<ENTITY, D> reversed() {
        return new CharFieldComparatorImpl<ENTITY, D>(this.field, !this.reversed);
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        NullUtil.requireNonNulls(first, second);
        char a = this.field.getAsChar(first);
        char b = this.field.getAsChar(second);
        return this.applyReversed(Character.compare(a, b));
    }

    public int hashCode() {
        return (4049 + Objects.hashCode(this.field.identifier())) * 3109 + Boolean.hashCode(this.reversed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldComparator)) {
            return false;
        }
        FieldComparator casted = (FieldComparator)obj;
        return this.reversed == casted.isReversed() && Objects.equals(this.field.identifier(), casted.getField().identifier());
    }

    public String toString() {
        return "(order by " + this.field.identifier() + " " + (this.reversed ? "descending" : "ascending") + ")";
    }

    private int applyReversed(int compare) {
        if (compare == 0) {
            return 0;
        }
        if (this.reversed) {
            if (compare > 0) {
                return -1;
            }
            return 1;
        }
        if (compare > 0) {
            return 1;
        }
        return -1;
    }
}

