/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.comparator;

import com.speedment.runtime.field.ComparableField;
import com.speedment.runtime.field.comparator.CombinedComparator;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.ByteFieldComparatorImpl;
import com.speedment.runtime.field.internal.comparator.CharFieldComparatorImpl;
import com.speedment.runtime.field.internal.comparator.DoubleFieldComparatorImpl;
import com.speedment.runtime.field.internal.comparator.FloatFieldComparatorImpl;
import com.speedment.runtime.field.internal.comparator.IntFieldComparatorImpl;
import com.speedment.runtime.field.internal.comparator.LongFieldComparatorImpl;
import com.speedment.runtime.field.internal.comparator.ReferenceFieldComparatorImpl;
import com.speedment.runtime.field.internal.comparator.ShortFieldComparatorImpl;
import com.speedment.runtime.field.method.GetByte;
import com.speedment.runtime.field.method.GetChar;
import com.speedment.runtime.field.method.GetDouble;
import com.speedment.runtime.field.method.GetFloat;
import com.speedment.runtime.field.method.GetInt;
import com.speedment.runtime.field.method.GetLong;
import com.speedment.runtime.field.method.GetReference;
import com.speedment.runtime.field.method.GetShort;
import com.speedment.runtime.field.method.Getter;
import com.speedment.runtime.field.trait.HasReferenceValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CombinedComparatorImpl<ENTITY>
implements CombinedComparator<ENTITY> {
    private final List<FieldComparator<? super ENTITY>> comparators;

    public CombinedComparatorImpl(List<FieldComparator<? super ENTITY>> comparators) {
        this.comparators = Objects.requireNonNull(comparators);
    }

    @Override
    public Stream<FieldComparator<? super ENTITY>> stream() {
        return this.comparators.stream();
    }

    @Override
    public int size() {
        return this.comparators.size();
    }

    @Override
    public int compare(ENTITY o1, ENTITY o2) {
        for (FieldComparator<ENTITY> comp : this.comparators) {
            int c = comp.compare(o1, o2);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public CombinedComparator<ENTITY> reversed() {
        return new CombinedComparatorImpl<ENTITY>(this.comparators.stream().map(FieldComparator::reversed).collect(Collectors.toList()));
    }

    @Override
    public Comparator<ENTITY> thenComparing(Comparator<? super ENTITY> other) {
        return this.then(other);
    }

    @Override
    public <U> Comparator<ENTITY> thenComparing(Function<? super ENTITY, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        Getter getter;
        Optional<Comparator<ENTITY>> result;
        if (keyExtractor instanceof Getter && (result = this.then(getter = (Getter)((Object)keyExtractor))).isPresent()) {
            return result.get();
        }
        return (a, b) -> {
            int c = this.compare((ENTITY)a, (ENTITY)b);
            if (c == 0) {
                return keyComparator.compare((Object)keyExtractor.apply((ENTITY)a), (Object)keyExtractor.apply((ENTITY)b));
            }
            return c;
        };
    }

    @Override
    public <U extends Comparable<? super U>> Comparator<ENTITY> thenComparing(Function<? super ENTITY, ? extends U> keyExtractor) {
        Getter getter;
        Optional<Comparator<ENTITY>> result;
        if (keyExtractor instanceof Getter && (result = this.then(getter = (Getter)((Object)keyExtractor))).isPresent()) {
            return result.get();
        }
        return (a, b) -> {
            int c = this.compare((ENTITY)a, (ENTITY)b);
            if (c == 0) {
                Comparable oa = (Comparable)keyExtractor.apply((ENTITY)a);
                Comparable ob = (Comparable)keyExtractor.apply((ENTITY)b);
                if (oa == null && ob == null) {
                    return 0;
                }
                if (oa == null) {
                    return 1;
                }
                if (ob == null) {
                    return -1;
                }
                return oa.compareTo(ob);
            }
            return c;
        };
    }

    @Override
    public Comparator<ENTITY> thenComparingInt(ToIntFunction<? super ENTITY> keyExtractor) {
        Getter getter;
        Optional<Comparator<ENTITY>> result;
        if (keyExtractor instanceof Getter && (result = this.then(getter = (Getter)((Object)keyExtractor))).isPresent()) {
            return result.get();
        }
        return (a, b) -> {
            int c = this.compare((ENTITY)a, (ENTITY)b);
            if (c == 0) {
                int oa = keyExtractor.applyAsInt((ENTITY)a);
                int ob = keyExtractor.applyAsInt((ENTITY)b);
                return Integer.compare(oa, ob);
            }
            return c;
        };
    }

    @Override
    public Comparator<ENTITY> thenComparingLong(ToLongFunction<? super ENTITY> keyExtractor) {
        Getter getter;
        Optional<Comparator<ENTITY>> result;
        if (keyExtractor instanceof Getter && (result = this.then(getter = (Getter)((Object)keyExtractor))).isPresent()) {
            return result.get();
        }
        return (a, b) -> {
            int c = this.compare((ENTITY)a, (ENTITY)b);
            if (c == 0) {
                long oa = keyExtractor.applyAsLong((ENTITY)a);
                long ob = keyExtractor.applyAsLong((ENTITY)b);
                return Long.compare(oa, ob);
            }
            return c;
        };
    }

    @Override
    public Comparator<ENTITY> thenComparingDouble(ToDoubleFunction<? super ENTITY> keyExtractor) {
        Getter getter;
        Optional<Comparator<ENTITY>> result;
        if (keyExtractor instanceof Getter && (result = this.then(getter = (Getter)((Object)keyExtractor))).isPresent()) {
            return result.get();
        }
        return (a, b) -> {
            int c = this.compare((ENTITY)a, (ENTITY)b);
            if (c == 0) {
                double oa = keyExtractor.applyAsDouble((ENTITY)a);
                double ob = keyExtractor.applyAsDouble((ENTITY)b);
                return Double.compare(oa, ob);
            }
            return c;
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CombinedComparator)) {
            return false;
        }
        CombinedComparator that = (CombinedComparator)o;
        Iterator it = this.comparators.iterator();
        return that.stream().allMatch(c -> it.hasNext() && ((FieldComparator)it.next()).equals(c)) && !it.hasNext();
    }

    public int hashCode() {
        return 1299827 * this.comparators.hashCode();
    }

    public String toString() {
        return "CombinedComparatorImpl" + this.comparators;
    }

    private Comparator<ENTITY> then(Comparator<? super ENTITY> other) {
        if (other instanceof FieldComparator) {
            FieldComparator fc = (FieldComparator)other;
            ArrayList<FieldComparator<ENTITY>> copy = new ArrayList<FieldComparator<ENTITY>>(this.comparators);
            copy.add(fc);
            return new CombinedComparatorImpl<ENTITY>(copy);
        }
        if (other instanceof CombinedComparator) {
            CombinedComparator cc = (CombinedComparator)other;
            ArrayList<FieldComparator<? super ENTITY>> copy = new ArrayList<FieldComparator<? super ENTITY>>(this.comparators);
            cc.stream().forEachOrdered(copy::add);
            return new CombinedComparatorImpl<ENTITY>(copy);
        }
        return (a, b) -> {
            int c = this.compare((ENTITY)a, (ENTITY)b);
            return c == 0 ? other.compare((ENTITY)a, (ENTITY)b) : c;
        };
    }

    private <D, V extends Comparable<? super V>> Optional<Comparator<ENTITY>> then(Getter<? super ENTITY> getter) {
        GetReference casted;
        HasReferenceValue field;
        if (getter instanceof GetByte) {
            GetByte casted2 = (GetByte)getter;
            return Optional.of(this.then(new ByteFieldComparatorImpl(casted2.getField())));
        }
        if (getter instanceof GetShort) {
            GetShort casted3 = (GetShort)getter;
            return Optional.of(this.then(new ShortFieldComparatorImpl(casted3.getField())));
        }
        if (getter instanceof GetInt) {
            GetInt casted4 = (GetInt)getter;
            return Optional.of(this.then(new IntFieldComparatorImpl(casted4.getField())));
        }
        if (getter instanceof GetLong) {
            GetLong casted5 = (GetLong)getter;
            return Optional.of(this.then(new LongFieldComparatorImpl(casted5.getField())));
        }
        if (getter instanceof GetFloat) {
            GetFloat casted6 = (GetFloat)getter;
            return Optional.of(this.then(new FloatFieldComparatorImpl(casted6.getField())));
        }
        if (getter instanceof GetDouble) {
            GetDouble casted7 = (GetDouble)getter;
            return Optional.of(this.then(new DoubleFieldComparatorImpl(casted7.getField())));
        }
        if (getter instanceof GetChar) {
            GetChar casted8 = (GetChar)getter;
            return Optional.of(this.then(new CharFieldComparatorImpl(casted8.getField())));
        }
        if (getter instanceof GetReference && (field = (casted = (GetReference)getter).getField()) instanceof ComparableField) {
            return Optional.of(this.then(new ReferenceFieldComparatorImpl((ComparableField)casted.getField(), NullOrder.LAST)));
        }
        return Optional.empty();
    }
}

