/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.comparator;

import com.speedment.common.invariant.NullUtil;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.comparator.LongFieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.internal.comparator.AbstractFieldComparator;
import com.speedment.runtime.field.trait.HasLongValue;
import java.util.Objects;

public final class LongFieldComparatorImpl<ENTITY, D>
extends AbstractFieldComparator<ENTITY>
implements LongFieldComparator<ENTITY, D> {
    private final HasLongValue<ENTITY, D> field;
    private final boolean reversed;

    public LongFieldComparatorImpl(HasLongValue<ENTITY, D> field) {
        this(field, false);
    }

    LongFieldComparatorImpl(HasLongValue<ENTITY, D> field, boolean reversed) {
        this.field = Objects.requireNonNull(field);
        this.reversed = reversed;
    }

    @Override
    public HasLongValue<ENTITY, D> getField() {
        return this.field;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.NONE;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public LongFieldComparatorImpl<ENTITY, D> reversed() {
        return new LongFieldComparatorImpl<ENTITY, D>(this.field, !this.reversed);
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        NullUtil.requireNonNulls(first, second);
        long a = this.field.getAsLong(first);
        long b = this.field.getAsLong(second);
        return this.applyReversed(Long.compare(a, b));
    }

    public int hashCode() {
        return (4049 + Objects.hashCode(this.field.identifier())) * 3109 + Boolean.hashCode(this.reversed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldComparator)) {
            return false;
        }
        FieldComparator casted = (FieldComparator)obj;
        return this.reversed == casted.isReversed() && Objects.equals(this.field.identifier(), casted.getField().identifier());
    }

    public String toString() {
        return "(order by " + this.field.identifier() + " " + (this.reversed ? "descending" : "ascending") + ")";
    }

    private int applyReversed(long compare) {
        if (compare == 0L) {
            return 0;
        }
        if (this.reversed) {
            if (compare > 0L) {
                return -1;
            }
            return 1;
        }
        if (compare > 0L) {
            return 1;
        }
        return -1;
    }
}

