/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.comparator;

import com.speedment.runtime.field.ComparableField;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.comparator.NullOrder;
import com.speedment.runtime.field.comparator.ReferenceFieldComparator;
import com.speedment.runtime.field.internal.comparator.AbstractFieldComparator;
import java.util.Objects;

public final class ReferenceFieldComparatorImpl<ENTITY, D, V extends Comparable<? super V>>
extends AbstractFieldComparator<ENTITY>
implements ReferenceFieldComparator<ENTITY, D, V> {
    private final ComparableField<ENTITY, D, V> field;
    private final NullOrder nullOrder;
    private final boolean reversed;

    public ReferenceFieldComparatorImpl(ComparableField<ENTITY, D, V> field, NullOrder nullOrder) {
        this(field, nullOrder, false);
    }

    ReferenceFieldComparatorImpl(ComparableField<ENTITY, D, V> field, NullOrder nullOrder, boolean reversed) {
        this.field = Objects.requireNonNull(field);
        this.nullOrder = Objects.requireNonNull(nullOrder);
        this.reversed = reversed;
    }

    @Override
    public ComparableField<ENTITY, D, V> getField() {
        return this.field;
    }

    @Override
    public NullOrder getNullOrder() {
        return this.nullOrder;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public FieldComparator<ENTITY> reversed() {
        return new ReferenceFieldComparatorImpl<ENTITY, D, V>(this.field, this.nullOrder, !this.reversed);
    }

    @Override
    public int compare(ENTITY o1, ENTITY o2) {
        Comparable o1Value = (Comparable)this.field.get(Objects.requireNonNull(o1));
        Comparable o2Value = (Comparable)this.field.get(Objects.requireNonNull(o2));
        if (o1Value == null && o2Value == null) {
            if (NullOrder.NONE == this.nullOrder) {
                throw new NullPointerException("Both fields were null and null fields not allowed");
            }
            return 0;
        }
        if (o1Value == null) {
            return this.forNull(Parameter.FIRST);
        }
        if (o2Value == null) {
            return this.forNull(Parameter.SECOND);
        }
        return this.applyReversed(o1Value.compareTo(o2Value));
    }

    public int hashCode() {
        return ((4049 + Objects.hashCode(this.field.identifier())) * 3109 + this.nullOrder.hashCode()) * 1039 + Boolean.hashCode(this.reversed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldComparator)) {
            return false;
        }
        FieldComparator casted = (FieldComparator)obj;
        return this.reversed == casted.isReversed() && this.nullOrder == casted.getNullOrder() && Objects.equals(this.field.identifier(), casted.getField().identifier());
    }

    public String toString() {
        return "(order by " + this.field.identifier() + " " + (this.reversed ? "descending" : "ascending") + ")";
    }

    private int forNull(Parameter parameter) {
        int firstOutcome = Parameter.FIRST == parameter ? -1 : 1;
        int lastOutcome = -firstOutcome;
        switch (this.nullOrder) {
            case FIRST: {
                return this.applyReversed(firstOutcome);
            }
            case LAST: {
                return this.applyReversed(lastOutcome);
            }
            case NONE: {
                throw new NullPointerException("A field was null and null fields not allowed");
            }
        }
        throw new IllegalStateException("Illegal NullOrder");
    }

    private int applyReversed(int compare) {
        return this.reversed ? -compare : compare;
    }

    private static enum Parameter {
        FIRST,
        SECOND;

    }
}

