/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.method;

import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.field.Field;
import com.speedment.runtime.field.exception.SpeedmentFieldException;
import com.speedment.runtime.field.internal.method.AbstractFindFrom;
import com.speedment.runtime.field.trait.HasComparableOperators;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class FindFromReference<ENTITY, FK_ENTITY, V extends Comparable<? super V>, SOURCE extends Field<ENTITY> & HasComparableOperators<ENTITY, V>>
extends AbstractFindFrom<ENTITY, FK_ENTITY, V, SOURCE, HasComparableOperators<FK_ENTITY, V>> {
    public FindFromReference(SOURCE source, HasComparableOperators<FK_ENTITY, V> target, TableIdentifier<FK_ENTITY> identifier, Supplier<Stream<FK_ENTITY>> streamSupplier) {
        super(source, target, identifier, streamSupplier);
    }

    @Override
    public FK_ENTITY apply(ENTITY entity) {
        Comparable value = (Comparable)this.getSourceField().getter().apply(entity);
        if (value == null) {
            return null;
        }
        return this.stream().filter(((HasComparableOperators)this.getTargetField()).equal(value)).findAny().orElseThrow(() -> new SpeedmentFieldException("Error! Could not find any entities in table '" + this.getTableIdentifier() + "' with '" + ((HasComparableOperators)this.getTargetField()).identifier().getColumnId() + "' = '" + value + "'."));
    }
}

