/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.method;

import com.speedment.runtime.field.method.SetToDouble;
import com.speedment.runtime.field.trait.HasDoubleValue;
import java.util.Objects;

public final class SetToDoubleImpl<ENTITY, D>
implements SetToDouble<ENTITY, D> {
    private final HasDoubleValue<ENTITY, D> field;
    private final double newValue;

    public SetToDoubleImpl(HasDoubleValue<ENTITY, D> field, double newValue) {
        this.field = Objects.requireNonNull(field);
        this.newValue = Objects.requireNonNull(newValue);
    }

    @Override
    public HasDoubleValue<ENTITY, D> getField() {
        return this.field;
    }

    @Override
    public double getValue() {
        return this.newValue;
    }

    @Override
    public ENTITY apply(ENTITY entity) {
        this.field.setter().setAsDouble(entity, this.newValue);
        return entity;
    }
}

