/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate;

import com.speedment.common.tuple.Tuple;
import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.field.Field;
import com.speedment.runtime.field.internal.predicate.AbstractPredicate;
import com.speedment.runtime.field.internal.util.Cast;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.predicate.PredicateType;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class AbstractFieldPredicate<ENTITY, FIELD extends Field<ENTITY>>
extends AbstractPredicate<ENTITY>
implements FieldPredicate<ENTITY> {
    private final PredicateType predicateType;
    private final FIELD field;
    private final Predicate<ENTITY> tester;

    protected AbstractFieldPredicate(PredicateType predicateType, FIELD field, Predicate<ENTITY> tester) {
        this.predicateType = Objects.requireNonNull(predicateType);
        this.field = (Field)Objects.requireNonNull(field);
        this.tester = Objects.requireNonNull(tester);
    }

    protected final Predicate<ENTITY> getTester() {
        return this.tester;
    }

    public boolean applyAsBoolean(ENTITY instance) {
        return this.tester.test(instance);
    }

    @Override
    public final PredicateType getPredicateType() {
        return this.predicateType;
    }

    public final FIELD getField() {
        return this.field;
    }

    public String toString() {
        ColumnIdentifier cId = this.field.identifier();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" {").append("field: ").append(cId.getDbmsId()).append('.').append(cId.getSchemaId()).append('.').append(cId.getTableId()).append('.').append(cId.getColumnId()).append(", type: '").append((Object)this.predicateType).append("'");
        Cast.cast(this, Tuple.class).ifPresent(tuple -> {
            for (int i = 0; i < tuple.degree(); ++i) {
                sb.append(", operand ").append(i).append(": ").append(tuple.get(i));
            }
        });
        return sb.append("}").toString();
    }
}

