/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.bytes;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.bytes.ByteBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.predicate.trait.HasInclusion;
import com.speedment.runtime.field.trait.HasByteValue;
import java.util.Objects;

public final class ByteNotBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasByteValue<ENTITY, D>>
implements HasInclusion,
Tuple2<Byte, Byte> {
    private final byte start;
    private final byte end;
    private final Inclusion inclusion;

    public ByteNotBetweenPredicate(HasByteValue<ENTITY, D> field, byte start, byte end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            byte fieldValue = field.getAsByte(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public Byte get0() {
        return this.start;
    }

    public Byte get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public ByteBetweenPredicate<ENTITY, D> negate() {
        return new ByteBetweenPredicate((HasByteValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

