/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.chars;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.chars.CharBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.predicate.trait.HasInclusion;
import com.speedment.runtime.field.trait.HasCharValue;
import java.util.Objects;

public final class CharNotBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasCharValue<ENTITY, D>>
implements HasInclusion,
Tuple2<Character, Character> {
    private final char start;
    private final char end;
    private final Inclusion inclusion;

    public CharNotBetweenPredicate(HasCharValue<ENTITY, D> field, char start, char end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            char fieldValue = field.getAsChar(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public Character get0() {
        return Character.valueOf(this.start);
    }

    public Character get1() {
        return Character.valueOf(this.end);
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public CharBetweenPredicate<ENTITY, D> negate() {
        return new CharBetweenPredicate((HasCharValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

